// =============================================================================
//
//      --- kvi_completionbox_kde.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_application.h"
#include "kvi_completionbox_kde.h"

KviCompletionBox::KviCompletionBox(QWidget *parent, const char *name)
	: KCompletionBox(parent, name)
{
	// Nothing here
}

KviCompletionBox::~KviCompletionBox()
{
	// Nothing here
}

bool KviCompletionBox::activate()
{
	if( selectedItem() ) {
		slotActivated(selectedItem());
		return true;
	}
	return false;
}

void KviCompletionBox::popup(const QPoint &p)
{
	if( count() == 0 )
		hide();
	else {
		ensureCurrentVisible();
		bool block = signalsBlocked();
		blockSignals(true);
		setCurrentItem(0);
		blockSignals(block);
		clearSelection();
		if( !isVisible() ) {
			resize(sizeHint());
			move(p);
			qApp->installEventFilter(this);
			KListBox::show();
		} else if( size().height() < sizeHint().height() )
			resize(sizeHint());
	}
}

QSize KviCompletionBox::sizeHint() const
{
	int ih = itemHeight() + 1;
	int h = QMIN(15 * ih, (int) count() * ih) + 2;
	h = QMAX(h, KListBox::minimumSizeHint().height());

	int w = KListBox::minimumSizeHint().width();
	w = QMAX(KListBox::minimumSizeHint().width(), w);
	return QSize(w, h);
}

#include "m_kvi_completionbox_kde.moc"
