#ifndef _KVI_LINKS_H_INCLUDED_
#define _KVI_LINKS_H_INCLUDED_

// =============================================================================
//
//      --- kvi_links.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_window.h"

class KviListView;
class KviListViewItem;
class KviPopupMenu;

typedef struct KviLink
{
	KviStr host;
	KviStr parent;
	int    hops;
	KviStr description;
};

class KviLinksWindow : public KviWindow
{
	friend class KviServerParser; // Uses our list box
	Q_OBJECT
public:
	KviLinksWindow(KviFrame *lpFrm);
	~KviLinksWindow();
public:
	KviListView       *m_pListView;
	QPtrList<KviLink> *m_pLinkList;
	KviPopupMenu      *m_pHostPopup;
public:
	void endOfLinks();
	void processLink(const char *msg);
	void reset();
protected:
	virtual QPixmap *myIconPtr();

	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual void setProperties(KviWindowProperty *);
	virtual void saveProperties();
protected slots:
	void showHostPopup(KviListViewItem *, const QPoint &p, int c);
	void hostPopupClicked(int id);
private:
	KviListViewItem *insertLink(KviLink *);
	KviListViewItem *getItemByHost(const char *host, KviListViewItem *par);
};

#endif // _KVI_LINKS_H_INCLUDED_
