#ifndef _KVI_BIFF_SYSTRAY_H_INCLUDED_
#define _KVI_BIFF_SYSTRAY_H_INCLUDED_

// =============================================================================
//
//        --- kvi_biff_systray.h ---
//
//   Authors:
//       Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//       Szymon Stefanek <stefanek@tin.it>
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_string.h"
#include "kvi_systray_widget.h"

class KviFrame;
class KviPopupMenu;

class KviBiffSysTray : public KviSysTrayWidget
{
	Q_OBJECT

public:
	KviBiffSysTray(KviSysTray *parent, KviFrame *frm, const char *tooltip);
	~KviBiffSysTray();

	KviFrame *frame();
	virtual QString icon();
	/**
	 * Show text pointed by 'txt' for 'time' ms.<br>
	 * If perm == TRUE it is permanent.
	 */
	void showText(const char *txt, uint time, bool perm);

private slots:
	void slotHide();
	void fillMailboxPopup();
	void showOrginalText();

protected:
	virtual void      paintEvent(QPaintEvent *);
	virtual void mousePressEvent(QMouseEvent *);

private:
	KviFrame     *m_pFrm;
	KviPopupMenu *m_popup;
	KviPopupMenu *m_mBoxPopup;
	bool          m_showingText;
	KviStr        m_textToShow;
	QTimer       *m_pTextTimer;
};

inline KviFrame *KviBiffSysTray::frame()      { return m_pFrm; };

#endif // _KVI_BIFF_SYSTRAY_H_INCLUDED_
