// =============================================================================
//
//      --- kvi_country.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviCountry"

#define __KVIRC_PLUGIN__

#include "kvirc_plugin.h"

/**
 * COUNTRY command
 */

typedef struct KviCountryEntry
{
	char *domain;
	char *country;
};

// TODO: use hashlist instead
static KviCountryEntry countries_table[] =
{
	// .fed.us,   federal
	{ "ac", "Ascension Island" },
	{ "ad", "Andorra" },
	{ "ae", "United Arab Emirates" },
	{ "af", "Afghanistan" },
	{ "ag", "Antigua and Barbuda" },
	{ "ai", "Anguilla" },
	{ "al", "Albania" },
	{ "am", "Armenia" },
	{ "an", "Netherlands Antilles" },
	{ "ao", "Angola" },
	{ "aq", "Antartica" },
	{ "ar", "Argentina", },
	{ "as", "American Samoa" },
	{ "at", "Austria" },
	{ "au", "Australia" },
	{ "aw", "Aruba" },
	{ "az", "Azerbaijan" },
	{ "ba", "Bosnia and Herzegovina" },
	{ "bb", "Barbados" },
	{ "bd", "Bangladesh" },
	{ "be", "Belgium" },
	{ "bf", "Burkina Faso" },
	{ "bg", "Bulgaria" },
	{ "bh", "Bahrain" },
	{ "bi", "Burundi" },
	{ "bj", "Benin" },
	{ "bm", "Bermuda" },
	{ "bn", "Brunei Darussalam" },
	{ "bo", "Bolivia" },
	{ "br", "Brazil" },
	{ "bs", "Bahamas" },
	{ "bt", "Bhutan" },
	{ "bv", "Bouvet Island" },
	{ "bw", "Botswana" },
	{ "by", "Belarus" },
	{ "bz", "Belize" },
	{ "ca", "Canada" },
	{ "cc", "Cocos Islands" },
	{ "cf", "Central African Republic" },
	{ "cg", "Congo" },
	{ "CH", "Confederation of Helvetica (Switzerland)" },
	{ "CI", "Cote D'ivoire" },
	{ "CK", "Cook Islands" },
	{ "CL", "Chile" },
	{ "CM", "Cameroon" },
	{ "CN", "China" },
	{ "CO", "Colombia" },
	{ "CR", "Costa Rica" },
	{ "CS", "Former Czechoslovakia" },
	{ "CU", "Cuba" },
	{ "CV", "Cape Verde" },
	{ "CX", "Christmas Island" },
	{ "CY", "Cyprus" },
	{ "CZ", "Czech Republic" },
	{ "DE", "Germany" },
	{ "DJ", "Djibouti" },
	{ "DK", "Denmark" },
	{ "DM", "Dominica" },
	{ "DO", "Dominican Republic" },
	{ "DZ", "Algeria" },
	{ "EC", "Ecuador" },
	{ "EE", "Estonia" },
	{ "EG", "Egypt" },
	{ "EH", "Western Sahara" },
	{ "ER", "Eritrea" },
	{ "ES", "Spain" },
	{ "ET", "Ethiopia" },
	{ "FI", "Finland" },
	{ "FJ", "Fiji" },
	{ "FK", "Falkland Islands" },
	{ "FM", "Micronesia" },
	{ "FO", "Faroe Islands" },
	{ "FR", "France" },
	{ "FX", "France, Metropolitan" },
	{ "GA", "Gabon" },
	{ "GB", "Great Britain" },
	{ "GD", "Grenada" },
	{ "GE", "Georgia" },
	{ "GF", "French Guiana" },
	{ "GH", "Ghana" },
	{ "GI", "Gibraltar" },
	{ "GL", "Greenland" },
	{ "GM", "Gambia" },
	{ "GN", "Guinea" },
	{ "GP", "Guadeloupe" },
	{ "GQ", "Equatorial Guinea" },
	{ "GR", "Greece (Hellenic Republic)" },
	{ "GS", "S. Georgia and S. Sandwich Isles." },
	{ "GT", "Guatemala" },
	{ "GU", "Guam" },
	{ "GW", "Guinea-Bissau" },
	{ "GY", "Guyana" },
	{ "HK", "Hong Kong" },
	{ "HM", "Heard and McDonald Islands" },
	{ "HN", "Honduras" },
	{ "HR", "Croatia" },
	{ "HT", "Haiti" },
	{ "HU", "Hungary" },
	{ "ID", "Indonesia" },
	{ "IE", "Ireland" },
	{ "IL", "Israel" },
	{ "IN", "India" },
	{ "IO", "British Indian Ocean Territory" },
	{ "IQ", "Iraq" },
	{ "IR", "Iran" },
	{ "IS", "Iceland" },
	{ "IT", "Italy" },
	{ "JM", "Jamaica" },
	{ "JO", "Jordan" },
	{ "JP", "Japan" },
	{ "KE", "Kenya" },
	{ "KG", "Kyrgyzstan" },
	{ "KH", "Cambodia" },
	{ "KI", "Kiribati" },
	{ "KM", "Comoros" },
	{ "KN", "St. Kitts and Nevis" },
	{ "KP", "North Korea" },
	{ "KR", "South Korea" },
	{ "KW", "Kuwait" },
	{ "KY", "Cayman Islands" },
	{ "KZ", "Kazakhstan" },
	{ "LA", "Laos" },
	{ "LB", "Lebanon" },
	{ "LC", "Saint Lucia" },
	{ "LI", "Liechtenstein" },
	{ "LK", "Sri Lanka" },
	{ "LR", "Liberia" },
	{ "LS", "Lesotho" },
	{ "LT", "Lithuania" },
	{ "LU", "Luxembourg" },
	{ "LV", "Latvia" },
	{ "LY", "Libya" },
	{ "MA", "Morocco" },
	{ "MC", "Monaco" },
	{ "MD", "Moldova" },
	{ "MG", "Madagascar" },
	{ "MH", "Marshall Islands" },
	{ "MK", "Macedonia" },
	{ "ML", "Mali" },
	{ "MM", "Myanmar" },
	{ "MN", "Mongolia" },
	{ "MO", "Macau" },
	{ "MP", "Northern Mariana Islands" },
	{ "MQ", "Martinique" },
	{ "MR", "Mauritania" },
	{ "MS", "Montserrat" },
	{ "MT", "Malta" },
	{ "MU", "Mauritius" },
	{ "MV", "Maldives" },
	{ "MW", "Malawi" },
	{ "MX", "Mexico" },
	{ "MY", "Malaysia" },
	{ "MZ", "Mozambique" },
	{ "NA", "Namibia" },
	{ "NC", "New Caledonia" },
	{ "NE", "Niger" },
	{ "NF", "Norfolk Island" },
	{ "NG", "Nigeria" },
	{ "NI", "Nicaragua" },
	{ "NL", "Netherlands" },
	{ "NO", "Norway" },
	{ "NP", "Nepal" },
	{ "NR", "Nauru" },
	{ "NT", "Neutral Zone" },
	{ "NU", "Niue" },
	{ "NZ", "New Zealand (Aotearoa)" },
	{ "OM", "Oman" },
	{ "PA", "Panama" },
	{ "PE", "Peru" },
	{ "PF", "French Polynesia" },
	{ "PG", "Papua New Guinea" },
	{ "PH", "Philippines" },
	{ "PK", "Pakistan" },
	{ "PL", "Poland" },
	{ "PM", "St. Pierre and Miquelon" },
	{ "PN", "Pitcairn" },
	{ "PR", "Puerto Rico" },
	{ "PT", "Portugal" },
	{ "PW", "Palau" },
	{ "PY", "Paraguay" },
	{ "QA", "Qatar" },
	{ "RE", "Reunion" },
	{ "RO", "Romania" },
	{ "RU", "Russian Federation" },
	{ "RW", "Rwanda" },
	{ "SA", "Saudi Arabia" },
	{ "Sb", "Solomon Islands" },
	{ "SC", "Seychelles" },
	{ "SD", "Sudan" },
	{ "SE", "Sweden" },
	{ "SG", "Singapore" },
	{ "SH", "St. Helena" },
	{ "SI", "Slovenia" },
	{ "SJ", "Svalbard and Jan Mayen Islands" },
	{ "SK", "Slovak Republic" },
	{ "SL", "Sierra Leone" },
	{ "SM", "San Marino" },
	{ "SN", "Senegal" },
	{ "SO", "Somalia" },
	{ "SR", "Suriname" },
	{ "ST", "Sao Tome and Principe" },
	{ "SU", "Former USSR" },
	{ "SV", "El Salvador" },
	{ "SY", "Syria" },
	{ "SZ", "Swaziland" },
	{ "TC", "Turks and Caicos Islands" },
	{ "TD", "Chad" },
	{ "TF", "French Southern Territories" },
	{ "TG", "Togo" },
	{ "TH", "Thailand" },
	{ "TJ", "Tajikistan" },
	{ "TK", "Tokelau" },
	{ "TM", "Turkmenistan" },
	{ "TN", "Tunisia" },
	{ "TO", "Tonga" },
	{ "TP", "East Timor" },
	{ "TR", "Turkey" },
	{ "TT", "Trinidad and Tobago" },
	{ "TV", "Tuvalu" },
	{ "TW", "Taiwan" },
	{ "TZ", "Tanzania" },
	{ "UA", "Ukraine" },
	{ "UG", "Uganda" },
	{ "UK", "United Kingdom" },
	{ "UM", "US Minor Outlying Islands" },
	{ "US", "United States of America" },
	{ "UY", "Uruguay" },
	{ "UZ", "Uzbekistan" },
	{ "VA", "Vatican City State" },
	{ "VC", "St. Vincent and the Grenadines" },
	{ "VE", "Venezuela" },
	{ "VG", "British Virgin Islands" },
	{ "VI", "US Virgin Islands" },
	{ "VN", "Vietnam" },
	{ "VU", "Vanuatu" },
	{ "WF", "Wallis and Futuna Islands" },
	{ "WS", "Samoa" },
	{ "YE", "Yemen" },
	{ "YT", "Mayotte" },
	{ "YU", "Yugoslavia" },
	{ "ZA", "South Africa" },
	{ "ZM", "Zambia" },
	{ "ZR", "Zaire" },
	{ "ZW", "Zimbabwe" },
	{ "COM", "InterNIC Commercial Organization" },
	{ "EDU", "US Educational Institution" },
	{ "GOV", "US Government" },
	{ "INT", "International" },
	{ "MIL", "US Military" },
	{ "NET", "InterNIC Network" },
	{ "ORG", "InterNIC Non-Profit Organization" },
	{ "RPA", "Old-School ARPAnet" },
	{ "ATO", "NATO Field" },
	{ "MED", "US Medical" },
	{ "ARPA", "Reverse DNS" },
	{ 0, 0 }
};

static char *unknown = "Unknown";

const char *country_plugin_get_country(const char *h)
{
	KviStr hostname = h;
	hostname.cutToLast('.');
	if( !(hostname.isUnsignedNum()) ) {
		for( int idx = 0; countries_table[idx].domain; idx++ ) {
			if( kvi_strEqualCI(hostname.ptr(), countries_table[idx].domain) ) {
				return countries_table[idx].country;
				break;
			}
		}
		return unknown;
	}
	return unknown;
}

bool country_plugin_command_country(KviPluginCommandStruct *cmd)
{
	KviStr country;
	KviStr hostname = kvirc_plugin_param(cmd, 1);
	if( hostname.hasData() ) {
		cmd->window->output(KVI_OUT_HAPPY, "Hostname: %s, Country: %s", hostname.ptr(), country_plugin_get_country(hostname.ptr()));
	} else {
		cmd->error    = KVI_ERROR_MissingParameter;
		cmd->errorstr = "No hostname given";
		return false;
	}
	return true;
}

bool country_plugin_function_country(KviPluginCommandStruct *cmd, KviStr *str)
{
	KviStr country;

	KviStr hostname = kvirc_plugin_param(cmd, 1);
	if( hostname.hasData() )
		country = country_plugin_get_country(hostname.ptr());
	else
		country = "No hostname given";

	str->append(country);

	return true;
}

bool country_plugin_init(KviPluginCommandStruct *cmd)
{
	//
	// Here we register the /COUNTRY command and the $country() identifier.
	// The user will be able to use it by typing /COUNTRY
	// or by calling the $country(<hostname>) identifier in the scripts
	//

	kvirc_plugin_register_command (cmd->handle, "COUNTRY", country_plugin_command_country);
	kvirc_plugin_register_function(cmd->handle, "COUNTRY", country_plugin_function_country);

	// If your plugin initialization fails for some reason,
	// you should return 'false' here.
	// In that case the plugin will be immediately unloaded
	// (without executing the cleanup routine).
	// If your plugin initialization went ok, just return
	// 'true' here to indicate success... you are up and running.

	return true;
}

/**
 * The plugin definition structure.<br>
 * It MUST be named 'kvirc_plugin'.
 * It is the first symbol that KVIrc looks for in a plugin.
 */
KviPlugin kvirc_plugin =
{
	"Country",                                      // Plugin name
	"Maps TLDs in hostnames to countries",          // Description
	"1.0",                                          // Version
	"Szymon Stefanek <stefanek@tin.it>",            // Author info
	"<html>"
		"Exports the <b>/COUNTRY</b> command<br>"
		"and the identifier <pre>$country().</pre>"
		"</html>",                                  // Commands | styles exported
	country_plugin_init,                            // Init routine
	0,                                              // Cleanup routine
	0,                                              // Configuration routine
	0                                               // Help routine
};
