#ifndef _KVI_SIMPLE_EDITOR_H_INCLUDED_
#define _KVI_SIMPLE_EDITOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_simple_editor.cpp ---
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qtextedit.h>

class KviAccel;
class KviEditorSyntaxHighlighter;
class KviPopupMenu;
class KviSimpleFindWidget;

typedef struct KviSimpleEditorKeystroke
{
	int  ascii;
	int  state;
	int  key;
};

class KviSimpleEditor : public QTextEdit
{
	Q_OBJECT
public:
	KviSimpleEditor(QWidget *parent);
	~KviSimpleEditor();

	/**
	 * Returns true if the file has not been modified.
	 * If the file has been modified it opens a dialog
	 * that asks the user to save or discard the changes
	 * and gives the possibility to cancel the close event.
	 * If the user cancels the close event this function returns false.
	 */
	bool closeFile();

	QString fileName();

	void clear();
	bool loadFile(const QString &);
	bool saveFile(const QString &);

	void indent();
	void unindent();
	void commentOut(bool bAlternative);
	void removeComment();
public slots:
	bool saveFile();
	bool saveFileAs();
	void recordKeystrokes();
	void replayKeystrokes();
	void toggleFindWidget();
	void switchMode();
	void findNext();
	void findPrev();
	void findNextRegexp();
	void findPrevRegexp();
	void replace();
	void replaceAll();
	void replaceAllRegexp();
	void replaceAllInSelection();
	void replaceAllInSelectionRegexp();
	void replaceAndFindNext();
	void replaceAndFindNextRegexp();
signals:
	void modifyStateChanged(KviSimpleEditor *, bool bModified);
	void fileNameChanged(KviSimpleEditor *, const QString &newFileName);
	void saved(const QString &fileName);
	void saveProgress(const QString &fileName, int progress);
	void cursorPositionChanged(KviSimpleEditor *, int row, int col);
	void recordingKeystrokes(bool bRecording);
	void gainedFocus(KviSimpleEditor *);
	void textMessage(KviSimpleEditor *, const QString &msg);
protected:
	bool eventFilter(QObject *, QEvent *);
	virtual void   keyPressEvent(QKeyEvent *);
	virtual void     resizeEvent(QResizeEvent *);
	virtual void mousePressEvent(QMouseEvent *);

	void loadFile();
	void contextPopup();

	QPtrList<KviSimpleEditorKeystroke> *m_pKeystrokes;
	KviPopupMenu                       *m_pContextPopup;
	KviPopupMenu                       *m_pFindPopup;
	KviSimpleFindWidget                *m_pFindWidget;
private:
	KviAccel                   *m_pAccel;
	KviEditorSyntaxHighlighter *m_pHighlighter;
	QString                     m_szFileName;
	QPoint                      m_lastFindWidgetPosition;
	bool                        m_bRecordingKeystrokes;

	void recalculateFindWidget();
};

#endif // _KVI_SIMPLE_EDITOR_H_INCLUDED_
