/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WM_ARCH_H
#define WM_ARCH_H

#include <qstringlist.h>

/* get */
int wm_getWirelessInterfaces(QStringList& ifList);
int wm_openIFSocket(const char *ifname);
void wm_closeIFSocket(int sock);
void wm_getESSID(int sock, const char *ifname, char *buf, int len);
int wm_getBitrate(int sock, const char *ifname);
int wm_getQuality(int sock, const char *ifname);
int wm_getPowerMgmt(int sock, const char *ifname);
bool wm_isOnACPower();
void wm_getTransferBytes(const char *ifname,
                         unsigned long long *rx, unsigned long long *tx);
void wm_getBitrateList(int sock, const char *ifname,
                       QValueList<int>& brList);

/* set */
int wm_setBitrate(int sock, const char *ifname, int rate);
int wm_setPowerMgmt(int sock, const char *ifname, int mode);

/* cap */
bool wm_capSettings();
bool wm_capACPower();

#endif /* WM_ARCH_H */
