/***************************************************************************
 *   Copyright (C) 2004 by stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_garp.h"

#include <kmountpoint.h>
#include <kpopupmenu.h>


#include "xeconfiguration.h"
#include "xgdocker.h"
#include "xgicon.h"


#include "xeplugin_garp.moc"

//#undef ENABLE_FINAL

XEPlugin_GARP::XEPlugin_GARP(QObject *parent, const char *name)
 : QObject(parent, name)
{
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GARP");
	#endif
	XEObject::xPluginAdd(this);
	KDEWatch	=new KDirWatch();
}


XEPlugin_GARP::~XEPlugin_GARP()
{
}






void XEPlugin_GARP::xSetup()
{

#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GARP::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
}


void XEPlugin_GARP::xStart()
{
	
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GARP::xStart()");
	#endif
	KDEWatch->addFile("/proc/net/arp");
	connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->startScan();
	//QTimer *PollingTimer=new QTimer();
	//connect(PollingTimer,SIGNAL(),this,SLOT(polling()));
	QTimer::singleShot( 60*1000, this, SLOT(polling()) );
}


void XEPlugin_GARP::xStop()
{
    /// @todo implement me
}


void XEPlugin_GARP::MountAdded(const QString &newMount)
{
	for(unsigned int i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
#ifndef ENABLE_FINAL
			qWarning("Matched icon for this mountpoint");
#endif
			// searching if it's being showed
			for(unsigned int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
#ifndef ENABLE_FINAL
				qWarning("xeplugin_gmounts.cpp:108");
#endif
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
#ifndef ENABLE_FINAL
				qWarning("NON e' null");
				qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->OverText);
#endif
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
#ifndef ENABLE_FINAL
			qWarning("xeplugin_gmounts.cpp:115");
#endif
	// if there are too icons, we can exit because no more will be added
	if(ActiveConfiguration->ObjectsIcons.count()>=ActiveConfiguration->Engine.MaxIconsShowed)return;
			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.className=name();
			
			addedCfg->Tasks.Proces.clear();
			
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;
			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
		}
	}
}


void XEPlugin_GARP::dirty(const QString &)
{
/*
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (int i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
		qWarning(DeviceMounted->mountPoint());
		
		MountAdded(DeviceMounted->mountPoint());
		
	}
*/
//qWarning("qfile");
	QFile f("/proc/net/arp");
	QStringList devList;
        if(f.open( IO_ReadOnly)!=false)
	{
//qWarning("read");
		char bufferLine[257];
		for(int i=0;;i++)
		{
//qWarning("loop");
			memset(bufferLine,0,257);
			if(f.readLine(bufferLine,256)<1)break;
			QString textLine(bufferLine);
			if(textLine.find("Device")>=0 ||textLine.find("00:00:00:00:00:00")>=0)
			{
				i--;
				continue;
			}
			int tspace=textLine.find(" ");
			QString sIP=textLine.left(tspace);
			textLine.truncate(tspace);
			
			devList.append(sIP);
			MountAdded(sIP);
			
			//qWarning(sIP);
		}
		
		f.close();
	}
	
	
	// ok now removing the old one
	int indexfind;
	for(unsigned int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==name())
		{
			indexfind=-1;
			for (unsigned int i=0;i<devList.count();i++)
			{
				
if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==devList[i]){
					indexfind=i;
					break;
				}
			}
			if(indexfind<0)
			{
				// remove it
				xGDocker->iconRemove(iconIndex);
			}
		}
	}
	
}


void XEPlugin_GARP::xGetParameter(const QString,QString&)
{
    /// @todo implement me
}


void XEPlugin_GARP::xGetParameterList(QStringList*)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GARP::polling
 */
void XEPlugin_GARP::polling()
{
    /// @todo implement me
	dirty("ciao");
	QTimer::singleShot( 60*1000, this, SLOT(polling()) );
}
