/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <xeplugin_gatrash.h>
#include <xeobject.h>
#include <xeconfiguration.h>
#include <xgicon.h>
#include <xgdocker.h>


#include <kconfig.h>
#include <qdir.h>
#include <kurl.h>

#include <kiconloader.h>
#include <kurlrequester.h>
#include <kglobalsettings.h> 
#include <kiconloader.h>
#include <qpopupmenu.h>
#include <kpopupmenu.h>
#include <krun.h>


#include "xeplugin_gatrash.moc"

XEPlugin_GATrash::XEPlugin_GATrash(QObject *parent, const char *name)
 : XEPlugin_GApplet(parent, name)
{
	// ok, here we have to find the path of trash
	KConfig *cfg=KGlobal::config();
	cfg->setGroup("Paths");
	//TrashPath=KURL(cfg->readEntry("Trash"));//.directory();
	//TrashPath=cfg->readEntry("Trash");
	KURLRequester *urTrash ;
	urTrash = new KURLRequester();
	urTrash->setMode( KFile::Directory );
	urTrash->setURL( KGlobalSettings::trashPath() );
	TrashPath=urTrash->url();
	qWarning(QString("Warning I think the trash is here: %1").arg(TrashPath));
	
	KDEWatcher=new KDirWatch();
	connect(KDEWatcher, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
}


XEPlugin_GATrash::~XEPlugin_GATrash()
{
}




/*!
    \fn XEPlugin_GATrash::xPaint()
 */
void XEPlugin_GATrash::xPaint()
{
	if(TrashPath=="")return;
	QDir a;
	a.setPath(TrashPath);
	//if(a.exists()==false)return;
	a.setFilter(QDir::All);
	KIconLoader KDEIconLoader;
	QPixmap Pixmap;
	if(a.entryList().count()>2)
	{
		QString imgFileNameReal=xGDocker->xFindIconFile("trashcan_full");
		QFile ifr(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)
		{
			Pixmap.load(imgFileNameReal);
			qWarning(imgFileNameReal);
		}
		else
		{
		Pixmap=KDEIconLoader.loadIcon(
				"trashcan_full",
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig
				);
		}
		
		
		
	}
	else
	{
		QString imgFileNameReal=xGDocker->xFindIconFile("trashcan_empty");
		QFile ifr(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)
		{
			Pixmap.load(imgFileNameReal);
			qWarning(imgFileNameReal);
		}
		else
		{
		Pixmap=KDEIconLoader.loadIcon(
				"trashcan_empty",
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig
				);
		}		
	}
	xImgSource=Pixmap.convertToImage();
}


/*!
    \fn XEPlugin_GATrash::dirty(QString &)
 */
void XEPlugin_GATrash::dirty(const QString &newPath)
{
    //if(newPath==TrashPath && xGIcon!=NULL)
    if(xGIcon!=NULL)
    {
    	//xPaint();
	xRefresh();
	/*
	xGIcon->cachePurge();
	xGIcon->xSetSmoothZoom(xGIcon->xZoom);
	xGDocker->xUpdate();
	xGDocker->update();
	*/
	
}
}


/*!
    \fn XEPlugin_GATrash::xGetParameter(const QString,QString&)
 */
void XEPlugin_GATrash::xGetParameter(const QString,QString&)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GATrash::xGetParameterList(QStringList*)
 */
void XEPlugin_GATrash::xGetParameterList(QStringList*)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GATrash::xStop()
 */
void XEPlugin_GATrash::xStop()
{
	KDEWatcher->removeDir(TrashPath);
	XEPlugin_GApplet::xStop();
}


/*!
    \fn XEPlugin_GATrash::xStart()
 */
void XEPlugin_GATrash::xStart()
{
	KDEWatcher->addDir(TrashPath);
	XEPlugin_GApplet::xStart();
}


/*!
    \fn XEPlugin_GATrash::xAttach(QObject *)
 */
void XEPlugin_GATrash::xAttach(QObject *newIcon)
{
	XEPlugin_GApplet::xAttach(newIcon);
	
	if(PluginPopup)
	{
		// we can add the empty trash
			KIconLoader KDEIcons;
			PluginPopup->insertItem(
			KDEIcons.loadIcon("trashcan_empty",KIcon::Small)
			,"Empty trash",
			this,SLOT(xEmptyTrash()));
		
	}
}


/*!
    \fn XEPlugin_GATrash::xEmptyTrash()
 */
void XEPlugin_GATrash::xEmptyTrash()
{

	QString runcmd,trashempty,tmpcmd;
	trashempty=QString("rm -Rf %1/*").arg(TrashPath);
	tmpcmd=QString("\"Are you sure to run this cmd:\n%1\nIf you are a developer please help me to found the right KDE api to empty the trash without rm, thanks: stefano@xiaprojects.com\"").arg(trashempty);
	runcmd=QString("kdialog --warningyesno %1 && %1").arg(tmpcmd).arg(trashempty);
	
	qWarning(QString("Warning you are going to empty the Trash! [%1]").arg(runcmd));
	
	KRun::runCommand(runcmd);
}
