/***************************************************************************
                          kxetexteditordialog.cpp  -  description
                             -------------------
    begin                : Ne pro 14 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxetexteditordialog.h"

#include "kxmleditorfactory.h"
#include "kxeconfiguration.h"
#include "kxetextviewsettings.h"

#include <qdom.h>
#include <qpushbutton.h>

#include <kmessagebox.h>
#include <ktextedit.h>
#include <klocale.h>
#include <kdebug.h>

KXETextEditorDialog::KXETextEditorDialog(QWidget *parent, const char *name)
  : KXETextEditorDialogBase(parent,name)
{
  m_pSyntaxHighlighter = new KXESyntaxHighlighter(m_pTextEditor);

  connect( m_pTextEditor, SIGNAL(textChanged()), this, SLOT(slotTextChanged()) );

  // Apply current configuration
  slotTextViewSettingsChanged();
  // and make sure to be informed about its changes.
  connect( KXMLEditorFactory::configuration()->textview(), SIGNAL(sigChanged()), this, SLOT(slotTextViewSettingsChanged()) );
}

KXETextEditorDialog::~KXETextEditorDialog()
{
  delete m_pSyntaxHighlighter;
}

void KXETextEditorDialog::slotTextChanged()
{
	if ( m_pTextEditor->text().isEmpty())
		m_pButtonOk->setEnabled(false);
	else
		m_pButtonOk->setEnabled(true);
}

void KXETextEditorDialog::slotValidate()
{
  validateXml(true);
}

void KXETextEditorDialog::accept()
{
  if(validateXml(false))
    KXETextEditorDialogBase::accept();
}

bool KXETextEditorDialog::validateXml(bool bInfoIfOK)
{
  QString strXML = "<root>" + editorText()  + "</root>";

	// create XML documemt from text
	QString strErrorMsg;
  int iErrorLine, iErrorColumn;
	QDomDocument doc;

 	if(!doc.setContent(strXML, true, &strErrorMsg, &iErrorLine, &iErrorColumn) )
 	{ kdDebug() << "KXETextEditorDialog::validateXml: Failed parsing the file." << endl;

    KMessageBox::error(this,
									 		i18n("%1 in line %2, column %3").arg(strErrorMsg).arg(iErrorLine).arg(iErrorColumn),
									 		i18n("Parsing error !"));


    m_pTextEditor->setCursorPosition(iErrorLine - 1, iErrorColumn - 1);

    return false;
	}

  // check if root item already exists
	if(!doc.firstChild().firstChild().isElement())
		{ KMessageBox::sorry(this, i18n("You are changed root element to another node type, while editing !"));
			return false;
		}

  if(bInfoIfOK)
    KMessageBox::information(this, i18n("OK"));

  return true;
}

void KXETextEditorDialog::slotTextViewSettingsChanged()
{
	m_pSyntaxHighlighter->setColorDefaultText( KXMLEditorFactory::configuration()->textview()->colorDfltText() );
	m_pSyntaxHighlighter->setColorElementNames( KXMLEditorFactory::configuration()->textview()->colorElemNames() );
	m_pSyntaxHighlighter->setColorAttributeNames( KXMLEditorFactory::configuration()->textview()->colorAttrNames() );
	m_pSyntaxHighlighter->setColorAttributeValues( KXMLEditorFactory::configuration()->textview()->colorAttrValues() );
	m_pSyntaxHighlighter->setColorXmlSyntaxChars( KXMLEditorFactory::configuration()->textview()->colorSyntaxChars() );
	m_pSyntaxHighlighter->setColorComments( KXMLEditorFactory::configuration()->textview()->colorComments() );
	m_pSyntaxHighlighter->setColorSyntaxError( KXMLEditorFactory::configuration()->textview()->colorErrors() );
	
	if(KXMLEditorFactory::configuration()->textview()->isWrapOn())
	{
		m_pTextEditor->setHScrollBarMode(QScrollView::AlwaysOff);
		m_pTextEditor->setWordWrap(QTextEdit::WidgetWidth);
	}

	m_pSyntaxHighlighter->rehighlight();
}
