/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PALETTEVIEW_H
#define PALETTEVIEW_H

#include <qframe.h>
#include <qtooltip.h>
#include <qvaluevector.h>

class KAction;
class KPrinter;
class KXStitchDoc;

/** Display the colors from the patterns floss list.
    @author Stephen Allewell
  */
class PaletteView : public QFrame, public QToolTip
{
  Q_OBJECT
public:
/** Constructor
    @param doc A pointer to the document object.
    @param parent A pointer to the parent widget.
  */
  PaletteView(KXStitchDoc* doc,QWidget *parent);
/** Destructor
  */
  virtual ~PaletteView();

/** Print the floss palette to a printer
    @return The number of pages printed so far
    @param printer Pointer to the KPrinter object being printed to
    @param painter Pointer to the QPainter object that is to be drawn on
    @param width Width of the page (from the device metrics)
    @param height Height of the page (from the device metrics)
    @param page The number of pages printed so far
  */
  int print(KPrinter *printer, QPainter *painter, int width, int height, int page);
/** Set the current color to the color index specified.
    @param i Index into the document color palette.
  */
  void setCurrentColor(int);
/** Reconfigure the view in response to the users configuration
  */
  void configure();

protected:
/** Reimplemented from the base class.
    Draw the palette.
    @param p Pointer to the QPainter to use.
  */
  virtual void drawContents(QPainter *p);
/** Reimplemented from the base class.
    Display the context menu for the paletteView
    @param e QContextMouseEvent describing the mouse action
  */
  virtual void contextMenuEvent(QContextMenuEvent* e);
/** Reimplemented from the base class.
    Check if the left mouse button was pressed on a displayed color, and if so,
    set the current color.
    @param e QMouseEvent describing the mouse action.
  */
  virtual void mousePressEvent(QMouseEvent *e);
/** Reimplemented from the base class.
    Checks if the mouse is over a displayed color, and if so, display a tooltip
    describing details about the color.
    @param p QPoint defining the position of the mouse.
  */
  virtual void maybeTip(const QPoint &p);

private slots:
/** Save the palette to a scheme
  */
  void slotSavePalette();
/** Load a scheme to the palette
  */
  void slotLoadPalette();
/** Create a new palette
  */
  void slotCreatePalette();
/** Toggle the show symbols flag and repaint the view.
  */
  void slotShowSymbols();
/** Set the flag to indicate that a color swap is to be done. Will change the cursor
    to indicate that color swap is in progress.
  */
  void slotPrepareToSwap();
/** Set the flag to indicate that a color replace is to be done. Will change the cursor
    to indicate that color replace is in progress.
  */
  void slotPrepareToReplace();
/** Add colour to palette
  */
  void slotAddColor();
/** remove colors from the palette
  */
  void slotRemoveColors();
/** clear the unused colors from the palette
  */
  void slotClearUnused();

private:
  KAction*          m_savePalette;
  KAction*          m_loadPalette;
  KAction*          m_createPalette;
  KXStitchDoc*      m_doc;
  bool              m_waitingToSwap;
  bool              m_waitingToReplace;
  int               m_rows;
  int               m_cols;
  int               m_cellWidth;
  int               m_cellHeight;
  bool              m_symbols;
  QValueVector<int> m_flosses;
};

#endif
