//LabPlot : DataDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>

#ifdef USE_SOLARIS
#include <ieeefp.h>
#endif

#include <qlabel.h>
#include <qhbox.h>
#include <qcolordialog.h>
#include <qtextstream.h>
#include <qstatusbar.h>
#include <qfiledialog.h>
#include <qtable.h>
#include <qprogressdialog.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kfilterdev.h>
#include <kfilterbase.h>
#include <kimageio.h>
#include "DataDialog.h"
#include "Plot2DSurface.h"
#include "PlotQWT3D.h"
#include "FilterCDF.h"
#include "FilterNETCDF.h"
#include "FilterMAGICK.h"
#include "defs.h"
#include "formatlist.h"

using namespace std;

static const char *inputitems2d[] = {"x | y","x | y | dy","x | y | dx | dy","x | y | dy1 | dy2","y1 | y2 | y3 | ...",0};
static const char *inputitemssurface[] = {"matrix","image",0};
static const char *inputitems3d[] = {"x | y | z","matrix",0};
static const char *inputitemspolar[] = {"phi | r",0};
static const char *inputitemspie[] = {"index | value",0};
static const char *inputitemsternary[] = {"a | b | c",0};
static const char *inputitemsqwt[] = {"matrix","x | y | z",0};

#define MAX_POINTS 1000000

/* Dialog for reading 2D and 3D data*/
DataDialog::DataDialog(Worksheet *p, const char *name, ListDialog *l,int item, PType newtype)
	: Dialog(p, name), l(l), item(item)
{
	mw = p->getMainWin();
	
	GraphList *graphlist=0;
	Style style;
	Symbol symbol;
	QString dat("2d.dat");

	kdDebug()<<"DataDialog "<<endl;
	kdDebug()<<"new type = "<<newtype<<endl;
	
	// set type
	Plot *plot = p->getPlot(p->API());
	if (plot != 0)
		type = plot->Type();
	else
		type = newtype;

	kdDebug()<<"type = "<<type<<endl;

	QString caption;
	switch (type) {
	case P3D:
		caption = i18n("3D Data Dialog");
		dat = QString("3d.dat");
		break;
	case PSURFACE:
		caption = i18n("2D Surface Data Dialog");
		dat = QString("matrix.dat");
		break;
	case P2D:
		caption = i18n("2D Data Dialog");
		break;
	case PPIE:
		caption = i18n("Pie Data Dialog");
		dat=QString("pie.dat");
		break;
	case PPOLAR:
		caption = i18n("Polar Data Dialog");
		break;
	case PTERNARY:
		caption = i18n("Ternary Data Dialog");
		break;
	case PQWT3D:
		caption = i18n("QWT Data Dialog");
		dat = QString("3d.dat");
		break;
	default:
		break;
	}
	caption += i18n(" : ")+QString(name);
	setCaption(caption);

	if (item == -1)		// new graph
		graph = 0;
	else {			// change graph
		graphlist = p->getPlot(p->API())->getGraphList();
		graph = graphlist->getGraph(item);
		style = graph->getStyle();
		symbol = graph->getSymbol();		
	}

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	QHBox *hb = new QHBox(tab1);
	if (graph != 0) dat = graph->Name();
	filele = new KLineEdit(dat,hb);
	KPushButton *newFile = new KPushButton(i18n("Browse"),hb);
	QObject::connect(newFile,SIGNAL(clicked()),SLOT(selectFile()));

	hb = new QHBox(tab1);
	if (graph !=0) {
		reread = new QCheckBox(i18n("Reread Datafile"),hb);
		reread->setChecked(0);
	}
	else
		reread=0;

	KPushButton *infopb = new KPushButton(i18n("File Info"),hb);
	infopb->setMaximumWidth(100);
	QObject::connect(infopb,SIGNAL(clicked()),SLOT(fileInfo()));
	KPushButton *checkpb = new KPushButton(i18n("Check data"),hb);
	checkpb->setMaximumWidth(100);
	QObject::connect(checkpb,SIGNAL(clicked()),SLOT(checkData()));

	hb = new QHBox(tab1);
	new QLabel(i18n("separating character : "),hb);
	readsc = new KLineEdit(i18n("auto"),hb);
	readsc->setMaximumWidth(100);
	new QLabel(i18n("comment character : "),hb);
	commle = new KLineEdit(i18n("#"),hb);
	commle->setMaximumWidth(100);
	
	hb = new QHBox(tab1);
	QLabel *tmp = new QLabel(i18n("Read as : "),hb);
 	tmp->setMaximumWidth(100);
	cbi = new KComboBox(hb);
	// TODO : use plot item when re-calling data dialog
	cbi->setCurrentItem(0);
	switch(type) {
	case P2D:	cbi->insertStrList(inputitems2d);break;
	case PSURFACE:	cbi->insertStrList(inputitemssurface);break;
	case P3D:	cbi->insertStrList(inputitems3d);break;
	case PPOLAR:	cbi->insertStrList(inputitemspolar);break;
	case PPIE:	cbi->insertStrList(inputitemspie);break;
	case PTERNARY:	cbi->insertStrList(inputitemsternary);break;
	case PQWT3D:	cbi->insertStrList(inputitemsqwt);break;
	default: 	break;
	}

	QObject::connect(cbi,SIGNAL(activated(int)),SLOT(updateRead()));

	hb = new QHBox(tab1);
	new QLabel(i18n("Read from column (index = 0) :"),hb);
	new QLabel(i18n("[cdf/netcdf : variable name]"),hb);
	// "audio : 1 = time, 2 = channel 1, 3 = channel 2]"
	hb = new QHBox(tab1);
	readx = new QLabel(hb);
	readxle = new KLineEdit("1",hb);
	ready = new QLabel(hb);
	readyle = new KLineEdit("2",hb);
	readz = new QLabel(hb);
	readzle = new KLineEdit("3",hb);
	readt = new QLabel(hb);
	readtle = new KLineEdit("4",hb);
	
	hb = new QHBox(tab1);
	QStringList interpretlist;
	interpretlist << i18n("double")<< i18n("time")<< i18n("date");
	interpretxcb = new KComboBox(hb);
	interpretxcb->insertStrList(formatList);
	interpretycb = new KComboBox(hb);
	interpretycb->insertStrList(formatList);
	interpretzcb = new KComboBox(hb);
	interpretzcb->insertStrList(formatList);
	interprettcb = new KComboBox(hb);
	interprettcb->insertStrList(formatList);
	
	updateRead();

	hb = new QHBox(tab1);
	new QLabel(i18n("Start Row : "),hb);
	startrow = new KLineEdit("1",hb);
	startrow->setValidator(new QIntValidator(startrow));
	new QLabel(i18n(" End Row : "),hb);
	endrow = new KLineEdit(i18n("END"),hb);
	// no validator here -> make "END" possible

	QString label=dat;
	if (graph != 0) label = graph->Label();
	new QLabel(i18n("Label : "),tab1);
	hb = new QHBox(tab1);
	labelle = new KLineEdit(label,hb);
	KPushButton *setLabelpb = new KPushButton(i18n("Set Label"),hb);
	QObject::connect(setLabelpb,SIGNAL(clicked()),SLOT(setLabel()));

	tw->addTab(tab1,i18n("Parameter"));

	// 3d style -> NoCurve
	if(type == P3D) {
		style.setType(1);
		symbol.setType(SCROSS);
	}

	QVBox *styletab, *annotatetab;
	if(type == PQWT3D) {
		// TODO
	}
	if(type == PSURFACE) {
		styletab=surfaceStyle(tw);
		tw->addTab(styletab,i18n("Style"));
	}
	else {
		styletab=simpleStyle(tw,graph, &style, &symbol);
		annotatetab = annotateValuesTab(tw,graph);
		tw->addTab(styletab,i18n("Style"));
		tw->addTab(annotatetab,i18n("Annotate Values"));
	}

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(agree()));
	QObject::connect(cancel,SIGNAL(clicked()),SLOT(accept()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

//! update readline and label when changing "read as"
void DataDialog::updateRead() {
	kdDebug()<<"DataDialog::updateRead()"<<endl;
	// TODO : QWT plot 3D
	
	if (type == P2D && cbi->currentItem() == 0 || type == PPIE || type == PPOLAR) {	// 2d
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->hide();readzle->hide();interpretzcb->hide();
		readt->hide();readtle->hide();interprettcb->hide();
		if (type == P2D) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
		}
		else if (type == PPIE) {
			readx->setText(i18n(" index : "));
			ready->setText(i18n(" value : "));
		}
		else if (type == PPOLAR) {
			readx->setText(i18n(" phi : "));
			ready->setText(i18n(" r : "));
		}
	}
	else if ( (type == P2D && cbi->currentItem() == 1) || (type == P3D && cbi->currentItem() == 0) || 
		type == PTERNARY || (type == PQWT3D && cbi->currentItem() == 1)) {//3d
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->show();readzle->show();interpretzcb->show();
		readt->hide();readtle->hide();interprettcb->hide();
		if (type == P2D) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" dy : "));
		}
		else if (type == P3D || type == PQWT3D) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" z : "));
		}
		else if (type == PTERNARY) {
			readx->setText(i18n(" a : "));
			ready->setText(i18n(" b : "));
			readz->setText(i18n(" c : "));
		}
	}
	else if (type == P2D && cbi->currentItem() == 4) {	// line
		readx->show();readxle->show();
		readxle->setText("index");
		readxle->setReadOnly(TRUE);
		interpretxcb->hide();
		ready->show();readyle->show();interpretycb->show();
		readyle->setText("1");
		readyle->setReadOnly(TRUE);
	}
	else if (type == P2D) {	// 4d
		readx->show();readxle->show();interpretxcb->show();
		ready->show();readyle->show();interpretycb->show();
		readz->show();readzle->show();interpretzcb->show();
		readt->show();readtle->show();interprettcb->show();
		if (cbi->currentItem() == 2) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" dx : "));
			readt->setText(i18n(" dy : "));
		}
		else if (cbi->currentItem() == 3) {
			readx->setText(i18n(" x : "));
			ready->setText(i18n(" y : "));
			readz->setText(i18n(" dy1 : "));
			readt->setText(i18n(" dy2 : "));
		}
	}
	else {				// matrix
		readx->hide();readxle->hide();interpretxcb->hide();
		ready->hide();readyle->hide();interpretycb->hide();
		readz->hide();readzle->hide();interpretzcb->hide();
		readt->hide();readtle->hide();interprettcb->hide();
	}
}

void DataDialog::checkData() {
	QStringList lines;
      	unsigned int count=0;
	bool imagefile=FALSE;

	QStringList fns = QStringList::split(";",filele->text());
	 for ( QStringList::Iterator it = fns.begin(); it != fns.end(); ++it ) {
		QString filename = *it;
		QFileInfo info(filename);
	
		KDialog *dialog = new KDialog(this);
		if (!filename.isEmpty()) {
			FilterNETCDF ncf = FilterNETCDF(filename);
			FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
			FilterCDF cdf = FilterCDF(filename);
			FilterMAGICK mf = FilterMAGICK(filename);
					
			QString format;
	#ifdef HAVE_MAGICK
			if (((format = QString(QImageIO::imageFormat(filename))) != 0 ) || mf.fileOK()) {
	#else
			if ((format = QString(QImageIO::imageFormat(filename))) != 0) {
	#endif
				// TODO : support gzipped, bzipped images
				kdDebug()<< "IMAGE FOUND !"<<endl;
				imagefile=TRUE;
				QPixmap pm;
	#ifdef HAVE_MAGICK
				if(mf.fileOK())
					pm = mf.Pixmap();
				else
	#endif
					pm.load(filename);
	
				QImage image = pm.convertToImage();
				int width = image.width();
				int height = image.height();
				QIconSet::setIconSize(QIconSet::Small,QSize(width,height));
				QPushButton *pb = new QPushButton(pm,"",dialog);
				dialog->resize(width,height);
				pb->resize(width,height);
				dialog->show();
			}
			else if (ncf.fileOK()) {		// netcdf file
				// get variables from lineedits
				QString xname = readxle->text(), yname = readyle->text(),zname,tname;
	#if QT_VERSION > 0x030007
				if(readz->isShown())
	#else
				if(readz->isVisible())
	#endif
					zname = readzle->text();
	#if QT_VERSION > 0x030007
				if(readt->isShown())
	#else
				if(readt->isVisible())
	#endif
					tname = readtle->text();
	
				int len = ncf.VarLen(xname);
				if(len==0)
					len = ncf.VarLen(yname);
				QProgressDialog progress( "Reading data ...", "Cancel", len, this, "progress", TRUE );
				for (int i=0;i<len;i++) {
					if(i%1000 == 0) progress.setProgress(i);
					qApp->processEvents();
					
					QString line;
					if ( readxle->text() == "0" )
						line += QString::number(i);
					else
						line += QString::number(ncf.Data(xname,i));
					if ( readyle->text() == "0" )
						line += ' '+QString::number(i);
					else
						line += ' '+QString::number(ncf.Data(yname,i));
					count=2;
	#if QT_VERSION > 0x030007
					if(readz->isShown()) {
	#else
					if(readz->isVisible()) {
	#endif
						if ( readzle->text() == "0" )
							line += ' '+QString::number(i);
						else
						line += ' '+QString::number(ncf.Data(zname,i));
						count=3;
					}
	#if QT_VERSION > 0x030007
					if(readt->isShown()) {
	#else
					if(readt->isVisible()) {
	#endif
						if ( readtle->text() == "0" )
							line += ' '+QString::number(i);
						else
							line += ' '+QString::number(ncf.Data(tname,i));
						count=4;
					}
	
					lines += line;
				}
			}
	#ifdef HAVE_CDF
			else if (cdf.fileOK()) {		// cdf file
				// get variables from lineedits
				QString xname = readxle->text(), yname = readyle->text(),zname,tname;
				if(readz->isShown())
					zname = readzle->text();
				if(readt->isShown())
					tname = readtle->text();
				
				int len = cdf.VarLen(xname);
				if (len == 0)
					len = cdf.VarLen(yname);
				kdDebug()<<" reading "<<xname<<" vs "<<yname<<endl;
				kdDebug()<<" Length = "<<len<<endl;
				QProgressDialog progress( "Reading data ...", "Cancel", len, this, "progress", TRUE );
				for (int i=0;i<len;i++) {
					if(i%1000 == 0) progress.setProgress(i);
					qApp->processEvents();
					
					QString line;
					if ( readxle->text() == "0" )
						line += QString::number(i);
					else
						line += QString::number(cdf.Data(xname,i));
					if ( readyle->text() == "0" )
						line += ' '+QString::number(i);
					else
						line += ' '+QString::number(cdf.Data(yname,i));
					count=2;
					if(readz->isShown()) {
						if ( readzle->text() == "0" )
							line += ' '+QString::number(i);
						else
							line += ' '+QString::number(cdf.Data(zname,i));
						count=3;
					}
					if(readt->isShown()) {
						if ( readtle->text() == "0" )
							line += ' '+QString::number(i);
						else
							line += ' '+QString::number(cdf.Data(tname,i));
						count=4;
					}
	
					lines += line;
				}
			}
	#endif
			else if (auf.fileOK()) {		// audiofile file
				double *data = auf.Data();
				QProgressDialog progress( "Reading data ...", "Cancel", auf.frameCount(), this, "progress", TRUE );
				
				for (int i=0;i<auf.frameCount();i++) {
					if(i%1000 == 0) progress.setProgress(i);
					qApp->processEvents();
					
					double x=i/auf.sampleRate(), y=0, z=0;
					switch(auf.channelCount()) {
					case 1:
						y=data[i]; break;
					case 2:
						y=data[2*i];
						z = data[2*i+1];
					}
					
					if ( readxle->text() == "0" )
						x=i;
					if ( readyle->text() == "0" )
						y=i;
					if ( readzle->text() == "0" )
						z=i;
					
					QString line;
					
					line += QString::number(x)+' '+QString::number(y);
					count=2;
					
					if(auf.channelCount()==2) {
						line += ' '+QString::number(z);
						count=3;
					}
					lines += line;
				}
				kdDebug()<<"AU OK"<<endl;
			}
			else {		// normal or compressed ascii data
				QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,TRUE);
				if(file==0) file = new QFile(filename);
				
				if ( file->open( IO_ReadOnly )) {
					QTextStream stream(file);
							
					QProgressDialog progress( "Reading data ...", "Cancel", file->size(), this, "progress", TRUE );
					QString line;
					
					while ( !stream.eof() ) {
						if(file->at()%1000 == 0) progress.setProgress(file->at() );
						qApp->processEvents();
						line = stream.readLine();
						line = line.simplifyWhiteSpace();

						// ignore comment lines
						if(line.find(QRegExp(commle->text()))==0)
							continue;

						QStringList oneline;
						if (readsc->text() == i18n("auto"))
							oneline = QStringList::split(' ',line );
						else {
							QChar ch = readsc->text().at(0);
							//kdDebug()<<"SEP CHAR : "<<ch<<endl;
							oneline = QStringList::split(ch,line );
						}
						
						if (count<oneline.count())
							count=oneline.count();
						lines += line;
						if ( progress.wasCancelled())
							return;
					}
				file->close();
				}
				else {
					KMessageBox::error(this, i18n("Sorry. Could not open file for reading!"));
					return;
				}
			}	
		}
	
		// no image -> fill table with values
		if(!imagefile) {
			int j=0;
			QTable *table;
			 if(type == P2D && cbi->currentItem()==4)
			 	table =  new QTable(count,2, dialog);
			else
			 	table = new QTable(lines.count(),count, dialog);

			// generic label
			table->horizontalHeader()->setLabel( 0, QString( "X" ) );
			table->horizontalHeader()->setLabel( 1, QString( "Y" ) );
			table->horizontalHeader()->setLabel( 2, QString( "Z" ) );
	
			for ( QStringList::Iterator it = lines.begin(); it != lines.end(); ++it ) {
				QStringList oneline;
				if (readsc->text() == i18n("auto"))
					oneline = QStringList::split(' ', *it );
				else
					oneline = QStringList::split(readsc->text().at(0), *it );
				int k=0;
				for ( QStringList::Iterator it2 = oneline.begin(); it2 != oneline.end(); ++it2 ) {
					if (type == P2D && cbi->currentItem() == 4) {
						table->setText(k,0,QString::number(k+1));
						table->setText(k,1,*it2);
						k++;
					}
					else
						table->setText(j,k++,*it2);
				}
				j++;
			}
			table->setLeftMargin(50);
			dialog->show();
		}
	}
}

void DataDialog::applyStyle() {
	if(type == PSURFACE) {
		Plot2DSurface *plot = (Plot2DSurface *)p->getPlot(p->API());

		if (plot) {
			plot->enableDensity(dcb->isChecked());
			plot->enableContour(ccb->isChecked());
			plot->setNumber(numberle->text().toInt());
			plot->setPalette(pcb->currentItem());
			plot->setContourColor(contourcolor->color());
			plot->setColoredContour(coloredcb->isChecked());
			plot->setMesh(meshcb->isChecked());
			plot->setRelative(relativecb->isChecked());
			plot->setBrush(dbrushcb->currentItem());
			plot->setThreshold(thresholdle->text().toDouble());
		}
	}
	else {
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),widthle->text().toInt(),
			pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());

		if (graph) {
			graph->setStyle(style);
			graph->setSymbol(symbol);
			graph->setAnnotateValues(av);
		}
	}

	QString label = labelle->text();
	kdDebug()<<"Label : "<<label<<endl;
	if (graph)
		graph->setLabel(label);

	p->updatePixmap();
}

int DataDialog::agree() {
	if (reread == 0 || reread->isChecked()) {
		if (int status = addData())
			return status;
	}

	applyStyle();

	return 0;
}

void DataDialog::selectFile() {
	QStringList f = QFileDialog::getOpenFileNames(QString(""),QString(""), this );
	if (! f.isEmpty() )
		filele->setText(f.join(";"));
}

//! read data file
int DataDialog::addData() {
	if(graph != 0)
		p->getPlot(p->API())->getGraphList()->delGraph(item);

	QString label = labelle->text();
	
	QStringList fns = QStringList::split(";",filele->text());
	 for ( QStringList::Iterator it = fns.begin(); it != fns.end(); ++it ) {
		QString filename = *it;

		if (!filename.isEmpty()) {
			QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,TRUE);
			if(file==0) file = new QFile(filename);
	
			FilterMAGICK mf = FilterMAGICK(filename);
			// reading image
			QString format;
#ifdef HAVE_MAGICK
			if (((format = QString(QImageIO::imageFormat(filename))) != 0) || mf.fileOK()) {
#else
			if ((format = QString(QImageIO::imageFormat(filename))) != 0) {
#endif
				QPixmap pm;
#ifdef HAVE_MAGICK
				if(mf.fileOK())
					pm = mf.Pixmap();
				else
#endif
					pm.load(filename);
	
				QImage image = pm.convertToImage();
				int width = image.width();
				int height = image.height();
				//kdDebug() <<" Width/Height : "<<width<<' '<<height<<endl;
				//kdDebug() <<" Depth : "<<image.depth()<<endl;
	
				if (type == P2D || type == PPIE || type == PPOLAR ) {		// x-y
					Point *ptr = new Point[width*height];
					double ymin=0, ymax=1;
					for (int i=0;i<width;i++) {
						for (int j=0;j<height;j++) {
							double x = j+i*height;
							double y = (double) qGray(image.pixel(i,j));
	
							if (i == 0 && j == 0) {
								ymin=ymax=y;
							}
							else {
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
							}
							ptr[j+i*height].setPoint(x,y);
						}
					}
					LRange range[2];
					range[0] = LRange(0,width*height);
					range[1] = LRange(ymin,ymax);
	
					Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
						widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
					Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
						(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
					Graph2D *g = new Graph2D(filename.latin1(),label,range,SDATA,type,
								style,symbol,ptr,width*height);
	
					AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
					g->setAnnotateValues(av);	
	
					p->addGraph2D(g);
				}
				else if ( (type == P2D && cbi->currentItem() == 1) || (type == P3D && cbi->currentItem() == 0) 
					|| type == PTERNARY || (type == PQWT3D && cbi->currentItem() == 1)) {	// x-y-z
					Point3D *ptr = new Point3D[MAX_POINTS];	// better method needed
					double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
					for (int i=0;i<width;i++) {
						for (int j=0;j<height;j++) {
							double x = i, y = j, z = (double) qGray(image.pixel(i,j));
	
							if (i == 0 && j == 0) {
								zmin=zmax=z;
							}
							else {
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
							}
							ptr[j+i*height].setPoint(x,y,z);
						}
					}
	
					LRange range[3];
					range[0] = LRange(xmin,xmax);
					range[1] = LRange(ymin,ymax);
					range[2] = LRange(zmin,zmax);
	
					Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),widthle->text().toInt(),
						pencb->currentItem(),brushcb->currentItem());
					Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
						(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	
					Graph3D *g = new Graph3D(filename.latin1(),label,range,SDATA,
						type,style,symbol,ptr,width*height,1);
					AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
					g->setAnnotateValues(av);
					p->addGraph3D(g);
				}
				else if ((type == PSURFACE && cbi->currentItem() == 0) || (type == P3D && cbi->currentItem() == 1)) {
						// matrix
					double *ptr=new double[width*height];
					double zmin=0,zmax=1;
					for (int i=0;i<height;i++) {
						for (int j=0;j<width;j++) {
							double z = (double) qGray(image.pixel(j,i));
	
							if (i == 0 && j == 0) {
								zmin=zmax=z;
							}
							else {
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
							}
							ptr[j+i*width] = z;
						}
					}
	
					LRange range[3];
					range[0] = LRange(0,width);
					range[1] = LRange(0,height);
					range[2] = LRange(zmin,zmax);
	
					GraphM *g;
	
					if (type == PSURFACE) {
						Style style(0);
						Symbol symbol(SNONE);
						g = new GraphM(filename.latin1(),label,range,SDATA,type,style,symbol,ptr,width,height);
					}
					else {
						Style style(cb2->currentItem(),color->color(), filled->isChecked(), fcolor->color(), 
							widthle->text().toInt(), pencb->currentItem(),brushcb->currentItem());
						Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
						(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
						g = new GraphM(filename.latin1(),label,range,SDATA,type,style,symbol,ptr,width,height);
					}
					p->addGraphM(g,type);
				}
				else if (type == PSURFACE && cbi->currentItem() == 1) { // image
					// create GRAPHIMAGE
					Style style(0);
					Symbol symbol(SNONE);
					
					LRange range[3];
					range[0] = LRange(0,width);
					range[1] = LRange(0,height);
					range[2] = LRange(0,1);		// TODO
					GraphIMAGE *g = new GraphIMAGE(filename.latin1(),label,range,SDATA,
						type,style,symbol,pm,width,height);
					p->addGraphIMAGE(g);
					Plot *plot = p->getPlot(p->API());
					plot->getLegend()->enable(FALSE);	// disable legend
					// occupy space of legend for drawing area (bad hack :-\)
					//int xmax = (int)(p->width()*(plot->getSize().X()*plot->getP2().X()+plot->getPosition().X()));
					//plot->setXMax(xmax+(int)(120*plot->getSize().X()),p->width());
	
				}
				else if (type == P2D && cbi->currentItem() == 2) { // x-y-dx-dy or x-y-dy1-dy2
					// TODO : from image ???
				}
			}
			else if ( file->open( IO_ReadOnly )) {		// normal data (not image)
				QTextStream t(file);
				int startRow = startrow->text().toInt()-1;
				int endRow;
				if(endrow->text() == i18n("END"))
					endRow = MAX_POINTS;
				else
					endRow = endrow->text().toInt()-1;
	
				kdDebug()<<"STARTROW = "<<startRow<<endl;
	
				QFileInfo info(filename);		// for ending of file
				FilterNETCDF ncf = FilterNETCDF(filename);
				FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
				FilterCDF cdf = FilterCDF(filename);
	
				if ( (type == P2D && (cbi->currentItem() == 0 || cbi->currentItem() == 4 ) ) || 
					type == PPIE  || type == PPOLAR) {	// x-y
					Point *ptr = new Point[MAX_POINTS];	// better method needed
					double x=0, y=0, xmin=0, xmax=1, ymin=0, ymax=1;
					int i=0;
	
					if (ncf.fileOK()) {		// netcdf file
						QString xname = readxle->text(), yname = readyle->text();
						
						QProgressDialog progress( "Reading data ...", "Cancel", ncf.VarLen(xname)-startRow, this,
							"progress", TRUE );
						
						int len = ncf.VarLen(xname);
						if (len==0)
							len = ncf.VarLen(yname);

						for (i=startRow;i<len;i++) {
							if(i%1000 == 0) progress.setProgress(i);
							qApp->processEvents();
							
							double x=ncf.Data(xname,i), y=ncf.Data(yname,i);
							
							// index
							if ( readxle->text() == "0" )
								x=i+1-startRow;
							if ( readyle->text() == "0" )
								y=i+1-startRow;	
							
	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<endl;
							
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
							}
							
							ptr[i-startRow].setPoint(x,y);
							
							if (i>endRow)
								break;
						}
					}
	#ifdef HAVE_CDF
					else if (cdf.fileOK()) {		// cdf file
						QString xname = readxle->text(), yname = readyle->text();
						
						int len = cdf.VarLen(xname);
						if (len == 0)
							len = cdf.VarLen(yname);
						QProgressDialog progress( "Reading data ...", "Cancel", len-startRow, this,
							"progress", TRUE );
						for (i=startRow;i<len;i++) {
							if(i%1000 == 0) progress.setProgress(i);
							qApp->processEvents();
							
							double x=cdf.Data(xname,i), y=cdf.Data(yname,i);
							
							// index
							if ( readxle->text() == "0" )
								x=i+1-startRow;
							if ( readyle->text() == "0" )
								y=i+1-startRow;	
							
	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<endl;
							
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
							}
							
							ptr[i-startRow].setPoint(x,y);
							
							if (i>endRow)
								break;
						}
					}
	#endif
					else if (auf.fileOK()) {		// audiofile file
						double *data = auf.Data();
						QProgressDialog progress( "Reading data ...", "Cancel", auf.frameCount()-startRow, this, 
							"progress", TRUE );
						for (i=startRow;i<auf.frameCount();i++) {
							if(i%1000 == 0) progress.setProgress(i);
							qApp->processEvents();
							
							double x=getValue(auf,1,i,data,startRow),y=getValue(auf,2,i,data,startRow);
	
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
							}
							
							ptr[i-startRow].setPoint(x,y);
							
							if (i>endRow)
								break;
						}
					}
					else {			// everything else
						QProgressDialog progress( "Reading data ...", "Cancel", file->size(), this, 
							"progress", TRUE );

						// read line data
						if(type == P2D && cbi->currentItem() == 4) {
							kdDebug()<<"LINE data"<<endl;
							QString line = t.readLine();
							while(i<startRow) {
								line = t.readLine();
								i++;
							}
							
							line = line.simplifyWhiteSpace();
							// ignore comment lines	
							if(line.find(QRegExp(commle->text()))==0)
								continue;
							QStringList oneline;
							if (readsc->text() == i18n("auto"))
								oneline = QStringList::split(' ', line );
							else
								oneline = QStringList::split(readsc->text().at(0), line );
							
							// handle empty lines correct
							if((*oneline.begin()).length()==0)
								continue;
	
							for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
								x = i-startRow+1;
								y = mw->formatLabel(*it,interpretycb->currentItem());
								
								if (i == startRow) {
									xmin=xmax=x;
									ymin=ymax=y;
								}
								else {
									x<xmin?xmin=x:0;
									x>xmax?xmax=x:0;
									y<ymin?ymin=y:0;
									y>ymax?ymax=y:0;
								}
								if (i-startRow == MAX_POINTS) {
									KMessageBox::warningContinueCancel(this,
										i18n("Sorry. Not more than MAX_POINTS supported!"));
									break;
								}
								kdDebug()<<"X/Y = "<<x<<' '<<y<<endl;
								ptr[(i++)-startRow].setPoint(x,y);
	
								if (i>endRow)
									break;
								if ( progress.wasCancelled() )
								return 1;
							}
						}
						else {	// normal data (no line data)
							kdDebug()<<"no LINE data"<<endl;
							while (!t.eof()) {
								if(i%1000 == 0) progress.setProgress(file->at() );
								qApp->processEvents();
								QString line = t.readLine();
		
								while(i<startRow) {
									line = t.readLine();
									i++;
								}
		
								line = line.simplifyWhiteSpace();
								// ignore comment lines	
								if(line.find(QRegExp(commle->text()))==0)
									continue;
		
								QStringList oneline;
								if (readsc->text() == i18n("auto"))
									oneline = QStringList::split(' ', line );
								else
									oneline = QStringList::split(readsc->text().at(0), line );
		
								// handle empty lines correct
								if((*oneline.begin()).length()==0)
									continue;
		
								int j=1;
								for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
									if (j == readxle->text().toInt())		// x
										x = mw->formatLabel(*it,interpretxcb->currentItem());
									if (j == readyle->text().toInt())		// y
										y = mw->formatLabel(*it,interpretycb->currentItem());
									j++;
								}
								if ( readxle->text().toInt() == 0 )
									x=i+1-startRow;
								if ( readyle->text().toInt() == 0 )
									y=i+1-startRow;
		
								if (i == startRow) {
									xmin=xmax=x;
									ymin=ymax=y;
								}
								else {
									x<xmin?xmin=x:0;
									x>xmax?xmax=x:0;
									y<ymin?ymin=y:0;
									y>ymax?ymax=y:0;
								}
								if (i-startRow == MAX_POINTS) {
									KMessageBox::warningContinueCancel(this,
										i18n("Sorry. Not more than MAX_POINTS supported!"));
									break;
								}
								//kdDebug()<<"X/Y = "<<x<<' '<<y<<endl;
								ptr[(i++)-startRow].setPoint(x,y);
		
								if (i>endRow)
									break;
								if ( progress.wasCancelled() )
								return 1;
							}
						}
					}
					
					LRange range[2];
					range[0] = LRange(xmin,xmax);
					range[1] = LRange(ymin,ymax);
	
					Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),widthle->text().toInt(),
						pencb->currentItem(),brushcb->currentItem());
					Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
						(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
					Graph2D *g = new Graph2D(filename.latin1(),label,range,SDATA,type,style,symbol,ptr,i-startRow);
					
					AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
					g->setAnnotateValues(av);
					p->addGraph2D(g,(PType)type);
				}
				else if (  (type == P2D && cbi->currentItem() == 1) || (type == P3D && cbi->currentItem() == 0)
					|| type == PTERNARY || (type == PQWT3D && cbi->currentItem() == 1)) {	// x-y-z
					Point3D *ptr = new Point3D[MAX_POINTS];	// better method needed
					double x=0, y=0, z=0, xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1;
					int i=0;
	
					if (ncf.fileOK()) {		// netcdf file
						QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text();
	
						QProgressDialog progress( "Reading data ...", "Cancel",ncf.VarLen(xname)-startRow ,this, 
							"progress", TRUE );

						int len = ncf.VarLen(xname);
						if (len==0)
							len = ncf.VarLen(yname);
	
						for (i=startRow;i<len;i++) {
							if (i%100==0)progress.setProgress(i);
							qApp->processEvents();
							
							double x=ncf.Data(xname,i), y=ncf.Data(yname,i), z=ncf.Data(zname,i);
							
	// 						kdDebug()<<"x/y/z = "<<x<<' '<<y<<' '<<z<<endl;
							// index
							if ( readxle->text() == "0" )
								x=i+1-startRow;
							if ( readyle->text() == "0" )
								y=i+1-startRow;	
							if ( readzle->text() == "0" )
								z=i+1-startRow;	
							
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
							}
	
							ptr[i-startRow].setPoint(x,y,z);
						
							if (i>endRow)
								break;
						}
					}
	#ifdef HAVE_CDF
					else if (cdf.fileOK()) {		// cdf file
						QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text();
						
						int len = cdf.VarLen(xname);
						if (len == 0)
							len = cdf.VarLen(yname);
						if (len == 0)
							len = cdf.VarLen(zname);
						QProgressDialog progress( "Reading data ...", "Cancel", len-startRow, this,"progress", TRUE );
						for (i=startRow;i<len;i++) {
							if(i%1000 == 0) progress.setProgress(i);
							qApp->processEvents();
							
							double x=cdf.Data(xname,i), y=cdf.Data(yname,i),z=cdf.Data(zname,i) ;
							
							// index
							if ( readxle->text() == "0" )
								x=i+1-startRow;
							if ( readyle->text() == "0" )
								y=i+1-startRow;	
							if ( readzle->text() == "0" )
								z=i+1-startRow;	
							
	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<' '<<z<<endl;
							
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
							}
							
							ptr[i-startRow].setPoint(x,y,z);
							
							if (i>endRow)
								break;
						}
					}
	#endif
					else if (auf.fileOK()) {		// audiofile file
						double *data = auf.Data();
						QProgressDialog progress( "Reading data ...", "Cancel",auf.frameCount()-startRow ,this, 
							"progress", TRUE );
						for (i=startRow;i<auf.frameCount();i++) {
							if (i%1000==0)progress.setProgress(i);
							qApp->processEvents();
							double x=getValue(auf,1,i,data,startRow),y=getValue(auf,2,i,data,startRow),
								z=getValue(auf,3,i,data,startRow);
	
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y,zmin=zmax=z;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
							}
							
							ptr[i-startRow].setPoint(x,y,z);
							
							if (i>endRow)
								break;
						}
					}
					else {			// everything else
						QProgressDialog progress( "Reading data ...", "Cancel", file->size(),this, "progress", TRUE );
						while (!t.eof()) {
							if (i%100==0)progress.setProgress(file->at() );
							qApp->processEvents();
							QString line = t.readLine();
	
							while(i<startRow) {
								line = t.readLine();
								i++;
							}
	
							line = line.simplifyWhiteSpace();
							// ignore comment lines
							if(line.find(QRegExp(commle->text()))==0)
								continue;
							
							QStringList oneline;
							if (readsc->text() == i18n("auto"))
								oneline = QStringList::split(' ', line );
							else
								oneline = QStringList::split(readsc->text().at(0), line );
	
							// handle empty lines correct
							if((*oneline.begin()).length()==0)
								continue;
	
							int j=1;
							for ( QStringList::Iterator it = oneline.begin();
								it != oneline.end(); ++it ) {
								if (j == readxle->text().toInt())		// x
									x = mw->formatLabel(*it,interpretxcb->currentItem());
								if (j == readyle->text().toInt())		// y
									y = mw->formatLabel(*it,interpretycb->currentItem());
								if (j == readzle->text().toInt())		// z
									z = mw->formatLabel(*it,interpretzcb->currentItem());
								j++;
							}
							if ( readxle->text().toInt() == 0 )
								x=i+1-startRow;
							if ( readyle->text().toInt() == 0 )
								y=i+1-startRow;
							if ( readzle->text().toInt() == 0 )
								z=i+1-startRow;
	
							if (i == startRow) {
								if (type == PTERNARY) {
									xmin=0;
									xmax=x+y+z;
								}
								else
									xmin=xmax=x;	
								ymin=ymax=y;
								zmin=zmax=z;
							}
							else {
								if (type != PTERNARY) {
									x<xmin?xmin=x:0;
									x>xmax?xmax=x:0;
								}
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
							}
	
							//kdDebug()<<"X/Y/Z = "<<x<<' '<<y<<' '<<z<<endl;
	
							if (i-startRow == MAX_POINTS) {
								KMessageBox::warningContinueCancel(this,
									i18n("Sorry. Not more than MAX_POINTS supported!"));
								break;
							}
							ptr[(i++)-startRow].setPoint(x,y,z);
	
							if (i>endRow)
								break;
							if ( progress.wasCancelled() )
								return 1;
						}
					}
	
					LRange range[3];
					range[0] = LRange(xmin,xmax);
					range[1] = LRange(ymin,ymax);
					range[2] = LRange(zmin,zmax);
	
					Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
						widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
					Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
						(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	
					Graph3D *g = new Graph3D(filename.latin1(),label,range,SDATA,type,style,symbol,ptr,i-startRow,1);
					AnnotateValues av(typecb->currentItem(),positioncb->currentItem(),distancele->text().toInt());
					g->setAnnotateValues(av);
					p->addGraph3D(g);
				}
				else if (type == PSURFACE || (type == P3D && cbi->currentItem() == 1) || 
					(type == PQWT3D &&cbi->currentItem() == 0 )) {// matrix
					double *ptr=new double[500000];
					QString line;
					int i=0, numberx=0;
					double zmin=0,zmax=1;
	
					// TODO : read netcdf/cdf/audio data as matrix
					if (ncf.fileOK()) {		// netcdf file
	/*					QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text();
						QProgressDialog progress( "Reading data ...", "Cancel",ncf.getVarLen(xname)-startRow ,this, 
							"progress", TRUE );
	
						for (i=startRow;i<ncf.getVarLen(xname);i++) {
							if (i%100==0)progress.setProgress(i);
							qApp->processEvents();
							int x=ncf.getData(xname,i), y=ncf.getData(yname,i), z=ncf.getData(zname,i);
							
								kdDebug()<<"x/y/z = "<<x<<' '<<y<<' '<<z<<endl;
								// index
								if ( readxle->text() == "0" )
									x=i+1-startRow;
								if ( readyle->text() == "0" )
									y=i+1-startRow;	
								if ( readzle->text() == "0" )
									z=i+1-startRow;	
							
								// calculate range
								if (i == startRow) {
									xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;
								}
								else {
									x<xmin?xmin=x:0;
									x>xmax?xmax=x:0;
									y<ymin?ymin=y:0;
									y>ymax?ymax=y:0;
									z<zmin?zmin=z:0;
									z>zmax?zmax=z:0;
								}
							
								ptr[i-startRow].setPoint(x,y,z);
						
								if (i>endRow)
									break;
							}
						}*/
					}
					else {			// everything else
						QProgressDialog progress( "Reading data ...", "Cancel", file->size(),this, "progress", TRUE );
						while (!t.eof()) {
							//kdDebug()<<"Reading line "<<i<<endl;
							if(i%1000 == 0)progress.setProgress(file->at() );
							qApp->processEvents();
							line = t.readLine();
							line = line.simplifyWhiteSpace();
							// ignore comment lines
							if(line.find(QRegExp(commle->text()))==0)
								continue;
							
							QStringList oneline;
							if (readsc->text() == i18n("auto"))
								oneline = QStringList::split(' ', line );
							else
								oneline = QStringList::split(readsc->text().at(0), line );
							numberx=oneline.count();
	
							// handle empty lines correct
							if((*oneline.begin()).length()==0)
								continue;
	
						/*kdDebug()<<"line "<<i<<endl;
						for (int j=0;j<numberx;j++) {
							kdDebug()<<" ("<<line.section(' ',j,j)<<")"<<endl;
						}
						kdDebug()<<endl;
						*/
							int j=0;
							for ( QStringList::Iterator it = oneline.begin(); it != oneline.end(); ++it ) {
								double z =  (*it).toDouble();
	
								if (!finite(z)) z=0;
	
								if (j==0 && i==0) {
									zmin=zmax=z;
								}
								else {
									z<zmin?zmin=z:0;
									z>zmax?zmax=z:0;
								}
	
								ptr[j+numberx*i]=z;
								//kdDebug()<<"ptr["<<j+numberx*i<<"] = "<<z<<endl;
								j++;
							}
	
							i++;
							if ( progress.wasCancelled() )
								return 1;
						}
					}
					
					LRange range[3];
					range[0] = LRange(0,numberx);
					range[1] = LRange(0,i);
					range[2] = LRange(zmin,zmax);
	
					GraphM *g;
	
					if (type == PSURFACE) {
						Style style(0);
						Symbol symbol(SNONE);
						g = new GraphM(filename.latin1(),label,range, SDATA, type,style,symbol,ptr,numberx,i);
					}
					else {
						Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
							widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
						Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
							(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
						g = new GraphM(filename.latin1(),label,range, SDATA, type,style,symbol,ptr,numberx,i);
					}
					p->addGraphM(g,type);
				}
				else if (type == P2D) { // x-y-dx-dy or x-y-dy1-dy2
					Point4D *ptr = new Point4D[MAX_POINTS];	// better method needed
					double x=0, y=0, z=0, tt=0, xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
					int i=0;
	
					if (ncf.fileOK()) {		// netcdf file
						QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text(),
							tname = readtle->text();
						QProgressDialog progress( "Reading data ...", "Cancel",ncf.VarLen(xname)-startRow ,this, 
							"progress", TRUE );

						int len = ncf.VarLen(xname);
						if(len==0)
							len = ncf.VarLen(yname);
	
						for (i=startRow;i<len;i++) {
							if (i%1000==0)progress.setProgress(i);
							qApp->processEvents();
	
							double x=ncf.Data(xname,i), y=ncf.Data(yname,i), z=ncf.Data(zname,i),
								tt=ncf.Data(tname,i);
							
	// 						kdDebug()<<"x/y/z/t = "<<x<<' '<<y<<' '<<z<<' '<<tt<<endl;
							// index
							if ( readxle->text() == "0" )
								x=i+1-startRow;
							if ( readyle->text() == "0" )
								y=i+1-startRow;	
							if ( readzle->text() == "0" )
								z=i+1-startRow;	
							if ( readtle->text() == "0" )
								tt=i+1-startRow;	
	
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;zmin=zmax=z,tmin=tmax=tt;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
								tt<tmin?tmin=tt:0;
								tt>tmax?tmax=tt:0;
							}
		
							ptr[i-startRow].setPoint(x,y,z,tt);
	
							if (i>endRow)
								break;
						}
					}
	#ifdef HAVE_CDF
					else if (cdf.fileOK()) {		// cdf file
						QString xname = readxle->text(), yname = readyle->text(), zname = readzle->text(),
							tname = readtle->text();
						
						int len = cdf.VarLen(xname);
						if (len == 0)
							len = cdf.VarLen(yname);
						if (len == 0)
							len = cdf.VarLen(zname);
						if (len == 0)
							len = cdf.VarLen(tname);
						QProgressDialog progress( "Reading data ...", "Cancel", len-startRow, this,
							"progress", TRUE );
						for (i=startRow;i<len;i++) {
							if(i%1000 == 0) progress.setProgress(i);
							qApp->processEvents();
	
							double x=cdf.Data(xname,i), y=cdf.Data(yname,i),z=cdf.Data(zname,i),
								t= cdf.Data(tname,i);
	
							// index
							if ( readxle->text() == "0" )
								x=i+1-startRow;
							if ( readyle->text() == "0" )
								y=i+1-startRow;	
							if ( readzle->text() == "0" )
								z=i+1-startRow;	
							if ( readtle->text() == "0" )
								t=i+1-startRow;	
	
	// 						kdDebug()<<"x/y = "<<x<<' '<<y<<' '<<z<<' '<<t<<endl;
	
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y;zmin=zmax=z;tmin=tmax=t;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
								t<tmin?tmin=t:0;
								t>tmax?tmax=t:0;
							}
							
							ptr[i-startRow].setPoint(x,y,z,t);
							
							if (i>endRow)
								break;
						}
					}
	#endif
					else if (auf.fileOK()) {		// audiofile file
						double *data = auf.Data();
						QProgressDialog progress( "Reading data ...", "Cancel",auf.frameCount()-startRow ,this, 
							"progress", TRUE );
						for (i=startRow;i<auf.frameCount();i++) {
							if (i%1000==0)progress.setProgress(i);
							qApp->processEvents();
	
							double x=getValue(auf,1,i,data,startRow), y=getValue(auf,2,i,data,startRow), 
								z=getValue(auf,3,i,data,startRow),t=getValue(auf,4,i,data,startRow);
	
							// calculate range
							if (i == startRow) {
								xmin=xmax=x;ymin=ymax=y,zmin=zmax=z,tmax=tmin=t;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
								t<tmin?tmin=t:0;
								t>tmax?tmax=t:0;
							}
	
							ptr[i-startRow].setPoint(x,y,z,t);
	
							if (i>endRow)
								break;
						}
					}
					else {			// everything else
						QProgressDialog progress( "Reading data ...", "Cancel", file->size(),this, "progress", TRUE );
						while (!t.eof()) {
							if (i%1000==0)progress.setProgress(file->at() );
							qApp->processEvents();
							QString line = t.readLine();
	
							while(i<startRow) {
								line = t.readLine();
								i++;
							}
	
							line = line.simplifyWhiteSpace();
							// ignore comment lines
							if(line.find(QRegExp(commle->text()))==0)
								continue;
							
							QStringList oneline;
							if (readsc->text() == i18n("auto"))
								oneline = QStringList::split(' ', line );
							else
								oneline = QStringList::split(readsc->text().at(0), line );
	
							// handle empty lines correct
							if((*oneline.begin()).length()==0)
								continue;
	
							int j=1;
							for ( QStringList::Iterator it = oneline.begin();
								it != oneline.end(); ++it ) {
								if (j == readxle->text().toInt())		// x
									x = mw->formatLabel(*it,interpretxcb->currentItem());
								if (j == readyle->text().toInt())		// y
									y = mw->formatLabel(*it,interpretycb->currentItem());
								if (j == readzle->text().toInt())		// z
									z = mw->formatLabel(*it,interpretzcb->currentItem());
								if (j == readtle->text().toInt())		// t
									tt = mw->formatLabel(*it,interprettcb->currentItem());
								j++;
							}
							if ( readxle->text().toInt() == 0 )
								x=i+1-startRow;
							if ( readyle->text().toInt() == 0 )
								y=i+1-startRow;
							if ( readzle->text().toInt() == 0 )
								z=i+1-startRow;
							if ( readtle->text().toInt() == 0 )
								tt=i+1-startRow;
	
							if (i == startRow) {
								xmin=xmax=x;
								ymin=ymax=y;
								zmin=zmax=z;
								tmin=tmax=tt;
							}
							else {
								x<xmin?xmin=x:0;
								x>xmax?xmax=x:0;
								y<ymin?ymin=y:0;
								y>ymax?ymax=y:0;
								z<zmin?zmin=z:0;
								z>zmax?zmax=z:0;
								tt<tmin?tmin=tt:0;
								tt>tmax?tmax=tt:0;
							}
	
							//kdDebug()<<"X/Y/Z = "<<x<<' '<<y<<' '<<z<<endl;
	
							if (i-startRow == MAX_POINTS) {
								KMessageBox::warningContinueCancel(this,
									i18n("Sorry. Not more than MAX_POINTS supported!"));
								break;
							}
							ptr[(i++)-startRow].setPoint(x,y,z,tt);
	
							if (i>endRow)
								break;
							if ( progress.wasCancelled() )
								return 1;
						}
					}
	
					LRange range[4];
					range[0] = LRange(xmin,xmax);
					range[1] = LRange(ymin,ymax);
					range[2] = LRange(zmin,zmax);
					range[3] = LRange(tmin,tmax);
	
					Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),widthle->text().toInt(),
						pencb->currentItem(),brushcb->currentItem());
					Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
						(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	
					Graph4D *g = new Graph4D(filename.latin1(),label,range, SDATA,
						type,style,symbol,ptr,i-startRow,cbi->currentItem()-2);
					p->addGraph4D(g);
				}
	
				if (l) l->updateList();
				file->close();
			}
			else {
				KMessageBox::error(this, i18n("Sorry. Could not open specified data file for reading!"));
				return 2;
			}
		}
	}

	return 0;
}

// get audio value from line edits
double DataDialog::getValue(FilterAUDIOFILE auf, int var, int i, double *data, int startRow) {
	int index=0;
	switch (var) {
	case 1:	// x
		index = readxle->text().toInt();break;
	case 2:	// y
		index = readyle->text().toInt();break;
	case 3:	// z
		index = readzle->text().toInt();break;
	case 4:	// t
		index = readtle->text().toInt();break;
	}
	
	double value=0;
	switch(index) {
	case 0:	// index
		value=i+1-startRow;break;
	case 1:	// time
		value=i/auf.sampleRate();break;
	case 2:	// channel 1
		switch(auf.channelCount()) {
		case 1:
			value=data[i]; break;
		case 2:
			value=data[2*i];break;
		}
		break;
	case 3:	// channel 2
		if(auf.channelCount()==2)
			value=data[2*i+1];
		break;
	}
	
	return value;
}
