//LabPlot : FileInfoDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <unistd.h>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <qfileinfo.h>
#include <qprocess.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kimageio.h>
#include "FileInfoDialog.h"

using namespace std;

FileInfoDialog::FileInfoDialog(const char *name, QString filename)
	: Dialog(0, name)
{
	QString value;
	setCaption(i18n("File Info")+i18n(" : ")+filename);
	
	QGroupBox *gb1 = new QGroupBox(1,QGroupBox::Horizontal,filename,vbox);
	QHBox *hb = new QHBox(gb1);
	
	QFileInfo info(filename);
	
	hb = new QHBox(gb1);
	new QLabel(i18n("Readable : "),hb);
	info.isReadable()==FALSE?value="no":value="yes";
	new QLabel(value,hb);
	new QLabel(i18n("Writable : "),hb);
	info.isWritable()==FALSE?value="no":value="yes";
	new QLabel(value,hb);
	new QLabel(i18n("Executable : "),hb);
	info.isExecutable()==FALSE?value="no":value="yes";
	new QLabel(value,hb);

	hb = new QHBox(gb1);
	new QLabel(i18n("Created : "),hb);new QLabel(info.created().toString(),hb);
	hb = new QHBox(gb1);
	new QLabel(i18n("Last Modified : "),hb);new QLabel(info.lastModified().toString(),hb);
	hb = new QHBox(gb1);
	new QLabel(i18n("Last Read : "),hb);new QLabel(info.lastRead().toString(),hb);

	hb = new QHBox(gb1);
	new QLabel(i18n("Owner : "),hb);new QLabel(info.owner(),hb);
	new QLabel(i18n("Group : "),hb);new QLabel(info.group(),hb);

	hb = new QHBox(gb1);
	new QLabel(i18n("Size : "),hb);new QLabel(QString::number(info.size())+i18n(" Bytes"),hb);
	new QLabel(i18n("Extension : "),hb);new QLabel(info.extension(),hb);

	// file type	
	QProcess *proc = new QProcess( this );
	proc->addArgument("file");
	proc->addArgument("-b");
	proc->addArgument(filename);
	if (!proc->start())
		kdDebug()<<"Could not start \"file -b "<<filename<<"\""<<endl;
	sleep(1);
	
	QGroupBox *gb2 = new QGroupBox(1,QGroupBox::Horizontal,proc->readLineStdout(),vbox);

	ncf = FilterNETCDF(filename);
	auf = FilterAUDIOFILE(filename);
	cdf = FilterCDF(filename);
	mf = FilterMAGICK(filename);
		
	// Image format
	QString format;
	if ((format = QString(QImageIO::imageFormat(filename))) != 0) {
		hb = new QHBox(gb2);
		new QLabel(i18n("Image Format : "),hb);
		new QLabel(format,hb);

		QPixmap pm;
		pm.load(filename);
		QImage image = pm.convertToImage();
		hb = new QHBox(gb2);
		new QLabel(i18n("Width : "),hb);new QLabel(QString::number(image.width()),hb);
		new QLabel(i18n("Height : "),hb);new QLabel(QString::number(image.height()),hb);
		hb = new QHBox(gb2);
		new QLabel(i18n("Depth : "),hb);new QLabel(QString::number(pm.depth()),hb);
		new QLabel(i18n("Bytes : "),hb);new QLabel(QString::number(image.numBytes()),hb);
		new QLabel(i18n("Colors : "),hb);new QLabel(QString::number(image.numColors()),hb);
		hb = new QHBox(gb2);
		new QLabel(i18n("Grayscale : "),hb);
		image.isGrayscale()==FALSE?value="no":value="yes";
		new QLabel(value,hb);
		switch (image.bitOrder()) {
		case QImage::IgnoreEndian:
			value="NO";break;
		case QImage::BigEndian:
			value="BigEndian";break;
		case QImage::LittleEndian:
			value="LittleEndian";break;
		}
		new QLabel(i18n("Endian : "),hb);
		new QLabel(value,hb);
		new QLabel(i18n("AlphaBuffer : "),hb);
		image.hasAlphaBuffer()==FALSE?value="no":value="yes";
		new QLabel(value,hb);
	}
#ifdef HAVE_MAGICK
	else if (mf.fileOK()) {	// ImageMagick file
		kdDebug()<<"Found ImageMagick file !"<<endl;
		hb = new QHBox(gb2);
		new QLabel(i18n("Width : "),hb);new QLabel(QString::number(mf.width()),hb);
		new QLabel(i18n("Height : "),hb);new QLabel(QString::number(mf.height()),hb);
		hb = new QHBox(gb2);
		new QLabel(i18n("Depth : "),hb);new QLabel(QString::number(mf.depth()),hb);
		new QLabel(i18n("Bytes : "),hb);new QLabel(QString::number(mf.numBytes()),hb);
		new QLabel(i18n("Gamma : "),hb);new QLabel(QString::number(mf.gamma()),hb);
	}
#endif
	else if (auf.fileOK()) {	// audiofile file
		gb2->setTitle(auf.Desc());
			
		hb = new QHBox(gb2);
		new QLabel(i18n("Length : "),hb);
		new QLabel(QString::number(auf.frameCount()/auf.sampleRate())+i18n(" s"),hb);
		new QLabel('('+QString::number(auf.frameCount())+i18n(" samples")+')',hb);
		
		hb = new QHBox(gb2);
		new QLabel(i18n("Sample rate : "),hb);
		new QLabel(QString::number(auf.sampleRate())+i18n(" Hz")+i18n(" @ ")+
			QString::number(auf.sampleWidth())+i18n(" bit"),hb);
		new QLabel(i18n("Sample format : "),hb);
		new QLabel(auf.sampleFormat(),hb);

		hb = new QHBox(gb2);
		new QLabel(i18n("Channel count : "),hb);
		QString type;
		if(auf.channelCount() == 1)
			type = i18n(" (mono)");
		else if(auf.channelCount() == 2)
			type = i18n(" (stereo)");
		new QLabel(QString::number(auf.channelCount())+type,hb);
		new QLabel(i18n("Frame size : "),hb);
		new QLabel(QString::number(auf.frameSize()),hb);
	}
	else if(ncf.fileOK()) {	// netcdf file
		gb2->setTitle(i18n("netCDF data"));

		hb = new QHBox(gb2);
		new QLabel(i18n("Library Version : "),hb);
		new QLabel(ncf.version(),hb);

		hb = new QHBox(gb2);
		new QLabel(i18n("Dimensions")+i18n(" ( ")+QString::number(ncf.NDims())+i18n(" ) ")+i18n(" : "),hb);
		new QLabel(i18n("Variables")+i18n(" ( ")+QString::number(ncf.NVars())+i18n(" ) ")+i18n(" : "),hb);
		new QLabel(i18n("Attributes")+i18n(" ( ")+QString::number(ncf.NAtts())+i18n(" ) ")+i18n(" : "),hb);
		//new QLabel(i18n("Dimension ID : "),hb);
		//new QLabel(QString::number(xdimid),hb);

		hb = new QHBox(gb2);
		QListBox *lb=new QListBox(hb);
		// get dimensions
		for (int dimid = 0; dimid <ncf.NDims() ; dimid++)
			lb->insertItem(ncf.Dim(dimid));

		// get variable info, with variable attributes
		varlb = new QListBox(hb);		
		for (int varid = 0; varid < ncf.NVars(); varid++) {
			varlb->insertItem(ncf.Var(varid));
		}
		varlb->setCurrentItem(0);
		
		// global attributes
		lb=new QListBox(hb);
		for (int ia = 0; ia < ncf.NAtts(); ia++)
			lb->insertItem(ncf.Att(ia));

		hb = new QHBox(gb2);
		varlabel = new QLabel("",hb);
		selvarlb = new QListBox(hb);
		updateVarListBox();
		QObject::connect(varlb,SIGNAL(selectionChanged()),this,SLOT(updateVarListBox()));
	}
#ifdef HAVE_CDF
	else if(cdf.fileOK()) {	// cdf file
		gb2->setTitle(i18n("CDF data")+i18n(" Version : ")+cdf.version());
		
// 		hb = new QHBox(gb2);
// 		new QLabel(i18n("Copyright : "),hb);
// 		new QLabel(cdf.copyright(),hb);
		
		hb = new QHBox(gb2);
		new QLabel(i18n("Compression")+i18n(" : ")+cdf.Compression(),hb);
		new QLabel(i18n("Encoding")+i18n(" : ")+cdf.Enc(-1),hb);
		hb = new QHBox(gb2);
		new QLabel(i18n("Majority")+i18n(" : ")+cdf.Maj(),hb);
		new QLabel(i18n("Maximum Record Number")+i18n("  : ")+QString::number(cdf.MaxRec()),hb);
		new QLabel(i18n("Dimensions")+i18n(" : ")+QString::number(cdf.NDims()),hb);
		
		hb = new QHBox(gb2);
		new QLabel(i18n("Variables")+i18n(" ( ")+QString::number(cdf.NVars())+i18n(" ) ")+i18n(" : "),hb);
		new QLabel(i18n("Attributes")+i18n(" ( ")+QString::number(cdf.NAtts())+i18n(" ) ")+i18n(" : "),hb);
		
		hb = new QHBox(gb2);
		// get variable info, with variable attributes
		varlb = new QListBox(hb);		
		for (int varid = 0; varid < cdf.NVars(); varid++) {
			varlb->insertItem(cdf.Var(varid));
		}
		varlb->setCurrentItem(0);
		
		// global attributes
		QListBox *lb=new QListBox(hb);
		for (int ia = 0; ia < cdf.NAtts(); ia++)
			lb->insertItem(cdf.Att(ia));
		
		hb = new QHBox(gb2);
		varlabel = new QLabel("",hb);
		selvarlb = new QListBox(hb);
		updateVarListBox();
		QObject::connect(varlb,SIGNAL(selectionChanged()),this,SLOT(updateVarListBox()));
	}
#endif
	else {		// assume ascii data
		proc = new QProcess( this );
		proc->addArgument("wc");
		proc->addArgument("-l");
		proc->addArgument(filename);
		if (!proc->start())
			kdDebug()<<"Could not start \"wc -l "<<filename<<"\""<<endl;
		sleep(1);

		hb = new QHBox(gb2);
		new QLabel(i18n("Number of Lines : "),hb);
		new QLabel(proc->readLineStdout().section(" ",0,0),hb);
		
		// TODO : nr of cols
	}
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(accept()));
	apply->hide();
	
	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
	resize(vbox->minimumSizeHint()+gbox->minimumSizeHint());
}

//! update variable list box to selected variable
void FileInfoDialog::updateVarListBox() {
		int varid = varlb->currentItem();
		
		selvarlb->clear();
		if(ncf.fileOK()) {	// netcdf
			varlabel->setText(ncf.Var(varid)+i18n(" : "));
			selvarlb->insertStringList(ncf.DataString(varid));
		}
#ifdef HAVE_CDF
		else if (cdf.fileOK()) {
			varlabel->setText(cdf.Var(varid)+i18n(" : "));
			selvarlb->insertStringList(cdf.DataString(varid));
		}
#endif
}
