//LabPlot : ImageListDialog.h

#ifndef IMAGELISTDIALOG_H
#define IMAGELISTDIALOG_H

#include "ListDialog.h"

#ifdef HAVE_MAGICK
#include <list>
#include "Magick++.h"
using namespace Magick;
#endif


class ImageListDialog : public ListDialog
{
	Q_OBJECT
public:
	ImageListDialog(Worksheet *p, Spreadsheet *s, const char *name);
private slots:
	void updateOptions(int item);
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
private:
#ifdef HAVE_MAGICK
	Color getColor(QColor c);
#endif
	KComboBox *typecb, *noisecb;
	QLabel *xlabel, *ylabel, *zlabel;
	KLineEdit *xle, *yle, *zle;
	KColorButton *kcb;
};

#endif // IMAGELISTDIALOG_H
