//LabPlot : PlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include "PlotDialog.h"
#include "Plot2DSimple.h"
#include "Plot2DSurface.h"
#include "Plot3D.h"
#include "PlotPie.h"
#include "PlotPolar.h"
#include "PlotGRASS.h"
#include "PlotVTK.h"
#include "PlotTernary.h"
#include "PlotGL.h"
#include "PlotQWT3D.h"

//! general class for plot settings
PlotDialog::PlotDialog(Worksheet *p, const char *name)
	: Dialog(p, name), p(p)
{
	setCaption(i18n("Plot Dialog")+i18n(" : ")+QString(name));

	lv = new QListView(vbox,0);
	lv->addColumn(i18n("Number"));
	lv->addColumn(i18n("Type"));
	lv->addColumn(i18n("Position"));
	lv->addColumn(i18n("Size"));
	lv->addColumn(i18n("Transparent"));
	lv->addColumn(i18n("Background Color"));
	lv->addColumn(i18n("Graph Background Color"));

	lv->setAllColumnsShowFocus(true);
	for (int i=0;i<lv->columns();i++)
		lv->setColumnAlignment(i,Qt::AlignHCenter);
	lv->setMinimumWidth(350);
	updateList();
}

void PlotDialog::updateList() {
	lv->clear();
	lv->setSorting(-1);

	for (int i= p->NrPlots()-1;i>=0;i--) {
		QListViewItem *lvi = new QListViewItem(lv);
		QStringList s;
		s += QString::number(i+1);

		Plot *plot = p->getPlot(i);
		PType type = plot->Type();
		switch (type) {
		case P2D:	s += ((Plot2DSimple *)plot)->Info();break;
		case PSURFACE:	s += ((Plot2DSurface *)plot)->Info();break;
		case P3D:	s += ((Plot3D *)plot)->Info();break;
		case PGRASS:	s += ((PlotGRASS *)plot)->Info();break;
		case PVTK:	s += ((PlotVTK *)plot)->Info();break;
		case PPIE:	s += ((PlotPie *)plot)->Info();break;
		case PPOLAR:	s += ((PlotPolar *)plot)->Info();break;
		case PTERNARY:	s += ((PlotTernary *)plot)->Info();break;
		case PGL: 	s += ((PlotGL *)plot)->Info();break;
		case PQWT3D:	s += ((PlotQWT3D *)plot)->Info();break;
		}
			
		for (unsigned int j = 0;j < s.count();j++) {
			lvi->setText(j,s[j]);
		}
	}
}
