/* VPX definitions.  */

#define VPX_BUSY_TIMEOUT HZ/50   /* 20ms Delay for the FP to get ready */

#define VPX_VERSION "0.1"
#define VPX_DATE "November, 2002"

#define VPX_REG_JEDEC 0x00
#define VPX_JEDEC_ID 0xec

#define VPX_REG_PARTNUM0 0x01
#define VPX_REG_PARTNUM1 0x02

#define VPX_3224D_ID 0x31
#define VPX_3225D_ID 0x30

#define VPX_PARTNUM1_ID 0x72


#define FPSTA 0x35
#define FPRD  0x36
#define FPWR  0x37
#define FPDAT 0x38


/* Custom "ioctl" commands. Actually these ioctls are sent to the respective
 * i2c device driver routines of the video processors. The layering is as 
 * shown below.
 *           /->Tuner Driver (I2C) (tuner.c)
 *         /
 * VFS->V4L-Driver (pvcl.c) ->Display Driver (I2C) (embedded in pvcl.c)
 *        \
 *          \->Video Processor Driver (I2C) (vpx322xd.c)
 *
 * TODO: Check for conflicts with existing linux IOCTLS. There is a remote
 * chance that some wild application might wheedle an ioctl past the V4L
 * layer and into one of the I2C drivers. */

#define VPROC_INIT           _IOW('v', 1, int) /* Init video processor */
#define VPROC_SET_CAP_MODE   _IOW('v', 2, int)  /* Set capture settings. */
#define VPROC_START_CAPTURE  _IOW('v', 3, int)  /* Start capture */
#define VPROC_STOP_CAPTURE   _IOW('v', 4, int)  /* Stop  capture */
#define VPROC_GET_CAP_MODE   _IOR('v', 5, int)  /* Get settings */
#define VPROC_SET_WINDOW     _IOW('v', 6, struct video_window) 
                                             /* Set the window parms. */

#define VPROC_SET_PICTURE    _IOW('v', 7, struct video_picture)
                                             /* Set the picture parms. */
