.TH LightLab 1 "18-Mar-2002" "X Version 11"
.SH NAME
lightlab - experiment with the OpenGL lighting model
.SH SYNOPSIS
.B lightlab
.SH DESCRIPTION
This program lets you set the colors and positions of three GTK light
sources, and watch the effect that has on a simple 3D scene.

Here is a quick overview of OpenGL lighting concepts.  If this isn't
enough for you, check the man pages, or get a book on OpenGL, such as
the one mentioned below.

Lights have three colors associated with them, and so do objects.  The
color of a surface in a scene is determined by the combination of the
colors of the surface and the colors of the lights shining on it.
.TP 4
.B Ambient lighting
Light so scattered it can be considered to come from every direction
equally.  If a light in the scene has ambient light set, then a
uniform, non-positional light of that color will hit all objects.
.TP 4
.B Diffuse lighting
Directional lighting that will reflect from surfaces according to their
normal vectors.  Ambient light hitting a surface directly will be
brigher than ambient light hitting at an angle.
.TP 4
.B Specular lighting
Like diffuse lighting, but the light shines back in a particular
direction, depending on the Shininess of the surface.  The more shiny
the surface, the more focused a specular reflection.
.PP
The X, Y, and Z positions of each light are divided by the "W" value
(in this program, called "Divisor") to get the actual position.  If the
divisor is 0, then the distance is infinite, and the XYZ coordinate
defines a vector pointing at an infinitely far light whose intensity
does not decrease with distance (e.g., the sun.)

If the divisor is non-zero, then it specifies the distance of the light
from the origin along the XYZ vector.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the host and display number on which to open the window.
.TP 8
.SH UPGRADES
The latest version of
.BR lightlab (1)
can always be found at http://www.jwz.org/lightlab/
.SH "SEE ALSO"
.BR X (1),
.BR glLightfv (3),
.BR glMaterialfv (3),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2002 by Jamie Zawinski.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, March 2002.

This program was inspired by a like-named GLUT program by Mark
J. Kilgard.  His program allowed one to turn lights on and off, and set
the color of objects as a demo of how lighting works, but did not allow
one to experiment with specific light positions colors.  So, I wrote my
own.

For learning OpenGL programming, I highly recommend Mark's book,
"OpenGL Programming for the X Window System", Addison-Wesley 1996, ISBN
0-201-48359-9.
