import os, unittest, shutil, tempfile
from linda.funcs import run_external_cmd
from linda.parser.dsc import DSCParser, DSCParserException
from sets import Set

class DSCParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_dsc.tar.gz' % self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_signed(self):
        "Check a signed and unsigned .dsc parses correctly"
        for type in ('signed', 'unsigned'):
            dsc = DSCParser(os.path.join(self.dir, '%s.dsc' % type))
            keys = Set(('files', 'binary', 'maintainer', 'format', \
                'build-depends', 'source', 'version', 'standards-version', \
                'architecture'))
            self.assertEqual(keys.intersection(dsc.keys()), keys)
            self.assertEqual(dsc['binary'], 'squirrelmail')
            self.assertEqual(dsc['maintainer'], \
                'Sam Johnston <samj@aos.net.au>')
            self.assertEqual(dsc['format'], '1.0')
            self.assertEqual(dsc['build-depends'], 'debhelper (>> 3.0.0)')
            self.assertEqual(dsc['source'], 'squirrelmail')
            self.assertEqual(dsc['version'], '1:1.4.0-1')
            self.assertEqual(dsc['standards-version'], '3.5.2')
            self.assertEqual(dsc['architecture'], 'all')
            self.assertEqual(dsc['files'], [' b7bec26863cb6bf8cc3312f89631a0a2 2562530 squirrelmail_1.4.0.orig.tar.gz', ' aaf0a6a848ced0776eeea5c8545770be 11532 squirrelmail_1.4.0-1.diff.gz'])

    def test_incorrect(self):
        "Check a badly-formatted .dsc throws a DSCParserException"
        try:
            dsc = DSCParser(os.path.join(self.dir, 'incorrect.dsc'))
        except DSCParserException:
            pass
        else:
            self.fail()

