#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>
#include "global_vars.h"
#include "srv_def.h"
#include "cmd.h"
#include "../common.h"
#include "client.h"
#include "../lcp3.h"

int validate_pack(struct p_order_t *, int);
int check_clt_buf(struct client_t **who, struct p_order_t *pack,
		  struct sockaddr_in *from, int *sock);

int got_data(struct p_order_t *pack, struct sockaddr_in *from, int *sock, char *type)
// sock: will get the socket-handle which we got data on (if no data --> -1)
// type: SOCK_TYPE_TCP, SOCK_TYPE_UDP or SOCK_TYPE_NONE
{
    struct timeval tv;
    fd_set s;
    int rlen = 0;
    int len = sizeof(struct sockaddr_in);
    int max_hndl = 0;
    struct client_t *who;
    *sock = -1;
    *type = SOCK_TYPE_NONE;
    /* does any client still have buffered data? --> process now */
    who = NULL;
    rlen = check_clt_buf(&who, pack, from, sock);
    if ( who && rlen )
    {
        *type = SOCK_TYPE_TCP;
	return(rlen);
    }
    /* no client had buffered data */
    /* tempieren... */
    if ( !server->fast_loop )
    {
	tv.tv_sec = LCS_LITTLE_LOOP;
	tv.tv_usec = 0;
    }
    else
    {
	tv.tv_sec = 0;
	tv.tv_usec = 500; // time resolution is about 10ms.
    }
    /* laden... */
    FD_ZERO(&s);
    max_hndl = server->udp_socket;
    FD_SET(server->udp_socket, &s);
    if ( max_hndl < server->tcp_socket ) max_hndl = server->tcp_socket;
    FD_SET(server->tcp_socket, &s);
    who = (struct client_t*)cltlist.first;
    while ( who )
    {
	if ( (who->type != LCS_CLT_DC) )
	{
	    FD_SET(who->tcp_sock, &s);
	    if ( max_hndl < who->tcp_sock ) max_hndl = who->tcp_sock;
	}
	who = (struct client_t*)who->next;
    }
    /* rumms! */
    if ( select(max_hndl+1, &s, NULL, NULL, &tv) < 1 )
    {
	return(0);
    }
    /* OK, we got data; take the first socket where we have something
       waiting and pump it to pack */
    if ( FD_ISSET(server->tcp_socket, &s) )
    { // we have to accept & create a new LCC record
	int newsock;
	struct client_t *who;
	newsock = accept(server->tcp_socket, (struct sockaddr*)from, &len);
	if ( newsock == -1 ) return(-1);
	who = (struct client_t*)list_add(&cltlist, sizeof(struct client_t));
	if ( !who )
	{
	    syslog(LOG_ERR, "can't add new client, not enough memory");
	    close(newsock);
	    return(-1);
	}
	who->tcp_sock = newsock;
	*sock = newsock;
	*type = SOCK_TYPE_TCP;
	who->type = LCS_CLT_UNKNOWN_TCP;
	who->status = CLT_NOAUTH;
	who->line = (struct line_t*)lstlines.first;
	who->ip = from->sin_addr.s_addr;
	who->port = from->sin_port;
        who->started = 0;
	who->timeout = time(NULL) + LCC_DEFAULT_TIMEOUT;
	who->interval = LCC_MIN_TIMEOUT;
	who->received = 0;
	who->passwd = NULL;
	who->getall = 0;
	rlen = 0;
    }
    else if ( FD_ISSET(server->udp_socket, &s) )
    { // data from a DCC
	rlen = recvfrom(server->udp_socket, pack,
			sizeof(struct p_order_t), 0,
			(struct sockaddr*)from, &len);
	*sock = 0;
	*type = SOCK_TYPE_UDP;
    }
    else
    { // probably data from a registered TCP client
	who = (struct client_t*)cltlist.first;
	while ( who )
	{
	    while ( who->type == LCS_CLT_DC )
		who = (struct client_t*)who->next;
	    if ( !who ) break;
	    if ( FD_ISSET(who->tcp_sock, &s) )
	    {
		*sock = who->tcp_sock;
		*type = SOCK_TYPE_TCP;
		break;
	    }
	    who = (struct client_t*)who->next;
	}
	if ( who )
	{
	// implement stream management here. Copy full pack to pack,
	// store partially received packet to who->pack.
	    rlen = read(who->tcp_sock,
			((char*)(&(who->pack))) + who->received,
			sizeof(struct p_order_t) - who->received);
	    if ( rlen > 0 )
	    {
		if ( (rlen >= 4) && (who->type == LCS_CLT_UNKNOWN_TCP)
		     && (who->pack.magic == LC_MAGIC_NR) )
			switch ( who->pack.version )
			{
			    case LC_PACKET_VERSION: who->type = LCS_CLT_LC; break;
//			    case LCP3_PROTO_VERSION: who->type = LCS_CLT_LCP3; break;
			    default:
				if ( (who->pack.version >= LCP3_MIN_PROTO_VERSION) && (who->pack.version <= LCP3_PROTO_VERSION) )
				{    who->type = LCS_CLT_LCP3;	}
				else
				{
				    syslog(LOG_INFO, "protocol version conflict: client: %d - server: %d", who->pack.version, LCP3_PROTO_VERSION);
				    // the next syslog entry done by kick_client() contains the clients IP
				    kick_client(who, 8);
				    return(-1);
				}
			}
		who->received += rlen;
		rlen = check_clt_buf(&who, pack, from, sock);
	    }
	    else if ( !rlen ) clean_clients(who); // check only this one
	}
	else rlen = -1; // socket shouldn't exist!!
    }
    return(rlen);
}

int validate_pack(struct p_order_t *pack, int dlen)
{
 if ( dlen == -1 ) return(-5);
 if ( pack->magic != LC_MAGIC_NR ) return(-2);
 if ( dlen < 8 ) return(-6);
 switch ( pack->version )
 {
     case LC_PACKET_VERSION:
         if ( !((dlen == sizeof(struct p_ack_t)) ||
             (((dlen >= sizeof(struct p_order_t)) - LC_MAX_MSG_LEN - 1)
	       && (dlen <= sizeof(struct p_order_t))))) return(-1);
         if ( pack->msglen > LC_MAX_MSG_LEN ) return(-3);
	 break;
     default:
         if ( (pack->version >= LCP3_MIN_PROTO_VERSION) && (pack->version <= LCP3_PROTO_VERSION) )
	 {
             if ( dlen < get_lcp3_pack_size(((struct t_lcp3_cmd*)(pack))->cmd) )
	         return(-7);
	 }
	 else
	 {
             syslog(LOG_DEBUG, "Bad protocol version %d", pack->version);
             return(-4);
	 }
 }
 return(0); // PACKET IS VALID
}

char *seek_lcp3_packet(char *begin, int len)
{ // seeks for the next LC_MAGIC_NR in the buffer
    char *loc = begin;
    if ( (!loc) || (len<=0) ) return(NULL);
    while ( (((struct t_lcp3_cmd*)loc)->magic != LC_MAGIC_NR)
	&& ((loc - begin) < len-sizeof(int)) ) loc++;
    if ( ((struct t_lcp3_cmd*)loc)->magic == LC_MAGIC_NR )
	return(loc);
    else return(NULL);
}

int check_clt_buf(struct client_t **who, struct p_order_t *pack,
		  struct sockaddr_in *from, int *sock)
{
    int single = 0;
    if ( !(*who) ) *who = (struct client_t*)cltlist.first;
    else single++;
    while ( *who )
    {
	if ( ((*who)->type == LCS_CLT_LC) &&
	     ((*who)->received >= sizeof(struct p_ack_t)) )
	{	// check whether to process a CMD_ACK
	    if ( (*who)->pack.cmd == CMD_ACK )
    	    {
	        int i;
	        char *a = (char*)&((*who)->pack);
	        char *b = ((char*)&((*who)->pack))+sizeof(struct p_ack_t);
	        // copy packet to main buffer
	        memcpy(pack, &((*who)->pack), sizeof(struct p_ack_t));
	        // bring rest of (*who)->pack to the beginning of
	        // (*who)->pack
	        for (i=0;i<sizeof(struct p_ack_t);i++)
	        {
	            *a = *b;
	            a++;
	            b++;
	        }
	        // update received
	        (*who)->received -= sizeof(struct p_ack_t);
	        // how much to process, fake DCS/UDP style recv
		from->sin_addr.s_addr = (*who)->ip;
		from->sin_port = (*who)->port;
		*sock = (*who)->tcp_sock;
	        return(sizeof(struct p_ack_t));
	    }
	    else if ( (*who)->received >= sizeof(struct p_order_t) - LC_MAX_MSG_LEN - 1)
	    {   // assume p_order_t packet
	        // determine size
	        int size = sizeof(struct p_order_t)-LC_MAX_MSG_LEN-1+(*who)->pack.msglen;
	        if ( (*who)->received >= size )
	        {	// ok, we got the full packet
	            int i;
	            char *a = (char*)&((*who)->pack);
	            char *b = ((char*)&((*who)->pack))+size;
	            memcpy(pack, &((*who)->pack), size);
	            for (i=0;i<size;i++)
	            {
			*a = *b;
			a++;
			b++;
		    }
		    (*who)->received -= size;
		    from->sin_addr.s_addr = (*who)->ip;
		    from->sin_port = (*who)->port;
		    *sock = (*who)->tcp_sock;
		    return(size);
		}
	    }
	}
	else if ( (*who)->type == LCS_CLT_LCP3 )
	{	// LCP 3.0 client
	    if ( (*who)->received >= sizeof(struct t_lcp3_cmd) )
	    {
		struct t_lcp3_cmd *lcp3_cmd = (struct t_lcp3_cmd*)(&(*who)->pack);
		int size = get_lcp3_pack_size(lcp3_cmd->cmd);
//		int nsize;
		if ( (*who)->received >= size )
		{ // OK, we've got a full packet
			int i;
			char *a = (char*)&((*who)->pack);
			char *b = ((char*)&((*who)->pack))+size;
			memcpy(pack, &((*who)->pack), size);
			b = seek_lcp3_packet(b, (*who)->received-size);
			// the 'size' changed also... recalculate
//			nsize = (*who)->received - (b - a);
			if ( b )
			{
				(*who)->received -= size;
//				for (i=0;i<nsize;i++)
				for (i=0;i<(*who)->received;i++)
	        	{
			    	*a = *b;
			    	a++;
			    	b++;
				}
		    }
		    else
		    {
				(*who)->received = 0;
		    }
		    from->sin_addr.s_addr = (*who)->ip;
		    from->sin_port = (*who)->port;
		    *sock = (*who)->tcp_sock;
		    return(size);
		}
	    }
	}
	if ( single ) return(0);
	*who = (struct client_t*)(*who)->next;
    }
    return(0);
}

