/*b
 * Copyright (C) 2001,2002,2003  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include "config.h"
#include <locale.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <ncurses.h>
#include <panel.h>
#include <errno.h>
#include <ctype.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netdb.h>
#include <netinet/in.h>
#include "curse.h"
#include <pthread.h>
#include "debug.h"
#include "error.h"
#include "rc.h"
#include "streamer.h"
#include "pref.h"
#include "srpref.h"
#include "linuxtrade.h"
#include "stocklist.h"
#include "help.h"
#include "info.h"
#include "chart.h"
#include "news.h"
#include "alert.h"
#include "arca.h"
#include "island.h"
#include "qml2.h"
#include "l2sr.h"
#include "inplay.h"
#include "updown.h"
#include "splits.h"
#include "markcal.h"
#include "symlookup.h"
#include "optchain.h"
#include "holdings.h"
#include "bloomearn.h"
#include "quiet.h"
#include "wsrnearn.h"
#include "exthours.h"
#include "alertipo.h"
#include "toolmode.h"
#include "futs.h"
#include "util.h"

/*
 * Routines to sort the stocklist
 */

static int
byprice(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;

	return (sa->cur.last - sb->cur.last);
}
static int
byPrice(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;

	return (sb->cur.last - sa->cur.last);
}

static int
bygain(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;
	double	gaina, gainb;

	if (sa->cost >= 0)
		gaina = sa->nshares * sa->cur.last - sa->cost;
	else
		gaina = -sa->cost - sa->nshares * sa->cur.last;
	if (sb->cost >= 0)
		gainb = sb->nshares * sb->cur.last - sb->cost;
	else
		gainb = -sb->cost - sb->nshares * sb->cur.last;

	return (gaina - gainb);
}
static int
byGain(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;
	double	gaina, gainb;

	if (sa->cost >= 0)
		gaina = sa->nshares * sa->cur.last - sa->cost;
	else
		gaina = -sa->cost - sa->nshares * sa->cur.last;
	if (sb->cost >= 0)
		gainb = sb->nshares * sb->cur.last - sb->cost;
	else
		gainb = -sb->cost - sb->nshares * sb->cur.last;

	return (gainb - gaina);
}

static int
byvolume(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;

	return (sa->cur.volume - sb->cur.volume);
}
static int
byVolume(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;

	return (sb->cur.volume - sa->cur.volume);
}

static int
byname(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;

	return (strcasecmp(sa->sym, sb->sym));
}
static int
byName(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;

	return (strcasecmp(sb->sym, sa->sym));
}

static int
bychange(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;
	double	ca = 0.0, cb = 0.0;
	if (sa->cur.close)
		ca = (sa->cur.last - sa->cur.close) / sa->cur.close;
			
	if (sb->cur.close)
		cb = (sb->cur.last - sb->cur.close) / sb->cur.close;

	if (ca > cb)
		return 1;
	else if (ca < cb)
		return -1;
	else
		return 0;
}

static int
byChange(const void *va, const void *vb)
{
	STOCK	*sa = (STOCK *) va;
	STOCK	*sb = (STOCK *) vb;
	double	ca = 0.0, cb = 0.0;
	if (sa->cur.close)
		ca = (sa->cur.last - sa->cur.close) / sa->cur.close;
			
	if (sb->cur.close)
		cb = (sb->cur.last - sb->cur.close) / sb->cur.close;

	if (ca > cb)
		return -1;
	else if (ca < cb)
		return 1;
	else
		return 0;
}

typedef int (*QSORTCMP)(const void *a, const void *b);

void
dosort(QSORTCMP cmpfunc)
{
	int	num = NumStock - StockCursor;
	int	i;
	WINDOW	*oldwin;

	if (num < 2)
		return;

	display_stock_cursor(&Stock[StockCursor], FALSE);

	/* Sort the array */
	qsort(Stock + StockCursor, num, sizeof(STOCK), cmpfunc);

	/* Make a temporary copy of the current display */
	oldwin = newwin(4 + NumStock, COLS, 0, 0);
	copywin(stdscr, oldwin, 0,0,   0,0,  4+NumStock-1,COLS-1, FALSE);

	/* Copy the lines from their old locations to the new locations */
	for (i = StockCursor; i < NumStock; ++i)
	{
		int	oldy = Stock[i].y;
		int	newy = 4 + i;

		Stock[i].y = newy;
		copywin(oldwin, stdscr, oldy,0,  newy,0, newy,COLS-1, FALSE);
	}

	display_stock_cursor(&Stock[StockCursor], TRUE);
	delwin(oldwin);
}

/*
 * Load list 0 with stocks from players.txt file
 */
int
load_players(char *tag)
{
	FILE	*fp;
	char	*home = getenv("HOME");
	char	buf[BUFSIZ];
	char	*p;
	char	*comment = "";
	int	len;
	int	left, cleft;
	int	fileno = 1;
	int	num;
	char	symbuf[32];

	if (*tag != ':')
	    for (p = tag; *p; ++p)
		    *p = toupper(*p);

	debug(1, "tag=<%s>\n", tag);
	if (tag[0] == '@')
	{
	    yahoo_canon2sym(symbuf, tag+1);
	    sprintf(buf,"%s '"
			"http://finance.yahoo.com/d/quotes.csv?s=@%s"
			"&f=sn&e=.csv"
			"' "
			" | sed -e 's/\",/\t/g' -e 's/\"//g' -e 's/^/\t/'"
			, SUCKURL, symbuf
		    );
	    debug(1, "%s\n", buf);
	    fp = popen(buf, "r");
	    if (!fp)
		return 1;
	}
	else
	{
	    fp = fopen("players.txt", "r");
	    if (!fp)
	    {
	    userfile:
		    ++fileno;
		    sprintf(buf, "%s/." PROGNAMESTR "/players.txt", home);
		    fp = fopen(buf, "r");
		    if (!fp)
		    {
		    systemfile:
			    ++fileno;
			    fp = fopen("/usr/share/" PROGNAMESTR "/players.txt",
					    "r");
			    if (!fp)
				    return 1;
		    }
	    }

	    // Find tag in file
	    while (fgets(buf, sizeof(buf), fp))
	    {
		    p = strchr(buf, '\n'); if (p) *p = 0;
		    p = strchr(buf, '\r'); if (p) *p = 0;
		    p = strchr(buf, '#'); if (p) *p = 0;
		    if (!buf[0]) continue;

		    comment = strchr(buf, '\t');
		    if (comment) *comment++ = 0; else comment = "";

		    if (strcasecmp(buf, tag) == 0)
			    break;
	    }
	    if (feof(fp))
	    {
		    fclose(fp);
		    if (fileno < 2)
			    goto userfile;
		    if (fileno < 3)
			    goto systemfile;
		    return 2;
	    }

	    strncpy(StockList0Name, comment, sizeof(StockList0Name)-1);
	    StockListName[sizeof(StockList0Name)-1] = 0;
	}

	// Get symbols and comments from file
	List0[0] = 0;
	List0Comments[0] = 0;
	left = sizeof(List0) - 2;
	cleft = sizeof(List0Comments) - 2;
	num = 0;
	while (fgets(buf, sizeof(buf), fp))
	{
		char	*sym;

		p = strchr(buf, '\n'); if (p) *p = 0;
		p = strchr(buf, '\r'); if (p) *p = 0;
		p = strchr(buf, '#'); if (p) *p = 0;
		if (buf[0] != '\t')
			break;
		sym = buf+1;
		comment = strchr(sym, '\t');
		if (comment) *comment++ = 0; else comment = "xx";
		if (num++ == 0 && tag[0] == '@')
		{
		    strncpy(StockList0Name, comment, sizeof(StockList0Name)-1);
		    StockListName[sizeof(StockList0Name)-1] = 0;
		}

		if (tag[0] == '@')
		{
		    yahoo_sym2canon(symbuf, sym);
		    sym = symbuf;
		}

		len = strlen(sym);
		if (left >= len)
		{
			if (List0[0])
				strcat(List0, " ");
			strcat(List0, sym);
			left -= len+1;
		}
		len = strlen(comment);
		if (cleft >= len)
		{
			strcat(List0Comments, comment);
			strcat(List0Comments, "\n");
			cleft -= len+1;
		}
	}

	if (tag[0] == '@')
	    pclose(fp);
	else
	    fclose(fp);

	return (*List0 ? 0 : 3);
}

/*
 * Set stock comment to current date
 */
static void
timestamp_comments(void)
{
	int		i;
	time_t		now;
	struct tm	*tmp;
	char		buf[128];
	char		*fmt = "%x";

	time(&now);
	tmp = localtime(&now);
	strftime(buf, sizeof(buf), fmt, tmp);
	buf[5] = 0;

	for (i = 0; i < NumStock; ++i)
	{
		strcpy(Stock[i].comment, buf);
	}
}

static void
external_to_list0(STREAMER sr, char *cmd)
{
	FILE	*fp;
	char	buf[BUFSIZ];
	int	left;
	int	cleft;
	int	len;
	char	*p;

	fp = popen(cmd+1, "r");
	if (!fp) return;

	strncpy(StockListName, cmd, sizeof(StockListName)-1);
	StockListName[sizeof(StockListName)-1] = 0;

	List0[0] = 0;
	List0Comments[0] = 0;
	left = sizeof(List0) - 2;
	cleft = sizeof(List0Comments) - 2;
	while (fgets(buf, sizeof(buf), fp))
	{
		p = strchr(buf, '\r'); if (p) *p = 0;
		p = strchr(buf, '\n'); if (p) *p = 0;

		if (strncmp(buf, "label=", 5) == 0)
		{
			strncpy(StockListName, buf+6,
					sizeof(StockListName)-1);
			StockListName[sizeof(StockListName)-1] = 0;
		}
		else 
		{
			p = strchr(buf, '\t'); if (p) *p = 0;
			len = strlen(buf);
			if (left >= len)
			{
				if (List0[0])
					strcat(List0, " ");
				strcat(List0, buf);
				left -= len+1;
			}
			if (p++)
			{
				len = strlen(p);
				if (cleft >= len)
				{
					strcat(List0Comments, p);
					strcat(List0Comments, "\n");
					cleft -= len+1;
				}
			}
		}
	}

	pclose(fp);

	new_stocklist(sr, 0, List0, NULL);
	add_comments(List0Comments);
}

void
docolon(STREAMER sr, char *cmd, int	(**handlerp)(int c, STREAMER sr))
{
	char	*arg;
	char	*arg2;
	int	len;
	int	rc;
	int	n;

	if (cmd[0] == 0)
		return;

	// Get argument, if any
	arg = strchr(cmd, ' ');
	if (!arg) arg = strchr(cmd, 0);
	len = arg - cmd;
	while (*arg == ' ')
		++arg;

	if (len == 0)
	{
		beep();
		return;
	}

	n = atoi(cmd);

	if (cmd[0] == '!')
	{
		external_to_list0(sr, cmd);
	}
	else if (n >= 10 && n <= 99)
	{
	    char *sp;
	    ListNum = n;
	    sp = stocklist_read(ListNum);
	    new_stocklist(sr, ListNum, sp, NULL);
	    if (TsDisplayed)
		display_ts();
	}
	else if (strcmp(cmd, "help") == 0 || strcmp(cmd, "?") == 0)
	{
		*handlerp = help_command;
		help_popup(":colon");
	}
	else if (strncmp(cmd, "news", len) == 0
	    || strncmp(cmd, "snews", len) == 0
	    || strncmp(cmd, "onews", len) == 0
	    || strncmp(cmd, "mnews", len) == 0)
	{
		STOCK	tmp;
		int	mode = NEWS_DEFAULT;

		if (cmd[0] == 'm')
			mode = NEWS_MAIN;
		else if (cmd[0] == 's')
			mode = NEWS_STREAMER;
		else if (cmd[0] == 'o')
			mode = NEWS_SAVED;

		if (*arg && strcmp(arg, "saved") == 0)
		{
			*handlerp = news_command;
			news_popup(sr, NULL, NEWS_SAVED);
		}
		else if (*arg)
		{
			char	*p;

			strncpy(tmp.sym, arg, SYMLEN); tmp.sym[SYMLEN] = 0;
			for (p = tmp.sym; *p; ++p)
				*p = toupper(*p);
			*handlerp = news_command;
			news_popup(sr, &tmp, mode);
		}
		else if (NumStock)
		{
			*handlerp = news_command;
			news_popup(sr, &Stock[StockCursor], mode);
		}
	}
	else if (strncmp(cmd, "after", len) == 0)
	{
		*handlerp = exthours_command;
		exthours_popup(*arg ? arg : Stock[StockCursor].sym, "after");
	}
	else if (strncmp(cmd, "arca", len) == 0)
	{
		if (*arg)
		{
			STOCK	tmp;
			char	*p;

			strncpy(tmp.sym, arg, SYMLEN); tmp.sym[SYMLEN] = 0;
			for (p = tmp.sym; *p; ++p)
				*p = toupper(*p);
			arca_popup(&tmp);
		}
		else
			arca_popup(&Stock[StockCursor]);
		*handlerp = arca_command;
	}
	else if (strncmp(cmd, "bwkvol", len) == 0)
	{
		external_to_list0(sr, " linuxtrade.bwkvol");
		timestamp_comments();
	}
	else if (strncmp(cmd, "chart", len) == 0)
	{
		int usecharts = atoi(get_rc_value(SrCur->rcfile,"usecharts"));

		*handlerp = chart_command;
		if (*arg)
		{
			static STOCK	tmp;
			char		*p;

			memset(&tmp, 0, sizeof(tmp));
			strncpy(tmp.sym, arg, SYMLEN); tmp.sym[SYMLEN] = 0;
			for (p = tmp.sym; *p; ++p)
				*p = toupper(*p);
			chart_popup(&tmp, usecharts ? sr : NULL);
		}
		else
			chart_popup(&Stock[StockCursor], usecharts ? sr : NULL);
	}
	else if (strncmp(cmd, "carpet", len) == 0)
	{
		char	buf[BUFSIZ];
		sprintf(buf, "linuxtrade.cpt %s >/dev/null  2>&1 &", arg);
		system(buf);
	}
	else if (strncmp(cmd, "comment", len) == 0 && NumStock)
	{
		char	buf[BUFSIZ];
		char	pbuf[64];

		sprintf(pbuf, "%.2f", Stock[StockCursor].cur.last);
		strsub(buf, sizeof(buf), arg, "<p>", pbuf);

		strncpy(Stock[StockCursor].comment, buf, COMLEN);
		Stock[StockCursor].comment[COMLEN] = 0;
		display_quote(&Stock[StockCursor].cur, 0);
	}
	else if (strncmp(cmd, "clrcom", len) == 0 && NumStock)
	{
		int	i;
		for (i = 0; i < NumStock; ++i)
		{
			Stock[i].comment[0] = 0;
			display_quote(&Stock[i].cur, 0);
		}
	}
	else if (strncmp(cmd, "clralerts", len) == 0 && NumStock)
	{
		int	i;
		for (i = 0; i < NumStock; ++i)
		{
			alert_delete_all(Stock[i].sym);
			alert_bind1(&Stock[i]);
			display_quote(&Stock[i].cur, 0);
		}
		alert_save();
	}
	else if (strncmp(cmd, "clrhold", len) == 0 && NumStock)
	{
		int	i;
		for (i = 0; i < NumStock; ++i)
		{
			Stock[i].nshares = 0;
			Stock[i].cost = 0;
			display_quote(&Stock[i].cur, 0);
		}
	}
	else if (strncmp(cmd, "dow", len) == 0)
	{
		rc = load_players(":dow");
		if (rc == 0)
		{
			new_stocklist(sr, 0, List0, StockList0Name);
			add_comments(List0Comments);
		}
	}
	else if (strncmp(cmd, "earnings", len) == 0 && NumStock)
	{
		launch_url("pref:earnings_URL",
				*arg ? arg : Stock[StockCursor].sym);
	}
	else if (strncmp(cmd, "econ",len) == 0)
	{
		*handlerp = markcal_command;
		markcal_popup(sr);
	}
	else if (strncmp(cmd, "eatext", 6) == 0)
	{
		if (*arg)
		{
			*handlerp = wsrnearn_command;
			wsrnearn_popup(sr, arg);
		}
		else if (NumStock)
		{
			*handlerp = wsrnearn_command;
			wsrnearn_popup(sr, Stock[StockCursor].sym);
		}
		else
			beep();
	}
	else if (strncmp(cmd, "futs", 2) == 0)
	{
		char	buf[BUFSIZ];
		char	sym[16];
		time_t	rightnow = 0;

		futscode(sym, "NQ", FUTS_LYCOS, &rightnow);

		if (arg[0])
			sprintf(buf, "java sun.applet.AppletViewer "
				"http://finance.lycos.com/"
				"home/livecharts/body.asp?symbols=%s "
				">/dev/null 2>&1 &",
				sym);
		else
			sprintf(buf, "linuxtrade.lc '%s' >/dev/null 2>&1 &",
				sym);
		system(buf);
	}
	else if (strncmp(cmd, "frb", len) == 0 && NumStock)
	{
		// Should do a popup for this...
		launch_url("http://app.ny.frb.org/dmm/mkt.cfm", NULL);
	}
	else if (strncmp(cmd, "heatmap", len) == 0)
	{
		char	buf[BUFSIZ];
		sprintf(buf, "linuxtrade.hm %s >/dev/null  2>&1 &", arg);
		system(buf);
	}
	else if (strncmp(cmd, "halts", len) == 0 && NumStock)
	{
		// Should do a popup for this...
		launch_url("http://www.nasdaqtrader.com"
				"/asp/tradehaltshowpage.asp", NULL);
	}
	else if (strncmp(cmd, "homepage", len) == 0
			|| strncmp(cmd, "grouppage", len) == 0)
	{
		char	*launcher = get_rc_value(RcFile, "browser");
		char	*urlbuf;
		char	*p;
		char	buf[512];

		if (cmd[0] == 'h')
			urlbuf = "'http://linuxtrade.0catch.com'";
		else
			urlbuf = "'http://groups.yahoo.com/group/linuxtrade/'";

		if ( (p = strchr(launcher, '%')) && p[1] == 's')
			sprintf(buf, launcher, urlbuf);
		else
		{
			strcpy(buf, launcher);
			strcat(buf, " ");
			strcat(buf, urlbuf);
		}
		system(buf);
	}
	else if (strncmp(cmd, "island", len) == 0)
	{
		if (*arg)
		{
			STOCK	tmp;
			char	*p;

			strncpy(tmp.sym, arg, SYMLEN); tmp.sym[SYMLEN] = 0;
			for (p = tmp.sym; *p; ++p)
				*p = toupper(*p);
			island_popup(&tmp);
		}
		else
			island_popup(&Stock[StockCursor]);
		*handlerp = island_command;
	}
	else if (strncmp(cmd, "indexes", len) == 0)
	{
		index_list(List0, sizeof(List0));
		new_stocklist(sr, 0, List0, "Indexes");
	}
	else if (strncmp(cmd, "ibdvol", len) == 0)
	{
		external_to_list0(sr, " linuxtrade.ibdvol");
		timestamp_comments();
	}
	else if (strncmp(cmd, "ipo",len) == 0)
	{
		*handlerp = alertipo_command;
		alertipo_popup(sr);
	}
	else if (strncmp(cmd, "label", len) == 0)
	{
		strncpy(StockListName, arg, sizeof(StockListName)-1);
		StockListName[sizeof(StockListName)-1] = 0;
		display_status(sr, FALSE);
	}
	else if (strncmp(cmd, "list", len) == 0)
	{
		int	n;

		n = stocklist_find(arg);
		if (n >= 1 && n <= 99)
		{
		    char	*sp;
		    ListNum = n;
		    sp = stocklist_read(ListNum);
		    new_stocklist(sr, ListNum, sp, NULL);
		    if (TsDisplayed)
			display_ts();
		}
		else
		    beep();

	}
	else if (strncmp(cmd, "lookup",len) == 0 && *arg)
	{
		*handlerp = symlookup_command;
		symlookup_popup(sr, arg);
	}
	else if (strncmp(cmd, "pf", 2) == 0 || strncmp(cmd, "lc", 2) == 0
			|| strncmp(cmd, "mn", 2) == 0)
	{
		char	buf[BUFSIZ];
		char	*opts = NULL;

		while (*arg == '-')
		{
			if (!opts)
				opts = arg;

			while (*arg && *arg != ' ')
				++arg;
			while (*arg && *arg == ' ')
				++arg;
		}
		if (opts && *arg)
			arg[-1] = 0;
		if (!opts)
			opts = "";

		if (strncmp(cmd, "mn", 2) == 0)
		{
			cmd = "pf";
			opts = "-m";
		}

		if (strcmp(arg, "all") == 0)
		{
			int	i, n;
			sprintf(buf, "linuxtrade.%2.2s %s", cmd, opts);
			for (i = n = 0; i < NumStock; ++i)
			{
				if (Stock[i].sym[0] == '$')
					continue;
				++n;
				strcat(buf, " '");
				strcat(buf, Stock[i].sym);
				strcat(buf, "'");
			}
			strcat(buf, " >/dev/null 2>&1 &");
		}
		else
		{
			sprintf(buf,
				"linuxtrade.%2.2s %s '%s' >/dev/null 2>&1 &",
				cmd, opts, *arg? arg : Stock[StockCursor].sym);
		}
		system(buf);
	}
	else if (strncmp(cmd, "mmid", len) == 0 && *arg)
	{
		char	buf[BUFSIZ];
		sprintf(buf, "%s: %s", arg, mmid_lookup(arg));
		display_msg(A_NORMAL, buf);
	}
	else if (strncmp(cmd, "majors", len) == 0)
	{
		rc = load_players(":majors");
		if (rc == 0)
		{
			new_stocklist(sr, 0, List0, StockList0Name);
			add_comments(List0Comments);
		}
	}
	else if (strncmp(cmd, "manualpage", len) == 0)
	{
		char	buf[BUFSIZ];
		static char	*doc = "/usr/share/doc/"
					PROGNAMESTR "-" VERSION
					"/" PROGNAMESTR ".1.pdf";

		sprintf(buf, "(acroread %s || xpdf %s) >/dev/null 2>&1 &",
				doc, doc);
		system(buf);
	}
	else if (strncmp(cmd, "players", len) == 0)
	{
		if (strcmp(arg, "@") == 0)
		{
		    char	symbuf[32];
		    sprintf(symbuf, "@%s", Stock[StockCursor].sym);
		    rc = load_players(symbuf);
		}
		else
		    rc = load_players(*arg ? arg : Stock[StockCursor].sym);
		if (rc == 0)
		{
			new_stocklist(sr, 0, List0, StockList0Name);
			add_comments(List0Comments);
		}
	}
	else if (strncmp(cmd, "name", len) == 0 && NumStock)
	{
		display_msg(A_NORMAL, "Retrieving full name...");
		leave_cursor();
		update_panels(); refresh(); // doupdate();
		external_msg("name",
				*arg ? arg : Stock[StockCursor].sym, NULL);
	}
	else if (strncmp(cmd, "pe", len) == 0 && NumStock)
	{
		display_msg(A_NORMAL, "Retrieving P/E ratios...");
		leave_cursor();
		update_panels(); refresh(); // doupdate();
		external_msg("pe",
				*arg ? arg : Stock[StockCursor].sym, NULL);
	}
	else if (strncmp(cmd, "pivot", len) == 0 && NumStock)
	{
		display_msg(A_NORMAL, "Retrieving pivots...");
		leave_cursor();
		update_panels(); refresh(); // doupdate();
		external_msg("pivot",
				*arg ? arg : Stock[StockCursor].sym, NULL);
	}
	else if (strncmp(cmd, "pre", len) == 0)
	{
		*handlerp = exthours_command;
		exthours_popup(*arg ? arg : Stock[StockCursor].sym, "pre");
	}
	else if (strncmp(cmd, "qp", 2) == 0)
	{
		*handlerp = quiet_command;
		quiet_popup(sr);
	}
	else if (strncmp(cmd, "range", len) == 0 && NumStock)
	{
		arg2 = strchr(arg, ' ');
		if (arg2) {
			*arg2++ = 0;
		}
		if (atoi(arg))
		{
			arg2 = arg;
			arg = Stock[StockCursor].sym;
		}
		display_msg(A_NORMAL, "Retrieving daily range...");
		leave_cursor();
		update_panels(); refresh(); // doupdate();
		external_msg("range",
				*arg ? arg : Stock[StockCursor].sym, arg2);
	}
	else if (strncmp(cmd, "save", len) == 0)
	{
		int	n = atoi(arg);

		if (n == 0)
		    n = ListNum;
		if (n >= 1 && n <= 99)
		{
		    ListNum = n;
		    stocklist_write(ListNum);
		    display_title();
		}
	}
	else if (strncmp(cmd, "sort", len) == 0)
	{
		switch (*arg)
		{
		case 'p': dosort(byprice); break;
		case 'P': dosort(byPrice); break;
		case 'v': dosort(byvolume); break;
		case 'V': dosort(byVolume); break;
		case 'g': dosort(bygain); break;
		case 'G': dosort(byGain); break;
		case 'c': dosort(bychange); break;
		case 'C': dosort(byChange); break;
		case 'n': case 's': dosort(byname); break;
		case 'N': case 'S': dosort(byName); break;
		default: beep(); break;
		}
	}
	else if (strncmp(cmd, "shortint", len) == 0 && NumStock)
	{
		display_msg(A_NORMAL, "Retrieving short interest...");
		leave_cursor();
		update_panels(); refresh(); // doupdate();
		external_msg("shortint",
				*arg ? arg : Stock[StockCursor].sym, NULL);
	}
	else if (strncmp(cmd, "splits",len) == 0)
	{
		*handlerp = splits_command;
		splits_popup(sr);
	}
	else if (strncmp(cmd, "spiders", len) == 0)
	{
		rc = load_players(":spiders");
		if (rc == 0)
		{
			new_stocklist(sr, 0, List0, StockList0Name);
			add_comments(List0Comments);
		}
	}
	else if (strncmp(cmd, "streamer", len) == 0 && *arg)
	{
		char	*streamer = match_streamer(arg);
		if (streamer)
		{
			set_rc_value(RcFile, "streamer", streamer);
			NewStreamer = TRUE;
		}
	}
	else if (strncmp(cmd, "stats", len) == 0)
	{
		time_t	now = time(NULL);
		int	uptime = now - sr->time_start;
		int	opentime = now - sr->time_open;
		int	realopentime = now - sr->time_realopen;

		qfmt_init();
		display_msg(A_NORMAL, "stats: T=%s %s %s  C=%d %d %d",
				qfmt_etime(uptime),
				qfmt_etime(opentime),
				qfmt_etime(realopentime),
				sr->cnt_opens, sr->cnt_realopens,
				sr->cnt_rx);
	}
	else if (strncmp(cmd, "total", len) == 0)
	{
		double	totcost, totvalue, totgain, gain;
		int	i;
		STOCK	*sp;

		totcost = totvalue = totgain = 0;
		for (i = 0, sp = Stock; i < NumStock; ++i, ++sp)
		{
			totcost += sp->cost;
			if (sp->cost >= 0)
				gain = sp->nshares * sp->cur.last - sp->cost;
			else
				gain = -sp->cost - sp->nshares * sp->cur.last;
			totgain += gain;
		}
		totvalue = totcost + totgain;

		display_msg(A_NORMAL,
			"Totals: Cost = $%.2f, Value = $%.2f, "
			"Gain = $%.2f (%.2f%%)",
			totcost, totvalue, totgain,
			totcost ? (totgain / totcost) * 100.0: 0
			);
		leave_cursor();
	}
	else if (strncmp(cmd, "trading", len) == 0)
	{
		strcpy(List0,
			"$DJI $SPX $COMP GE FCEL WMT "
			"$XAL AMR DAL "
			"$BKX AXP BAC ONE "
			"$BTK HGSI IDPH MEDI "
			"$XBD BSC LEH JPM "
			"$XCI AAPL CSCO EMC EMLX IBM "
			"$XAU DROOY KRY MDG NEM "
			"$DRG MRK JNJ "
			"$XOI NE SLB PTEN "
			"$NWX CIEN TLAB QCOM "
			"$SOX AMAT BRCM INTC KLAC NVLS MXIM QLGC XLNX "
			"$GSO ADBE BEAS CHKP MSFT ORCL SEBL VRSN VRTS "
			"$XTC CAMP FDRY EXTR"
			);
		new_stocklist(sr, 0, List0, "trading");
	}
	else if (strncmp(cmd, "ts", len) == 0)
	{
		/*
		 * Time and Sales from quote.com
		 *
		 * Mode argument is:
		 * 0: true time and sales
		 * 1: one minute aggragated trades
		 *
		 */
		char	*user = get_rc_value(RcFile, "lc_user");
		char	*encpass = get_rc_value(RcFile, "lc_encpass");
		char	buf[BUFSIZ];
		time_t	now;
		struct tm *tmp;

		if (!*arg)
		    arg = Stock[StockCursor].sym;
		arg2 = strchr(arg, ' ');
		if (arg2) *arg2++ = 0;
		if (arg[0] >= '0' && arg[0] <= '9')
		{
			char *tmp = arg;
			if (!arg2)
			    arg2 = Stock[StockCursor].sym;
			arg = arg2;
			arg2 = tmp;
		}
		else if (!arg2)
			arg2 = "0";

		time(&now);
		tmp = gmtime(&now);
		sprintf(buf,
			"http://charts-r.quote.com:443"
			"/%02d%02d%02d%02d%02d000"
			"?User=%s&Pswd=%s"
			"&DataType=DATA"
			"&Interval=%d"
			"&Symbol=%s",
			// Use time - it doesn't see to matter what goes here
			tmp->tm_year % 100,
			tmp->tm_mon + 1,
			tmp->tm_mday,
			tmp->tm_hour,
			tmp->tm_min,
			user, encpass,
			atoi(arg2),
			arg);
		launch_url(buf, NULL);
	}
	else if (strncmp(cmd, "wide", len) == 0)
	{
		all_charts_from_array("-i -W");
	}
	else if (strncmp(cmd, "Wide", len) == 0)
	{
		all_charts_from_array("-W");
	}
	else if (strncmp(cmd, "weekly", len) == 0)
	{
		all_charts_from_array("-w");
	}
	else if (strncmp(cmd, "Weekly", len) == 0)
	{
		all_charts_from_array("-w -W");
	}
	else if (strncmp(cmd, "wc", len) == 0)
	{
		all_charts_from_list("-W -T -b",
				*arg? arg : Stock[StockCursor].sym);
	}
	else if (strncmp(cmd, "whisper", len) == 0 && NumStock)
	{
		display_msg(A_NORMAL, "Retrieving whisper number...");
		leave_cursor();
		update_panels(); refresh(); // doupdate();
		external_msg("wn",
				*arg ? arg : Stock[StockCursor].sym, NULL);
	}
	else
		beep();
}
