typedef struct
{
	int     sx;     // Starting column
	int     ex;     // Ending column
} TBLCOL;

void minihtml_parse(
		WINDOW *win,
		FILE *fp,
		TBLCOL *cols,
		int	numcol,
		int	flags,
			#define	MHP_DEFAULT	0	// default operation
			#define	MHP_EATBLANK	1	// eat blank lines
			#define	MHP_UL_ITALICS	2	// underline italics
			#define	MHP_PREFORMAT	4	// <pre> mode
		int (*prewordhook)(int *tblcolp, char *wbuf, int wlen),
		void (*postwordhook)(int *tblcolp, char *wbuf,int wlen),
		void (*anchorhook)(char *parmp, int tblcol, int slash),
		int (*tablehook)(int tblcnt, TBLCOL **colsp,
						int *numcolp, int slash)
		);

void minihtml_colorcol(
		WINDOW *win,
		TBLCOL	*cols,
		int	col,
		attr_t	color
		);

void minihtml_skip_past_line(FILE *fp, char *str);

int minihtml_getword(char *buf, int size, FILE *fp);

void minihtml_newline(WINDOW *win);
