/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <unistd.h>
#include "rc.h"
#include "streamer.h"

typedef struct streamerpriv
{
	int	dummy;
} STREAMERDATA;

static int 
streamer_open( STREAMER sr, RCFILE *rcp, FILE *readfile)
{
	++sr->cnt_opens;
	++sr->cnt_realopens;
	time(&sr->time_open);
	time(&sr->time_realopen);

	return 0;
}
static int
streamer_select(
		STREAMER sr,
		int n, fd_set *readfds, fd_set *writefds,
		fd_set *exceptfds, struct timeval *timeout
		)
{
	return select(n, readfds, writefds, exceptfds, timeout);
}

static void
streamer_close(STREAMER sr)
{
}

static void
streamer_record(STREAMER sr, FILE *fp) {}

static void
streamer_timetick(STREAMER sr, time_t now) {}

static void
streamer_send_quickquote(STREAMER sr, char *sym) {}

static void
streamer_send_livequote(STREAMER sr, char *sym) {}

static void
streamer_send_livequote_end(STREAMER sr) {}

static void
streamer_send_symbols(STREAMER sr, char *symbols, int add) {}

static void
streamer_send_symbols_end(STREAMER sr, int add, int all) {}

static void
streamer_send_disconnect(STREAMER sr) {}

static void
streamer_send_top10(STREAMER sr, char market, int type, int add) {}

static void
streamer_send_movers(STREAMER sr, int on) {}

static void
streamer_send_info(STREAMER sr, char *sym, int type) {}

static void
streamer_send_optchain(STREAMER sr, char *sym) {}

static int
streamer_send_chart(STREAMER sr, char *sym, int freq, int periods, int days)
{
	return SR_ERR;
}

static int
streamer_process(STREAMER sr, int fdindex)
{
	return 0;
}

static void
streamer_init(STREAMER sr)
{
	sr->refresh = 0;
	sr->fd[0] = 0;
	sr->nfd = 0;
	strcpy(sr->id, "none");
}

STREAMER
null_new(void)
{
	STREAMER	sr;

	sr = (STREAMER) malloc(sizeof(*sr));
	if (!sr)
		return NULL;
	memset(sr, 0, sizeof(*sr));

	sr->open = streamer_open;
	sr->select = streamer_select;
	sr->close = streamer_close;
	sr->record = streamer_record;
	sr->timetick = streamer_timetick;

	sr->send_quickquote = streamer_send_quickquote;
	sr->send_livequote = streamer_send_livequote;
	sr->send_livequote_end = streamer_send_livequote_end;
	sr->send_disconnect = streamer_send_disconnect;
	sr->send_symbols = streamer_send_symbols;
	sr->send_symbols_end = streamer_send_symbols_end;
	sr->send_top10 = streamer_send_top10;
	sr->send_movers = streamer_send_movers;
	sr->send_info = streamer_send_info;
	sr->send_optchain = streamer_send_optchain;
	sr->send_chart = streamer_send_chart;

	sr->process = streamer_process;

	sr->priv = (STREAMERDATA *) malloc(sizeof(*sr->priv));
	if (!sr->priv)
	{
		free(sr);
		return NULL;
	}

	time(&sr->time_start);

	streamer_init(sr);

	return (sr);
}
