/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Doppler.h"

#include <cmath>
using namespace std;

#include "Exception.h"

const int BUFFER_LEN = 64;

CDoppler::CDoppler(int sampleRate) :
m_mixer(sampleRate)
{
	wxASSERT(sampleRate > 0);
}

CDoppler::~CDoppler()
{
}

void CDoppler::transform(double* input, double startFrequency, double endFrequency, double* output, int length)
{
	wxASSERT(input != NULL);
	wxASSERT(output != NULL);
	wxASSERT(length > 0);

	if ((length % BUFFER_LEN) > 0)
		throw CException(wxT("Invalid length in Doppler.cpp, not a multiple of BUFFER_LEN"));

	double rate = (endFrequency - startFrequency) / double(length);

	int outputIndex = 0;
	for (int i = 0; i < length; i += BUFFER_LEN) {
		double freq = startFrequency + double(i) * rate;

		double out[BUFFER_LEN];
		m_mixer.mix(freq, input + i, out, BUFFER_LEN);

		for (int j = 0; j < BUFFER_LEN; j++, outputIndex++)
			output[outputIndex] = out[j];
	}
}
