/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Locator.h"
#include "Inline.h"

CLocator::CLocator(const wxString& locator) :
m_locator(locator),
m_latitude(0.0),
m_longitude(0.0),
m_valid(false)
{
	m_locator.MakeUpper();

	if (m_locator.Length() != 6 && m_locator.Length() != 8)
		return;

	if (m_locator.GetChar(0) < 'A' || m_locator.GetChar(0) > 'R' ||
	    m_locator.GetChar(1) < 'A' || m_locator.GetChar(1) > 'R' ||
	    m_locator.GetChar(2) < '0' || m_locator.GetChar(2) > '9' ||
	    m_locator.GetChar(3) < '0' || m_locator.GetChar(3) > '9' ||
	    m_locator.GetChar(4) < 'A' || m_locator.GetChar(4) > 'X' ||
	    m_locator.GetChar(5) < 'A' || m_locator.GetChar(5) > 'X')
		return;

	if (m_locator.Length() == 8 &&
	   (m_locator.GetChar(6) < '0' || m_locator.GetChar(6) > '9' ||
	    m_locator.GetChar(7) < '0' || m_locator.GetChar(7) > '9'))
		return;

	m_longitude = -180.0 + FIELD_WIDTH   * (m_locator.GetChar(0) - 'A') +
			       SQUARE_WIDTH  * (m_locator.GetChar(2) - '0') +
			       SUB_WIDTH     * (m_locator.GetChar(4) - 'A');

	m_latitude  = -90.0  + FIELD_HEIGHT  * (m_locator.GetChar(1) - 'A') +
			       SQUARE_HEIGHT * (m_locator.GetChar(3) - '0') +
			       SUB_HEIGHT    * (m_locator.GetChar(5) - 'A');

	if (m_locator.Length() == 8) {
		m_longitude += SUB_SUB_WIDTH  * (m_locator.GetChar(6) - '0') + SUB_SUB_WIDTH / 2.0;
		m_latitude  += SUB_SUB_HEIGHT * (m_locator.GetChar(7) - '0') + SUB_SUB_HEIGHT / 2.0;
	} else {
		m_longitude += SUB_SUB_WIDTH * 5.0;
		m_latitude  += SUB_SUB_HEIGHT * 5.0;
		m_locator.Append("55");
	}

	m_valid = true;
}

CLocator::CLocator(double latitude, double longitude) :
m_locator(wxEmptyString),
m_latitude(latitude),
m_longitude(longitude),
m_valid(false)
{
	if (m_latitude > 90.0 || m_latitude < -90.0)
		return;

	if (m_longitude > 180.0 || m_longitude < -180.0)
		return;

	latitude  += 90.0;
	longitude += 180.0;

	int ilong = int(longitude / FIELD_WIDTH);
	m_locator.Append(ilong + 'A');
	longitude -= double(ilong) * FIELD_WIDTH;

	int ilat = int(latitude / FIELD_HEIGHT);
	m_locator.Append(ilat + 'A');
	latitude -= double(ilat) * FIELD_HEIGHT;

	ilong = int(longitude / SQUARE_WIDTH);
	m_locator.Append(ilong + '0');
	longitude -= double(ilong) * SQUARE_WIDTH;

	ilat = int(latitude / SQUARE_HEIGHT);
	m_locator.Append(ilat + '0');
	latitude -= double(ilat) * SQUARE_HEIGHT;

	ilong = int(longitude / SUB_WIDTH);
	m_locator.Append(ilong + 'A');
	longitude -= double(ilong) * SUB_WIDTH;

	ilat = int(latitude / SUB_HEIGHT);
	m_locator.Append(ilat + 'A');
	latitude -= double(ilat) * SUB_HEIGHT;

	ilong = int(longitude / SUB_SUB_WIDTH);
	m_locator.Append(ilong + '0');

	ilat = int(latitude / SUB_SUB_HEIGHT);
	m_locator.Append(ilat + '0');

	m_valid = true;
}

CLocator::~CLocator()
{
}

bool CLocator::isValid() const
{
	return m_valid;
}

wxString CLocator::getLocator() const
{
	return m_locator;
}

double CLocator::getLatitude() const
{
	return m_latitude;
}

double CLocator::getLongitude() const
{
	return m_longitude;
}
