/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	Locator_H
#define	Locator_H

#include <wx/string.h>

const double FIELD_WIDTH    = 20.0;			/* A - R */
const double FIELD_HEIGHT   = 10.0;			/* A - R */
const double SQUARE_WIDTH   = FIELD_WIDTH / 10.0;	/* 0 - 9 */
const double SQUARE_HEIGHT  = FIELD_HEIGHT / 10.0;	/* 0 - 9 */
const double SUB_WIDTH      = SQUARE_WIDTH / 24.0;	/* A - X */
const double SUB_HEIGHT     = SQUARE_HEIGHT / 24.0;	/* A - X */
const double SUB_SUB_WIDTH  = SUB_WIDTH / 10.0;		/* 0 - 9 */
const double SUB_SUB_HEIGHT = SUB_HEIGHT / 10.0;	/* 0 - 9 */

class CLocator {

    public:
	CLocator(const wxString& locator);
	CLocator(double latitude, double longitude);
	virtual ~CLocator();

	virtual bool isValid() const;

	virtual wxString getLocator() const;

	virtual double   getLatitude() const;
	virtual double   getLongitude() const;

    private:
	wxString m_locator;
	double   m_latitude;
	double   m_longitude;
	bool     m_valid;
};

#endif
