/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Display_H
#define	FSK441Display_H

#include <wx/wx.h>
#include <wx/listctrl.h>

#include "fsk441/FSK441Levels.h"
#include "fsk441/FSK441Spectrum.h"
#include "fsk441/FSK441Message.h"

#include "FSK441LevelGraph.h"
#include "FSK441SpectrumGraph.h"

class CFSK441Display : public wxPanel {
    public:
	CFSK441Display(wxWindow* parent, int id = -1);
	virtual ~CFSK441Display();

	virtual void onMessageSelected(const wxListEvent& event);
	virtual void onMessageClick(const wxListEvent& event);

	virtual void onClearMessages(const wxCommandEvent& event);

	virtual void showMessage(CFSK441Message* message);
	virtual void showLevels(CFSK441Levels* levels) const;
	virtual void showSpectrum(CFSK441Spectrum* spectrum) const;

	virtual void setMinLength(int length);
	virtual void setMinStrength(int strength);

    private:
	CFSK441LevelGraph*    m_levelGraph;
	CFSK441SpectrumGraph* m_spectrumGraph;
	wxListCtrl*           m_messageListCtrl;
	wxMenu*               m_messageMenu;
	int                   m_listCount;
	int                   m_selected;
	int                   m_minLength;
	int                   m_minStrength;
	CFSK441MessageList*   m_messageList;

	DECLARE_EVENT_TABLE()

	wxMenu* createMessageMenu();
};

#endif
