/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441SettingsControl.h"

#include <wx/spinctrl.h>

const int BORDER_SIZE = 5;

CFSK441SettingsControl::CFSK441SettingsControl(wxWindow* parent, int id, int minLength, int minStrength) :
wxPanel(parent, id)
{
	wxStaticBoxSizer* sizer = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Min Settings")), wxVERTICAL);

	wxBoxSizer* lengthSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* lengthLabel = new wxStaticText(this, -1, wxT("Length"), wxDefaultPosition, wxSize(50, -1));
	lengthSizer->Add(lengthLabel, 0, wxTOP, BORDER_SIZE);

	wxSpinCtrl* length = new wxSpinCtrl(this, Spin_Minimum_Length, wxEmptyString, wxDefaultPosition, wxSize(50, -1));
	length->SetValue(minLength);
	length->SetRange(20, 1000);
	lengthSizer->Add(length, 0, wxALL, BORDER_SIZE);

	sizer->Add(lengthSizer);

	wxBoxSizer* strengthSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* strengthLabel = new wxStaticText(this, -1, wxT("Strength"), wxDefaultPosition, wxSize(50, -1));
	strengthSizer->Add(strengthLabel, 0, wxTOP, BORDER_SIZE);

	wxSpinCtrl* strength = new wxSpinCtrl(this, Spin_Minimum_Strength, wxEmptyString, wxDefaultPosition, wxSize(50, -1));
	strength->SetValue(minStrength);
	strength->SetRange(1, 20);
	strengthSizer->Add(strength, 0, wxALL, BORDER_SIZE);

	sizer->Add(strengthSizer);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CFSK441SettingsControl::~CFSK441SettingsControl()
{
}
