/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441SpectrumEvent.h"

CFSK441SpectrumEvent::CFSK441SpectrumEvent(CFSK441Spectrum* spectrum, wxEventType type, int id) :
wxEvent(id, type),
m_spectrum(spectrum)
{
}

CFSK441SpectrumEvent::CFSK441SpectrumEvent(const CFSK441SpectrumEvent& event) :
wxEvent(event),
m_spectrum(event.m_spectrum)
{
}

CFSK441SpectrumEvent::~CFSK441SpectrumEvent()
{
}

CFSK441Spectrum* CFSK441SpectrumEvent::getSpectrum() const
{
	return m_spectrum;
}

wxEvent* CFSK441SpectrumEvent::Clone() const
{
	return new CFSK441SpectrumEvent(*this);
}
