/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44Message.h"

#include <wx/listimpl.cpp>

#include <cmath>
using namespace std;

WX_DEFINE_LIST(CJT44MessageList);

CJT44Message::CJT44Message() :
CJT44MessageBase(),
m_id(wxEmptyString),
m_Dt(0.0),
m_DF(0),
m_include(true)
{
}

CJT44Message::~CJT44Message()
{
}

void CJT44Message::setId(const wxString& id)
{
	m_id = id;
}

void CJT44Message::setDt(double Dt)
{
	m_Dt = Dt;
}

void CJT44Message::setDF(int DF)
{
	m_DF = DF;
}

void CJT44Message::setInclude()
{
	m_include = true;
}

void CJT44Message::setExclude()
{
	m_include = false;
}

wxString CJT44Message::getId() const
{
	return m_id;
}

double CJT44Message::getDt() const
{
	return m_Dt;
}

int CJT44Message::getDF() const
{
	return m_DF;
}

bool CJT44Message::getInclude() const
{
	return m_include;
}

void CJT44Message::setData(int letter, int pos, double val)
{
	addData(letter, pos, val);
}

void CJT44Message::setSync(int pos, double val)
{
	addSync(pos, val);
}

void CJT44Message::setNoise(int pos, double val)
{
	addNoise(pos, val);
}
