package tests::OutputFormatsFixture;

use strict;

use Lire::Config::SpecParser;
use Lire::Utils qw/file_content deep_copy/;
use Lire::Config::Build qw/ac_info/;
use File::Basename qw/dirname/;

sub set_up_output_formats {
    my ( $self, $new_mgr) = @_;

    $new_mgr = ! $self->isa( 'Lire::Test::FunctionalTestCase' )
      unless defined $new_mgr;

    $self->set_up_plugin_mgr() if $new_mgr;

    my $testdir = dirname( __FILE__ );
    my $formatsdir =  "$testdir/../Lire/OutputFormats";
    opendir my $dh, $formatsdir
      or $self->error( "opendir '$formatsdir' failed: $!" );
    foreach my $basename ( readdir $dh ) {
        next unless $basename =~ /_init$/;
        eval file_content( "$formatsdir/$basename" );
        $self->error( "error loading '$formatsdir/$basename': $@" )
          if $@;
    }
    closedir $dh;

    my $parser = new Lire::Config::SpecParser();
    unless ( $self->isa( 'Lire::Test::FunctionalTestCase' ) ) {
        $parser->{'_spec'} = deep_copy( $self->{'cfg'}{'_lr_config_spec'}
                                        || $self->lire_default_config_spec() );
    }
    $parser->merge_specifications_dir( "$testdir/../Lire/OutputFormats" );
    $self->{'cfg'}{'_lr_config_spec'} = $parser->configspec();

    return;
}


1;
