package tests::ReportSectionTest;

use strict;

use Lire::ReportSection;
use Lire::ReportSpec;
use Lire::Report::Subreport;
use Lire::Config::ReportSectionSpec;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture /;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();
    $self->init_i18n();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_locale();
    $self->set_up_test_schema();

    return $self;
}

sub tear_down {
    my $self = shift->SUPER::tear_down();

    $self->tear_down_locale();

    return $self;
}

sub test_title_i18n {
    my $self = $_[0];

    my $sect = new Lire::ReportSection( 'test', 'JPEG Files' );
    $self->assert_str_equals( 'JPEG Files', $sect->title() );
    $self->set_locale( 'fr_CA.iso8859-1' );
    $self->assert_str_equals( 'Fichiers JPEG', $sect->title() );
}

sub test_add_report {
    my $self = $_[0];

    $self->{'cfg'}{'lr_reports_path'} = [ "$self->{'testdir'}/reports" ];
    my $section = new Lire::ReportSection( 'test', 'My title' );
    $self->assert_deep_equals( [], $section->{'_reports'} );

    my $spec = Lire::ReportSpec->load( 'test', 'top-dirs' );
    $self->assert_dies( qr/can't add a ReportSpec without a subreport_id/,
                        sub { $section->add_report( $spec ) } );
    $spec->subreport_id( 'top-dirs.0' );
    $section->add_report( $spec );
    $self->assert_deep_equals( $spec, $section->reports() );
}

sub test_new_from_config {
    my $self = $_[0];

    $self->{'cfg'}{'lr_reports_path'} = [ "$self->{'testdir'}/reports" ];
    $self->{'cfg'}{'lr_filters_path'} = [ "$self->{'testdir'}/filters" ];

    my $section_spec = new Lire::Config::ReportSectionSpec( 'name' => 'test' );
    my $section_cfg = $section_spec->instance();
    $section_cfg->get( 'superservice' )->set( 'test' );
    $section_cfg->get( 'title' )->set( 'My title' );
    my $filter =
      $section_spec->get( 'filters' )->get( 'test:select-file' )->instance();
    $filter->get( 'id' )->set( 'select-file' );
    $section_cfg->get( 'filters' )->append( $filter );

    my $report =
      $section_spec->get( 'specs' )->get( 'test:top-dirs' )->instance();
    $report->get( 'id' )->set( 'top-dirs' );
    $section_cfg->get( 'specs' )->append( $report );

    my $section = $section_cfg->as_value();
    $self->assert_isa( 'Lire::ReportSection', $section );
    $self->assert_str_equals( 'test', $section->superservice() );
    $self->assert_str_equals( 'My title', $section->title() );
    $self->assert_num_equals( 1, scalar $section->filters() );
    $self->assert_num_equals( 1, scalar $section->reports() );
}

1;
