/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This header file declares the functions for ansi, ascii, and csv,
 * and the various data structures, global variables, and whatnot.
 */

#include "config.h"

void lt_setup();
int lt_read_config();
void lt_set_config();
void lt_set_config_err();
void lt_run();
int lt_loop();
void lt_cleanup();

/* The various output module functions */
void lto_raw();
void lto_ansi(); void lt_colorset_ansi();
void lto_ascii();
void lt_parse_ascii();
void lto_csv(); void lt_colorset_csv(); void lt_parse_csv_header();
void lt_parse_html(); void lto_html(); void lt_colorset_html();
void lt_parse_multilog();
int lt_do_regexcheck();

/* we need to clean up how we've got these listed in here	*/
int parse_pmsg();
int lt_match_re(const char *string, regex_t re);

/* utility functions */
void lt_sh_usage();
void lt_getopts();
int lt_putenv(char *line);

/*  From the regex.c file (regular expression stuff's) */
int lt_check_exclude();
int lt_check_include();
int lt_match(const char *string, char *pattern);
void lt_loadstrings();
void lt_regex_vars_sanity();
void lt_regexinit();
short int lt_fmtcheck(char *tmp);

/* from parser.c */
char *lt_strep(char *input, size_t bufsize,  char *string, char *newstring);
int lt_do_parse();
void lt_set_event_color();

/* from tai64nfrac.c	*/
time_t t64nfrac(char *sline);
	
/* 
 * strncasecmp seems to have a few portability issues, so we use 
 * configure to test for it, and if it's not decl'd, we do it here
 */
/* Note: Why in the HELL do I have to define this, even though configure 
 * says I've already got it?
 */
#ifndef HAVE_STRNCASECMP
int strncasecmp(const char *s1, const char *s2, size_t size); 
#endif

/*
 * This is the structure each line of syslog file get's parsed into.  
 */

typedef struct {
	short int type;      	/* snort, iptables, syslog, and so-on			*/
      	char pcolor[256];	/* event color red, yellow, green, default 		*/
	char month[4];		
	char day[3];
	char time[9];
	char source[64];
	char lsource[64];
	char program[64];
	char lprogram[64];
	char message[LSIZE];	/* the current message in full (- timestamps) 		*/
	char lmessage[LSIZE];	/* the last message in full (- timestamps) 		*/
	char raw[(LSIZE * 2)];		/* the full event in RAW format				*/
	char lraw[(LSIZE * 2)];		/* the full event in RAW format				*/
	char pmsg[(LSIZE * 4)];	/* where we store the string we're going to print	*/
	MOD m;		/* pointer to where we store extra data for mod_* events*/
} st_event;
st_event event;

/* Structure for the event color variables */
typedef struct {
	/* these are kind of set around the \033[*m ANSI sequences	*/
	char beep[256];		/* \033! probably only used in ANSI output mode	*/
	
	char red[256];		/* \033r is what we use in pmsg for parsing	*/
	char brightred[256];	/* \033R for pmsg parsing			*/

	char green[256];	/* \033g	*/
	char brightgreen[256];	/* \033G 	*/
	
	char yellow[256];	/* \033y	*/
	char brightyellow[256];	/* \033Y	*/
	
	char dimwhite[256];	/* \033l	*/
	char white[256];	/* \033w	*/
	char brightwhite[256];	/* \033W	*/
	
	char blue[256];		/* \033b	*/
	char brightblue[256];	/* \033B	*/
	
	char magenta[256];	/* \033m	*/
	char brightmagenta[256];/* \033M	*/
	
	char cyan[256];		/* \033c	*/
	char brightcyan[256];	/* \033C	*/
	
	char unknown[256];	/* \033u	*/
	char end[256];		/* \033e	*/
} st_color;
st_color color;

typedef struct {
	char configfile[1024];	/* ascii name of our config file			*/
	short int input;	/* did we see any input?  (set to FALSE by default)	*/
	short int outfmt;	/* what output format are we using? (see config.h)	*/
	short int timefmt;	/* what format do we print our timestamps?		*/
	short int verbose;	/* should we yammer about what we're doing on stderr?	*/
	short int debug;	/* should we debug to stderr?				*/
	short int redbeep;      /* to beep, or not to beep, that is the question..	*/
	short int showprog;	/* do we display the 'program' field from syslog 	*/
	short int showsrc;	/* define if we want to show the src host or not	*/
	short int supdupes;	/* do we suppress duplicate junk?			*/
	/* syslog prints host lines like src@hostname/hostip (no hostip if not remote)	*/
	/* we may want to strip that *@ part, and only see name or IP in such cases	*/
	/* the following options were added to accomidate such options (see cfg file)	*/
	short int sys_ng_host;	/* do we strip the *@'s from syslog-ng's src field?	*/
	short int hostfmt;	/* what format do we print the host line (syslog-ng)	*/
	short int resolv;	/* disable host resolution, even if enabled in cfg file	*/
} CONFIG;

CONFIG cf;

extern int errno;	/* the error number thing from the errno functions	*/

/* yea thouhgh I walk through the shadow of the valley of malloc()... ;)	*/
/* here is where we have filenames, file contents, and regexcomp()'d stuff	*/
/* anything we do regex's with should go in here				*/
typedef struct {
	short int white_check;
	char *white_file;
	char *white_strs;
	regex_t white_reg;
	
	short int brightwhite_check;
	char *brightwhite_file;
	char *brightwhite_strs;
	regex_t brightwhite_reg;

	short int green_check;
	char *green_file;
	char *green_strs;
	regex_t green_reg;
	
	short int brightgreen_check;
	char *brightgreen_file;
	char *brightgreen_strs;
	regex_t brightgreen_reg;
	
	short int yellow_check;
	char *yellow_file;
	char *yellow_strs;
	regex_t yellow_reg;
	
	short int brightyellow_check;
	char *brightyellow_file;
	char *brightyellow_strs;
	regex_t brightyellow_reg;
	
	short int blue_check;
	char *blue_file;
	char *blue_strs;
	regex_t blue_reg;
	
	short int brightblue_check;
	char *brightblue_file;
	char *brightblue_strs;
	regex_t brightblue_reg;
	
	short int magenta_check;
	char *magenta_file;
	char *magenta_strs;
	regex_t magenta_reg;
	
	short int brightmagenta_check;
	char *brightmagenta_file;
	char *brightmagenta_strs;
	regex_t brightmagenta_reg;
	
	short int cyan_check;
	char *cyan_file;
	char *cyan_strs;
	regex_t cyan_reg;
	
	short int brightcyan_check;
	char *brightcyan_file;
	char *brightcyan_strs;
	regex_t brightcyan_reg;

	short int brightred_check;
	char *brightred_file;
	char *brightred_strs;
	regex_t brightred_reg;

	short int exclude_check;
	char *exclude_file;
	char *exclude_strs;
	regex_t exclude_reg;
	
	short int include_check;
	char *include_file;
	char *include_strs;
	regex_t include_reg;
} STRUCTURE_REGEXS;

STRUCTURE_REGEXS reg;
