#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>

#include "err.h"

#define BS 4096

int
main(int argc,char * argv[]) {

  char c,b[BS],*bs,*be,*bp;
  unsigned char s;
  int i,l,n,j;

  i=-1;
  while ((c=getopt(argc,argv,"s:"))!=EOF) 
    switch(c) {
    case 's':
      i=atoi(optarg);
      if (i>0xff || i<0)
	errret("Bad separator %d\n",i);
      else
	s=i;
      break;
    default:
      errret("Usage: %s -s <sep char (ascii code)> files ...\n",argv[0]);
      break;
    }
  if (i==-1)
    errret("Usage: %s -s <sep char (ascii code)> files ...\n",argv[0]);
  
  argc-=optind-1;
  argv+=optind-1;

  for (;--argc && *++argv;) {

    if ((l=open(*argv,O_RDONLY))<0)
      errret("Can't open %s\n",*argv);

    for (j=0;(n=read(l,b,sizeof(b)));) {

      if (!j && *b==s)
	errret("Please pick another separator, %s begins with this char\n",*argv);
      else
	j=1;
      
      for (bp=b,be=b+n;(bs=memchr(bp,s,be-bp));bp=bs) {

	bs++;
	if (write(1,bp,bs-bp)!=bs-bp)
	  errret("Can't write from %s\n",*argv);
	if (write(1,&s,sizeof(s))!=sizeof(s))
	  errret("Can't write from %s\n",*argv);

      }
      
      if (write(1,bp,be-bp)!=be-bp)
	errret("Can't write end block\n");

    }
	     
    if (write(1,&s,sizeof(s))!=sizeof(s))
      errret("CAn't write file seperator\n");
	     
    if (close(l))
      errret("Can't close %s\n",*argv);

  }

  return 0;

}


