#ifndef _GNET_LIB_H_
#define _GNET_LIB_H_

#include <stdio.h>
#include <pthread.h>

#include <sys/types.h>

#include "list.h"
#include "gnet.h"

#define MAX_BUFFER	32768

struct bnode {
    struct bnode 	*left, *right, **plink;
    struct channel	*chan;
    struct list_head	list;
    char		guid[16];
};

struct gnet {
    fd_set		g_rdset, g_wrset, g_exset;
    int			g_maxfd;
    int 		g_signal_fd[2];
    int			g_connected_peers;
    int			g_connecting_peers;
    int			g_nr_hosts;
    pthread_t		g_thread;
    struct gnet_config 	*g_cfg;
    struct list_head	g_channels;
    struct list_head	g_queries;
    struct list_head	g_hosts;
    pthread_mutex_t	g_channels_lock;
    char		g_buf[MAX_BUFFER];
    char		g_guid[16];
    unsigned long	g_search_seq;
    struct bnode	g_guids_root;
    unsigned		g_guids;
};

#ifdef TRACE
#undef TRACE
#endif
#ifdef WARN
#undef WARN
#endif
#ifdef ERROR
#undef ERROR
#endif

#ifdef DEBUGGING
#define TRACE(x...)     do{fprintf(stdout, "[%x](%s) ", getpid(), __func__); fprintf(stdout, x); fprintf(stdout, "\n");}while(0)
#define WARN(x...)      do{fprintf(stdout, "[%x](%s) ", getpid(), __func__); fprintf(stdout, x); fprintf(stdout, "\n");}while(0)
#define ERROR(x...)     do{fprintf(stderr, "[%x](%s) ", getpid(), __func__); fprintf(stdout, x); fprintf(stdout, "\n");}while(0)
#else
#define TRACE(x...)     do{}while(0)
#define WARN(x...)      do{}while(0)
#define ERROR(x...)     do{fprintf(stderr, x); fprintf(stderr, "\n");}while(0)
#endif


#endif
