/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2001-2005 Calle Laakkonen
 *
 * File        : animation.c
 * Description : This module handles all the animation and redraw timings
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include "SDL.h"
#include "defines.h"
#include "fs.h"
#include "console.h"
#include "level.h"
#include "player.h"
#include "weapon.h"
#include "animation.h"
#include "particle.h"
#include "special.h"
#include "critter.h"
#include "weather.h"
#include "ship.h"

/* Internally used globals */
static SDL_Rect anim_update_rects[2];
static int anim_rects;
static char anim_gamepaused;

/* Exported globals */
int endgame;

/* Arrange screen update rectangles */
void reinit_animation ()
{
    int r, numplayers, player = -1;
    char my_players[4] = { 0, 0, 0, 0 };
    anim_rects = 1;
    anim_gamepaused = 0;
/* Which players are to be updated */
    for (r = 0; r < 4; r++)
        if (players[r].state==ALIVE)
            my_players[r] = 1;

/* What should we update on frame redraw ? */
    anim_update_rects[0].x = 0;
    anim_update_rects[0].y = 0;
    anim_update_rects[0].w = 320;
    anim_update_rects[0].h = 240;
    anim_update_rects[1].w = 320;
    anim_update_rects[1].h = 240;
    numplayers = 0;
    for (r = 0; r < 4; r++)
        if (my_players[r])
            numplayers++;
    if (numplayers == 4) {
        anim_update_rects[0].w = SCREEN_W;
        anim_update_rects[0].h = SCREEN_H;
    } else if (numplayers == 3) {
        for (r = 0; r < 4; r++)
            if (!my_players[r]) {
                player = r;
                break;
            }
        anim_rects = 2;
        if (player < 0) {
            printf
                ("Error in reinit_animation() ! (variable player<0, number of players is 3)\n");
            exit (1);
        }
        switch (r) {
        case 0:
            anim_update_rects[0].x = 320;
            anim_update_rects[1].x = 0;
            anim_update_rects[1].y = 240;
            anim_update_rects[1].w = SCREEN_W;
            break;
        case 1:
            anim_update_rects[1].x = 0;
            anim_update_rects[1].y = 240;
            anim_update_rects[1].w = SCREEN_W;
            break;
        case 2:
            anim_update_rects[0].w = SCREEN_W;
            anim_update_rects[1].x = 320;
            anim_update_rects[1].y = 240;
            break;
        case 3:
            anim_update_rects[0].w = SCREEN_W;
            anim_update_rects[1].x = 0;
            anim_update_rects[1].y = 240;
            break;
        }
    } else if (numplayers == 2) {
        if (my_players[0] && my_players[1]) {
            anim_update_rects[0].w = SCREEN_W;
        } else if (my_players[0] && my_players[2]) {
            anim_update_rects[0].h = SCREEN_H;
        } else if (my_players[0] && my_players[3]) {
            anim_update_rects[1].x = 320;
            anim_update_rects[1].y = 240;
            anim_rects = 2;
        } else if (my_players[1] && my_players[2]) {
            anim_update_rects[0].x = 320;
            anim_update_rects[1].x = 0;
            anim_update_rects[1].y = 240;
            anim_rects = 2;
        } else if (my_players[1] && my_players[3]) {
            anim_update_rects[0].x = 320;
            anim_update_rects[0].h = SCREEN_H;
        } else if (my_players[2] && my_players[3]) {
            anim_update_rects[0].y = 240;
            anim_update_rects[0].w = SCREEN_W;
        }
    } else {
        for (r = 0; r < 4; r++)
            if (my_players[r]) {
                player = r;
                break;
            }
        if (player < 0) {
            anim_rects = 0;
            return;
        }
        switch (player) {
        case 1:
            anim_update_rects[0].x = 320;
            break;
        case 2:
            anim_update_rects[0].y = 240;
            break;
        case 3:
            anim_update_rects[0].x = 320;
            anim_update_rects[0].y = 240;
            break;
        }
    }
}

Uint8 pause_game ()
{
    int p;
    SDL_Rect rect;
    if (anim_gamepaused) {
        anim_gamepaused = 0;
    } else {
        if ((game_settings.endmode == 0 && plr_teams_left <= 1)
            || (game_settings.endmode == 1 && plr_teams_left < 1))
            return 1;           /* Dont bother pausing the game, its already over */
        anim_gamepaused = 1;
        /* Draw pause messages */
        for (p = 0; p < 4; p++)
            if (players[p].state==ALIVE) {
                rect.x = (p == 1 || p == 3) * 320;
                rect.y = (p > 1) * 240;
                rect.w = 320;
                rect.h = 240;
#if HAVE_LIBSDL_GFX
                boxColor (screen, rect.x, rect.y, rect.x + rect.w,
                          rect.y + rect.h, col_pause_backg);
#else
                SDL_FillRect (screen, &rect, col_pause_backg);
#endif
                putstring_direct (screen, Bigfont, rect.x + 120, rect.y + 120,
                                  "Paused", font_color_red);
            }
        SDL_UpdateRects (screen, anim_rects, anim_update_rects);
    }
    return !anim_gamepaused;
}

/**** Redraw frame ****/

void animate_frame (void)
{
    if (endgame > 0)
        endgame--;
    else if (endgame == 0)
        game_loop = 0;
    animate_players ();
    animate_ships ();
    animate_pilots ();
    animate_level ();
    animate_specials ();
    animate_critters ();
    animate_weather ();
    draw_ships ();
    draw_pilots ();
    animate_weapons ();
    animate_particles ();
    draw_bat_attack ();
    draw_player_hud ();
    SDL_UpdateRects (screen, anim_rects, anim_update_rects);

    /* End the level if there are less than two teams left */
    if (endgame == -1) {
        if (plr_teams_left < 2) {
            if (game_settings.endmode == 0 || lev_level.base_area < 10)
                endgame = 30;
        }
    }
}

