/*
 *  functions-edit.c
 *		Functions for the commands that edit a text being written.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#include <config.h>

#include <stdio.h>
/* #include <time.h> included from kom-types.h */
#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef __vax__
#define __SIZE_T included from string.h
#endif
#include <kom-types.h>	/* Before zmalloc.h */
#include <zmalloc.h>
#include <s-string.h>
#include <s-collat.h>

#include <libintl.h>

#include <kom-errno.h>
#include <services.h>

#include "conf.h"

/* Must be included before "read-line.h" on a vax because it includes <sgtty.h>
 * and that does not work after inclusion of <sys/ioctl.h> because of
 * stupid include-file construction.
 */
#include "xoutput.h"

#include "read-line.h"
#include "commands.h"
#include "parser.h"
#include "edit.h"
#include "error.h"
#include "cache.h"
#include "quit.h"

#include "internal.h"
#include "cmds.h"
#include "offline.h"


/* This is to emphasize that a function is exported. */
#define Export


/*  ==================================================================  */
/*			    Exported functions				*/


Export  Success
cmd_mark_permanently (String	  argument)

{
    Success			  retval;
    Text_no			  text_to_mark;
    String_size			  error_check;

#define CLEAN_UP()	do	{	s_clear (&argument);	}while (0)

    TOPLOOP_SETJMP();

    OFFLINE();

    if (s_empty (argument))
    {
	text_to_mark = reading_state.last_viewed;
    }
    else
    {
	text_to_mark = s_strtol (argument, &error_check,
				 DEFAULT_NUMBER_BASE);
	if (error_check < s_strlen (argument))
	{
	    /*  No, it wasn't a number.  */
	    xprintf (gettext("Oknt argument:  "));
	    s_puts (argument);
	    newline();
	    RETURN (FAILURE);
	}
    }
    xprintf ("%d", text_to_mark);
    newline();

    retval = kom_mark_text (text_to_mark, 255);		/* 255 is a BUG! */
    if (retval != OK)
    {
	xprintf (gettext("Kunde inte markera inlgget.\n"));
	RETURN (FAILURE);
    }

    RETURN (OK);

#undef CLEAN_UP
}   /* END: cmd_mark_permanently() */



Export	Success
cmd_delete_text (String		  argument)

{
    Text_no			  text_to_delete;
    String_size			  error_check;

#define CLEAN_UP()	do	{ 	s_clear (&argument);	} while (0)

    TOPLOOP_SETJMP();

    OFFLINE();

    if (s_empty (argument))
    {	
	xprintf(gettext("Du mste ge numret p texten som skall raderas.\n"));
	RETURN (FAILURE);
    }
    else
    {
	text_to_delete = s_strtol (argument, &error_check,
				   DEFAULT_NUMBER_BASE);
	if (error_check < s_strlen (argument))
	{
	    /*  No, it wasn't a number.  */
	    xprintf (gettext("Oknt argument:  "));
	    s_puts (argument);
	    newline();
	    RETURN (FAILURE);
	}
	xprintf ("%d", text_to_delete);
    }

    newline();
    xprintf (gettext("r du sker p att du vill radera text nummer %d? "), text_to_delete);

    if (yes_or_no_p())
    {
	if (kom_delete_text( text_to_delete ) != FAILURE)
	{
	    RETURN (OK);
	}
	else
	{
	    xprintf(gettext("Det gick inte att radera text nummer %d.\n"), text_to_delete);
	    RETURN (FAILURE);
	}
    }
    else
    {
	xprintf (gettext("Nehej.\n"));
    }
    RETURN (OK);
#undef CLEAN_UP
}


/* Add recipient to a text */
Export Success
cmd_add_recipient (String argument)
{
#define FUNCTION "add_recipient()"
    Text_no wanted_text;
    Conf_no conf_to_add_to;
    Conf_z_info add_to_conf = EMPTY_CONF_Z_INFO;

#define CLEAN_UP()   				\
    { 						\
	s_clear(&argument);			\
    }

    TOPLOOP_SETJMP();

    OFFLINE();

    {
	wanted_text = reading_state.last_viewed;
	if(wanted_text==0) 
	{
	    xprintf(gettext("Du mste lsa ett inlgg frst"));
	    RETURN (FAILURE);
	}
	add_to_conf = ask_for_conf(&argument,
				   gettext("Vilket mte vill du addera som mottagare"));
      
	conf_to_add_to = add_to_conf.conf_no;

	if(conf_to_add_to == 0)
	    RETURN (FAILURE);

	if(kom_add_recipient(wanted_text,conf_to_add_to,0) != FAILURE)
	{
	    xprintf(gettext("Har adderat text %d till "),
		    wanted_text);
	    print_conf_name(conf_to_add_to);
	}
	else
	    switch (kom_errno)
	    {
	    case KOM_PERM:
	    case KOM_ACCESS:
	        /*xgettext:c-format*/
		xprintf(gettext("Du har inte rttigheter "
				"att addera inlgg %ld till "),
			wanted_text);
		print_conf_name(conf_to_add_to);
		break;
	    case KOM_ALREADY_RECIPIENT:
		xprintf(gettext("Inlgget r redan med i "));
		print_conf_name(conf_to_add_to);
		break;
	    case KOM_RECIPIENT_LIMIT:
		xprintf(gettext("Inlgget har fr mnga mottagare.\n"));
		break;
	    default:
		fatal5(CLIENT_UNEXPECTED_SERVER_ERROR,
		       "add_recipient(%ld, %d, 0) error %d %s",
		       wanted_text, conf_to_add_to, 
		       kom_errno, kom_errno_string());
		break;
	    }
    }

    RETURN (OK);
#undef CLEAN_UP
#undef FUNCTION
}


/* Copy text to another conference */
Export Success
cmd_copy_recipient (String argument)
{
#define FUNCTION "copy_recipient()"
    Text_no wanted_text;
    Conf_no conf_to_add_to;
    Conf_z_info add_to_conf = EMPTY_CONF_Z_INFO;

#define CLEAN_UP()					\
    {							\
	s_clear(&argument);				\
    }

    TOPLOOP_SETJMP();

    OFFLINE();

    {
	wanted_text = reading_state.last_viewed;
	if(wanted_text==0) 
	{
	    xprintf(gettext("Du mste lsa ett inlgg frst"));
	    RETURN (FAILURE);
	}
	add_to_conf = ask_for_conf(&argument,
				   gettext("Vilket mte vill du addera som mottagare"));
      
	conf_to_add_to = add_to_conf.conf_no;

	if(conf_to_add_to == 0)
	    return FAILURE;

	if(kom_add_recipient(wanted_text,conf_to_add_to,1) != FAILURE)
	{
	    xprintf(gettext("Har adderat text %d till "), wanted_text);
	    print_conf_name(conf_to_add_to);
	}
	else
	    switch (kom_errno)
	    {
	    case  KOM_PERM:
		xprintf(gettext("Du har inte rttigheter "
				"att kopiera text %d till "),
			wanted_text);
		print_conf_name(conf_to_add_to);
		break;
	    case  KOM_ALREADY_RECIPIENT:
		xprintf(gettext("Texten r redan med i "));
		print_conf_name(conf_to_add_to);
		break;
	    case  KOM_RECIPIENT_LIMIT:
		xprintf(gettext("Texten har fr mnga medlemar\n"));
		break;
	    default:
		fatal5(CLIENT_UNEXPECTED_SERVER_ERROR,
		       "copy_recipient(%ld, %d, 1) error %d %s",
		       wanted_text, conf_to_add_to, 
		       kom_errno, kom_errno_string());
		break;
	    }
    }

    RETURN (OK);
#undef CLEAN_UP
#undef FUNCTION
}


/* Remove recipient from a text */
Export Success
cmd_sub_recipient (String argument)
{
#define FUNCTION "sub_recipient()"
    Text_no wanted_text;
    Conf_no conf_to_sub_from;
    Conf_z_info sub_from_conf = EMPTY_CONF_Z_INFO;

#define CLEAN_UP()				\
    {						\
	s_clear(&argument); 			\
    }

    TOPLOOP_SETJMP();

    OFFLINE();

    {
	wanted_text = reading_state.last_viewed;
	if(wanted_text==0)
	{
	    xprintf(gettext("Du mste lsa ett inlgg frst"));
	    RETURN (FAILURE);
	}
	sub_from_conf = ask_for_conf(&argument,
				     gettext("Vilket mte vill du subtrahera "
					     "denna text frn"));
      
	conf_to_sub_from = sub_from_conf.conf_no;

	if(conf_to_sub_from == 0)
	    return FAILURE;

	if(kom_sub_recipient(wanted_text,conf_to_sub_from) != FAILURE)
	{
	    xprintf(gettext("Har tagit bort text %d frn "), wanted_text);
	    print_conf_name(conf_to_sub_from);
	}
	else
	    switch (kom_errno)
	    {
	    case  KOM_PERM:
		xprintf(gettext("Du har inte rttigheter "
				"att ta bort text %d frn "), 
			wanted_text);
		print_conf_name(conf_to_sub_from);
		newline();
		break;
	    case  KOM_NOT_RECIPIENT:
	        xprintf(gettext("Texten har inte ngon sdan mottagare."));
		newline();
		break;
	    case  KOM_NO_SUCH_TEXT:
	        xprintf(gettext("Det finns inget sdant inlgg"));
		newline();
		break;
	    default:
		fatal5(CLIENT_UNEXPECTED_SERVER_ERROR,
		       "sub_recipient(%ld, %d) error %d %s",
		       wanted_text, conf_to_sub_from,
		       kom_errno, kom_errno_string());
		break;
	    }
    }

    RETURN (OK);
#undef CLEAN_UP
#undef FUNCTION
}

/* Move text */
Export Success
cmd_change_recipient (String argument)
{
#define FUNCTION "change_recipient()"
    Text_no wanted_text;
    Conf_no conf_to_add_to;
    Conf_z_info add_to_conf = EMPTY_CONF_Z_INFO;

#define CLEAN_UP()    				\
    {						\
	s_clear(&argument); 			\
    }

    TOPLOOP_SETJMP();

    OFFLINE();

    {
	wanted_text = reading_state.last_viewed;
	if(wanted_text==0) 
	{
	    xprintf(gettext("Du mste lsa ett inlgg frst"));
	    RETURN (FAILURE);
	}
	add_to_conf = ask_for_conf(&argument,
				   gettext("Vilket mte vill du addera som mottagare"));
      
	conf_to_add_to = add_to_conf.conf_no;

	if(conf_to_add_to == 0)
	    return FAILURE;

	if(kom_add_recipient(wanted_text,conf_to_add_to,0) != FAILURE)
	{
	    if(kom_sub_recipient(wanted_text,ccn) != FAILURE)
	    {
		xprintf(gettext("Har flyttat text %d till "), wanted_text);
		print_conf_name(conf_to_add_to);
	    }
	    else
		switch (kom_errno)
		{
		case  KOM_PERM:
		    xprintf(gettext("Du har inte rttigheter "
				    "att ta bort text %d frn "), 
			    wanted_text);
		    print_conf_name(ccn);
		    break;
		case  KOM_NOT_RECIPIENT:
		    xprintf(gettext("Du mste vara i ett av mtena "
				    "texten tillhr\n"));
		    break;
		default:
		    fatal5(CLIENT_UNEXPECTED_SERVER_ERROR,
			   "change_recipient(sub, %ld, %d) error %d %s",
			   wanted_text, ccn, kom_errno, kom_errno_string());
		    break;

		}
	}
	else
	    switch (kom_errno)
	    {
	    case  KOM_PERM:
		xprintf(gettext("Du har inte rttigheter "
				"att addera text %d till "),
			wanted_text);
		print_conf_name(conf_to_add_to);
		break;
	    case  KOM_ALREADY_RECIPIENT:
		xprintf(gettext("Texten r redan med i "));
		print_conf_name(conf_to_add_to);
		break;
	    case  KOM_RECIPIENT_LIMIT:
		xprintf(gettext("Texten har fr mnga medlemar\n"));
		break;
	    default:
		fatal5(CLIENT_UNEXPECTED_SERVER_ERROR,
		       "change_recipient(add, %ld, %d, 0) error %d %s",
		       wanted_text, conf_to_add_to,
		       kom_errno, kom_errno_string());
		break;
	    }
    }

    RETURN (OK);
#undef CLEAN_UP
#undef FUNCTION
}
