/*
 *  defaults.h  --  Default settings for the client, e g which server
 *		    to connect to as a default.
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */

#ifndef __DEFAULT_H
#define __DEFAULT_H

/* Hostname of default LysKOM server */
#define DEFAULT_SERVER		"Kom.Lysator.LiU.Se"
#define DEFAULT_PORTNO		4894

/* Priority when joining a new conference */
#define DEFAULT_CONF_PRIORITY	100

/* Length of a line before breaking. */
#define LINE_LENGTH		64

/* This is the time between writing a > while waiting.
 * Also the time between polling the server for texts.
 */
#define DEFAULT_TIME_INTERVAL_WHILE_WAITING 13

/* Don't ask the server for more than this number of numbers
 * at a time.  We don't want the server to send us 20000
 * numbers when we join a large conference...		*/
#define MAX_NUMBERS_TO_GET	200

#define LONGEST_SUBJECT_NOT_TRUNCATED 70
#endif /* __DEFAULT_H */
