/*-
 * C-SaCzech
 * Copyright (c) 1996-2002 Jaromir Dolecek <dolecek@ics.muni.cz>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Jaromir Dolecek
 *	for the CSacek project.
 * 4. The name of Jaromir Dolecek may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JAROMIR DOLECEK ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL JAROMIR DOLECEK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: cstools.h,v 1.37 2002/02/03 11:13:41 dolecek Exp $ */

#ifndef _CSA_CSTOOLS_H_
#define _CSA_CSTOOLS_H_

/* used to hold Unicode char */
typedef unsigned int cstools_unicode_t;

#define CSTOOLS_NUMFONTS	13
#define CSTOOLS_Unicode_base	128
typedef enum {
	CSTOOLS_ASCII	  = 0,
	CSTOOLS_ISOLatin1 = 1,
	CSTOOLS_ISOLatin2 = 2,
	CSTOOLS_CP1250	  = 3,
	CSTOOLS_Kam	  = 4,
	CSTOOLS_PCLatin2  = 5,
	CSTOOLS_KOI8_CS	  = 6,
	CSTOOLS_Mac	  = 7,
	CSTOOLS_CP850	  = 8,
	CSTOOLS_KOI8_R	  = 9,
	CSTOOLS_ISO8859_5 = 10,
	CSTOOLS_CP866	  = 11,
	CSTOOLS_CP1251	  = 12, /* CSTOOLS_MAX8BIT */

	CSTOOLS_Unicode	  = (CSTOOLS_Unicode_base + 0),
	CSTOOLS_UTF8	  = (CSTOOLS_Unicode_base + 1),

	CSTOOLS_MINCODE	  = 0,
	CSTOOLS_MAX8BIT	  = 12,
	CSTOOLS_UNKNOWN	  = -1,
	CSTOOLS_BINARY	  = -2
} cstools_t;

typedef enum {
	CSTOOLS_BOTHUNI, CSTOOLS_FROMUNI, CSTOOLS_TOUNI, CSTOOLS_NOUNI
} cstools_typeconv_t;

/* holds infomations used for recoding; initialized by cstools_setup() */
typedef struct {
        cstools_t source;		/* source encoding */
        cstools_t target;		/* target encoding */
	cstools_typeconv_t typeconv;	/* type of conversion */
        cstools_unicode_t map[256];	/* recoding map */
} cstools_cstocs_t;

#ifdef CSACEK
#include "csacek.h"
#else  /* !CSACEK */
#include <stdio.h>	/* for NULL, yup ;) */
#include <string.h>
#endif /* CSACEK */

#ifndef __P
#ifdef __STDC__
#  define	__P(x)	x
#else
#  define	__P(x)	()
#endif
#endif /* notdef __P */

#ifndef CSACEK
#define CSA_UPPER(c)	((c) >= 'a' && (c) <= 'z' ? (c) & 0xdf : (c))
#define CSA_ISHEXA(x) ( ((x) >= '0' && (x) <= '9') || ( (CSA_UPPER(x) >= 'A') && (CSA_UPPER(x) <= 'F') ) )
#define CSA_HEX2DEC(x) ((x) >= 'A' ? (((x) & 0xdf) - 'A')+10 : ((x) - '0'))
#endif

#define CSTOOLS_ISUNICODE(x) ((x) == CSTOOLS_Unicode || (x) == CSTOOLS_UTF8)
#define CSTOOLS_ISCYRILLIC(x) ((x) == CSTOOLS_KOI8_R || (x) == CSTOOLS_CP866 \
	|| (x) == CSTOOLS_CP1251)

#define CSTOOLS_NEED_SETUP(mp, s, t) (mp.source != s || mp.target != t)

/* constants used as second parameter to cstools_name() */
#define CSTOOLS_TRUENAME	0
#define CSTOOLS_CODENAME	1
#define CSTOOLS_ABBRNAME	2
#define CSTOOLS_MIMENAME	3
#define CSTOOLS_LAMPANAME	4

/* I'd rather use this - toupper() could not be available */
#define CSTOOLS_UPPER(x) (((x) >= 97 && (x) <= 122) ? (x)-32 : (x))

/* functions */

#ifdef __cplusplus
extern "C" {
#endif

/* cstools.c */
cstools_t cstools_whichcode __P((const char *, size_t));
int cstools_recode __P((cstools_cstocs_t *, const char *, char *, size_t));
int cstools_init __P((cstools_cstocs_t *mp, cstools_t from, cstools_t to));
cstools_t cstools_guess_charset __P((const char *, size_t));

const char *cstools_name __P((cstools_t code, int which));

cstools_t cstools_index2code __P((int));
int cstools_code2index __P((cstools_t));

#ifdef __cplusplus
}
#endif

#endif /* _CSA_CSTOOLS_H_ */
