/***************************************************************************
 $RCSfile: ctkvkcard.cpp,v $
                             -------------------
    cvs         : $Id: ctkvkcard.cpp,v 1.11 2003/04/24 01:43:29 aquamaniac Exp $
    begin       : Tue Aug 28 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes:

 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif

#include "cterror.h"
#include "ctpointer.h"
#include "ctcommand.h"
#include "libchipcard.h"
#include "cttlv.h"
#include "ctcard.h"
#include "ctmemorycard.h"
#include "ctkvkcard.h"
#include <engine/chameleon/error.h>
#include <engine/chameleon/debug.h>



CTKVKCard::CTKVKCard(const CTCard &c):CTMemoryCard(c){
}


CTKVKCard::~CTKVKCard(){
}


// applied a patch submitted by Micha Lenk for checksum calculation
bool CTKVKCard::_fromString(string ds, insuranceData &data){
  CTPointer<CTTLV> fulltag;
  CTPointer<CTTLV> ptag;

  string ftvalue;
  string currval;
  string d;
  string s;
  unsigned int pos;
  unsigned char checksum;
  unsigned int i;
  unsigned int apos;
  unsigned int checksumpos;

  pos=0;
  fulltag=new CTTLV(ds,pos);
  if (!fulltag.ref().isValid()) {
    DBG_INFO("LIBCHIPCARD: No tag on the card.");
    return false;
  }

  // check for valid KVK tag
  if (fulltag.ref().getClass()!=0x40 ||
      fulltag.ref().getTag()!=0 ||
      !fulltag.ref().isConstructed()) {
    DBG_INFO("LIBCHIPCARD: Bad tag on KVK card.");
    return false;
  }

  // let's dance
  pos=0;
  ftvalue=fulltag.ref().getValue();
  data.isValid=false;
  checksum=0;
  while(pos<ftvalue.length()) {
    ptag=new CTTLV(ftvalue,pos);
    if (!ptag.ref().isValid()) {
      DBG_INFO("LIBCHIPCARD: Invalid tag.");
      return false;
    }
    // change German umlauts
    currval=ptag.ref().getValue();
    for (i=0; i<currval.length(); i++)
      switch(currval.at(i)) {
      case k_KVK_AE:
	currval[i]='';
	break;
      case k_KVK_OE:
	currval[i]='';
	break;
      case k_KVK_UE:
	currval[i]='';
	break;
      case k_KVK_ae:
	currval[i]='';
	break;
      case k_KVK_oe:
	currval[i]='';
	break;
      case k_KVK_ue:
	currval[i]='';
	break;
      case k_KVK_ss:
	currval[i]='';
	break;
      default:
	break;
      } // switch

    switch(ptag.ref().getTag()) {
    case 0x00:
      data.insuranceCompanyName=currval;
      break;
    case 0x01:
      data.insuranceCompanyCode=currval;
      break;
    case 0x02:
      data.insuranceNumber=currval;
      break;
    case 0x03:
      data.insuranceState=currval;
      break;
    case 0x04:
      data.title=currval;
      break;
    case 0x05:
      data.forename=currval;
      break;
    case 0x06:
      data.nameSuffix=currval;
      break;
    case 0x07:
      data.name=currval;
      break;
    case 0x08:
      data.dateOfBirth=currval;
      break;
    case 0x09:
      data.addrStreet=currval;
      break;
    case 0x0a:
      data.addrState=currval;
      break;
    case 0x0b:
      data.addrPostalCode=currval;
      break;
    case 0x0c:
      data.addrCity=currval;
      break;
    case 0x0d:
      data.bestBefore=currval;
      break;
    case 0x0e:
      checksum=0;
      apos=pos+fulltag.ref().getSize()-fulltag.ref().getLength();
      for (checksumpos=0;
	   checksumpos<apos;
	   checksumpos++)
	checksum=checksum^((unsigned char)ds.at(checksumpos));
      // if checksum is 0 overall then data is valid
      data.isValid=!checksum;
      break;
    case 0x0f:
      data.cardNumber=currval;
      break;
    case 0x10:
      data.eastOrWest=currval;
      break;
    default:
      break;
    }
  }
  return true;
}


CTError CTKVKCard::readCardData(insuranceData &data){
    string s;
    string t;
    CTError err;
    int l;
    unsigned int i;
    unsigned int pos;

    if (isProcessorCard())
        return CTError("CTKVKCard::readCardData()",
		       k_CTERROR_INVALID,
                       1,
                       0,
                       "not a KVK card (Processor card)");

    // select whole data area
    err=selectMF(s);
    /* some drivers do not allow SELECT on memory cards, so if there is
     * an error which says exactly this (0x6d00), then ignore this
     */
    if (!err.isOk(0x6d))
      return err;

    // now the data area is selected
    // first read the size of the KVK tag
    err=readBinary(s,0x1e,5);
    if (!err.isOk())
      return err;
    if (s.length()<5)
      return CTError("CTKVKCard::readCardData()",
		     k_CTERROR_INVALID,
		     2,
		     0,
		     "answer too small");

    pos=0;
    i=(unsigned char)s.at(pos);
    // BER-TLV uses up to two bytes for the tag code
    // get tag id
    if ((i &0x1f)==0x1f)
      // two byte tag
      pos++;
    pos++;
    i=(unsigned char)s.at(pos);
    // BER-TLV
    if (i & 0x80) {
      // multiple bytes
      if (i==0x81) {
	// two bytes
	pos++;
	l=(unsigned char)s.at(pos);
      }
      else if (i==0x82) {
	pos++;
	l=((unsigned char)s.at(pos))<<8;
	pos++;
	l+=(unsigned char)s.at(pos);
      }
      else {
	return CTError("CTKVKCard::readCardData()",
		       k_CTERROR_INVALID,
		       3,
		       0,
		       "bad size tag");
      }
    }
    else
      l=i;
    pos++;
    l+=pos;

    // now read the real number of bytes
    err=readBinary(s,0x1e,l);
    if (!err.isOk())
      return err;
    if (s.length()<(unsigned int)l)
      return CTError("CTKVKCard::readCardData()",
		     k_CTERROR_INVALID,
		     4,
		     0,
		     "answer too small (2)");

    if (!_fromString(s,data))
      return CTError("CTKVKCard::readCardData()",
		     k_CTERROR_INVALID,
		     5,
		     0,
		     "not a KVK card (bad data)");

    return err;
}


CTError CTKVKCard::reopenCard(){
    CTError err;
    insuranceData data;

    if (isProcessorCard())
        return CTError("CTCard::reopenCard()",
                       k_CTERROR_INVALID,
                       0,
                       0,
                       "not a KVK card");
    err=readCardData(data);
    if (!err.isOk())
        return err;
    if (!data.isValid)
        return CTError("CTKVKCard::reopenCard()",
                       k_CTERROR_INVALID,
                       0,
                       0,
                       "not a KVK card");
    return CTError();
}


string CTKVKCard::cardType(){
  return "CTKVKCard";
}


string CTKVKCard::cardTypes(){
    return CTMemoryCard::cardTypes()+",CTKVKCard";
}





