/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__STRINGUTF8_HPP)
#include <StringUtf8.hpp>
#endif

//
// Utf8 String Implementation
//

namespace corelinux
{
   //
   // Default constructor
   //

   StringUtf8::StringUtf8( void )
      :
      AbstractString(),
      std::string()
   {

   }

   //
   // CharPtr copy constructor
   //

   StringUtf8::StringUtf8( CharCptr aPtr )
      :
      AbstractString(),
      std::string((const Char *)aPtr)
   {

   }

   StringUtf8::StringUtf8( const std::string & aRef )
      :
      AbstractString(),
      std::string(aRef)
   {
      ;  // do nothing
   }

   //
   // Copy constructor
   //

   StringUtf8::StringUtf8( StringUtf8Cref aRef )
      :
      AbstractString(),
      std::string( aRef )
   {
      ;  // do nothing
   }

   //
   // Cast copy constructor. This constructor also determines
   // if the incoming string is suitable for conversion
   //

   StringUtf8::StringUtf8( AbstractStringCref aRef )
      throw ( Exception )
      :
      AbstractString(),
      std::string()
   {
      REQUIRE( aRef.supportsStandardInterface() == true );
      REQUIRE( aRef.isUtf8() == true );

      std::string::operator=(dynamic_cast<const std::string &>(aRef));
   }

   //
   // Destructor
   //

   StringUtf8::~StringUtf8( void )
   {
      ;  // do nothing
   }

   //
   // Return the count of bytes to represent one (1)
   // character
   //

   Byte     StringUtf8::getElementByteCount( void ) const 
   {
      return sizeof( Char );
   }

   //
   // We support casts to std::string
   //

   bool     StringUtf8::supportsStandardInterface( void ) const 
   {
      return true;
   }

   //
   // We are a Utf8 string as defined by std::string
   //

   bool     StringUtf8::isUtf8( void ) const 
   {
      return true;
   }

   //
   // We are not UCS2 capable
   //

   bool     StringUtf8::isUcs2( void ) const 
   {
      return false;
   }

   //
   // We are not UCS4 capable
   //

   bool     StringUtf8::isUcs4( void ) const 
   {
      return false;
   }

   //
   // Common clone method. This basically calls the
   // hard cloneUtf8 to carry out the work
   //

   AbstractStringPtr StringUtf8::clone( void ) const throw ( Exception )
   {
      return this->cloneUtf8();
   }

   //
   // Clone myself into a Utf8 String (default)
   //

   AbstractStringPtr StringUtf8::cloneUtf8( void ) const throw ( Exception )
   {
      return new StringUtf8(*this);
   }

   //
   // Clone myself to a Ucs2 implementation (won't happen!)
   //

   AbstractStringPtr StringUtf8::cloneUcs2( void ) const throw ( Exception )
   {
      NEVER_GET_HERE;
      return NULLPTR;
   }

   //
   // Clone myself to a Ucs4 implementation (maybe?!?)
   //

   AbstractStringPtr StringUtf8::cloneUcs4( void ) const throw ( Exception )
   {
      NEVER_GET_HERE;
      return NULLPTR;
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 1999/12/04 23:17:22 $
   $Locker:  $
*/

