/* 
 * $Id: ctktype.c,v 1.23 2000/07/07 00:27:32 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>

#include "ctk.h"

CtkType typeLink[CtkTypeEND];

gboolean ctk_type_check_type(CtkObject* object, CtkType type)
{
      CtkType lookup;
      
      /* The null ptr is all types */
      if (!object)
      	return TRUE;
      
      /* If the object isn't a known type - it's nothing! */
      if (object->type > CtkTypeEND)
      	return FALSE;

      for (lookup = object->type; lookup != CtkTypeEND; lookup = typeLink[lookup])
      {
	    if (lookup == type)
		  return TRUE;
		ctk_assert(lookup <= CtkTypeEND, "Ctk type table corrupt");
	  }

      return FALSE;
}

/* Build the CTK Widget Hierarchy.
 * Many GNode vars where used to make it more
 * readable */

void ctk_type_init()
{
      /* Create the table */

      typeLink[CtkTypeObject]         = CtkTypeEND;
      typeLink[CtkTypeWidget]         = CtkTypeObject;
      typeLink[CtkTypeMisc]           = CtkTypeWidget;
      typeLink[CtkTypeLabel]          = CtkTypeMisc;
      typeLink[CtkTypeContainer]      = CtkTypeWidget;
      typeLink[CtkTypeBin]            = CtkTypeContainer;
      typeLink[CtkTypeFrame]          = CtkTypeBin;
      typeLink[CtkTypeButton]         = CtkTypeBin;
      typeLink[CtkTypeToggleButton]   = CtkTypeButton;
      typeLink[CtkTypeCheckButton]    = CtkTypeToggleButton;
      typeLink[CtkTypeRadioButton]    = CtkTypeCheckButton;
      typeLink[CtkTypeOptionMenu]     = CtkTypeButton;
      typeLink[CtkTypeWindow]         = CtkTypeBin;
      typeLink[CtkTypeScrolledWindow] = CtkTypeBin;
      typeLink[CtkTypeViewport]       = CtkTypeBin;
      typeLink[CtkTypeItem]           = CtkTypeBin;
      typeLink[CtkTypeMenuItem]       = CtkTypeItem;
      typeLink[CtkTypeListItem]       = CtkTypeItem;
      typeLink[CtkTypeTableChild]     = CtkTypeBin;
      typeLink[CtkTypeTable]          = CtkTypeContainer;
      typeLink[CtkTypeBox]            = CtkTypeTable;
      typeLink[CtkTypeHBox]           = CtkTypeBox;
      typeLink[CtkTypeCombo]          = CtkTypeHBox;
      typeLink[CtkTypeVBox]           = CtkTypeBox;
      typeLink[CtkTypeCList]          = CtkTypeTable;
      typeLink[CtkTypeList]           = CtkTypeCList;
      typeLink[CtkTypeNotebook]       = CtkTypeContainer;
      typeLink[CtkTypeMenuShell]      = CtkTypeCList;
      typeLink[CtkTypeMenu]           = CtkTypeMenuShell;
      typeLink[CtkTypeEditable]       = CtkTypeWidget;
      typeLink[CtkTypeEntry]          = CtkTypeEditable;
      typeLink[CtkTypeSpinButton]     = CtkTypeEntry;
      typeLink[CtkTypeRange]          = CtkTypeWidget;
      typeLink[CtkTypeScale]          = CtkTypeRange;
      typeLink[CtkTypeHScale]         = CtkTypeScale;
      typeLink[CtkTypeVScale]         = CtkTypeScale;
      typeLink[CtkTypeSeparator]      = CtkTypeWidget;
      typeLink[CtkTypeHSeparator]     = CtkTypeSeparator;
      typeLink[CtkTypeVSeparator]     = CtkTypeSeparator;
      typeLink[CtkTypeProgress]       = CtkTypeWidget;
      typeLink[CtkTypeProgressBar]    = CtkTypeProgress;
      typeLink[CtkTypeData]           = CtkTypeObject;
      typeLink[CtkTypeAdjustment]     = CtkTypeData;
}
