#include <inti/main.h>
#include <inti/core.h>
#include <inti/gtk/itemfactory.h>
#include <inti/gtk/menu.h>

using namespace Inti;

class ItemFactoryWindow : public Gtk::Window
{
	Pointer<Gtk::ItemFactory> item_factory;

	ItemFactoryWindow(const ItemFactoryWindow&);
	ItemFactoryWindow& operator=(const ItemFactoryWindow&);

protected:
	bool on_button_press(GdkEventButton *event, Gtk::Menu *menu);

public:
	ItemFactoryWindow();
	virtual ~ItemFactoryWindow();

	void menu_item_selected(const char *parent, const char *item);

	void on_file_new();
	void on_file_open();
	void on_file_save();
	void on_file_save_as();
	void on_file_quit();
	void on_options_test();
	void on_help_about();

	DECLARE_ITEM_FACTORY_MAP(ItemFactoryWindow)
};
