/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  hyperlink.cc - AtkHyperlink C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "hyperlink.h"
#include "private/hyperlink_p.h"
#include "private/action_p.h"
#include "object.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::Hyperlink
 */

Atk::Hyperlink::Hyperlink(AtkHyperlink *hyperlink, bool reference)
: G::Object((GObject*)hyperlink, reference)
{
}
	
Atk::Hyperlink::~Hyperlink() 
{
}
	
AtkHyperlinkClass* 
Atk::Hyperlink::atk_hyperlink_class() const 
{ 
	return get_class<AtkHyperlinkClass>(); 
}
	
Atk::Hyperlink::operator AtkHyperlink* () const 
{ 
	return this ? atk_hyperlink() : 0; 
}
	
String 
Atk::Hyperlink::get_uri(int i) const
{
	char *uri = atk_hyperlink_get_uri(atk_hyperlink(), i);
	String s(uri);
	g_free(uri);
	return s;
}

Atk::Object*
Atk::Hyperlink::get_object(int i) const
{
	AtkObject *object = atk_hyperlink_get_object(atk_hyperlink(), i);
	return object ? G::Object::wrap<Atk::Object>(object) : 0;
}

int 
Atk::Hyperlink::get_end_index() const
{
	return atk_hyperlink_get_end_index(atk_hyperlink());
}

int 
Atk::Hyperlink::get_start_index() const
{
	return atk_hyperlink_get_start_index(atk_hyperlink());
}

bool 
Atk::Hyperlink::is_valid() const
{
	return atk_hyperlink_is_valid(atk_hyperlink()) != 0;
}

bool 
Atk::Hyperlink::is_inline() const
{
	return atk_hyperlink_is_inline(atk_hyperlink());
}

int
Atk::Hyperlink::get_n_anchors() const
{
	return atk_hyperlink_get_n_anchors(atk_hyperlink());
}

/*  Atk::HyperlinkClass
 */

void
Atk::HyperlinkClass::init(AtkHyperlinkClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
	g_class->get_uri = &get_uri_proxy;
	g_class->get_object = &get_object_proxy;
	g_class->get_end_index = &get_end_index_proxy;
	g_class->get_start_index = &get_start_index_proxy;
	g_class->is_valid = &is_valid_proxy;
	g_class->get_n_anchors = &get_n_anchors_proxy;
	g_class->link_state = &link_state_proxy;
}

GType
Atk::HyperlinkClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_HYPERLINK, (GClassInitFunc)init);
		G::TypeInstance::add_interface(type, ATK_TYPE_ACTION, (GInterfaceInitFunc)ActionIface::init);
	}
	return type;
}

void*
Atk::HyperlinkClass::create()
{
	return g_object_new(get_type(), 0);
}

gchar*
Atk::HyperlinkClass::get_uri_proxy(AtkHyperlink *link, gint i)
{
	gchar *result = 0;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_get_uri(i);
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->get_uri)
			result = g_class->get_uri(link, i);
	}
	return result;
}

AtkObject*
Atk::HyperlinkClass::get_object_proxy(AtkHyperlink *link, gint i)
{
	AtkObject *result = 0;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_get_object(i);
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->get_object)
			result = g_class->get_object(link, i);
	}
	return result;
}

gint
Atk::HyperlinkClass::get_end_index_proxy(AtkHyperlink *link)
{
	gint result = 0;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_get_end_index();
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->get_end_index)
			result = g_class->get_end_index(link);
	}
	return result;
}

gint
Atk::HyperlinkClass::get_start_index_proxy(AtkHyperlink *link)
{
	gint result = 0;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_get_start_index();
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->get_start_index)
			result = g_class->get_start_index(link);
	}
	return result;
}

gboolean
Atk::HyperlinkClass::is_valid_proxy(AtkHyperlink *link)
{
	gboolean result = FALSE;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_is_valid();
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->is_valid)
			result = g_class->is_valid(link);
	}
	return result;
}

gint
Atk::HyperlinkClass::get_n_anchors_proxy(AtkHyperlink *link)
{
	gint result = 0;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_get_n_anchors();
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->get_n_anchors)
			result = g_class->get_n_anchors(link);
	}
	return result;
}

guint
Atk::HyperlinkClass::link_state_proxy(AtkHyperlink *link)
{
	guint result = 0;
	Atk::Hyperlink *tmp_link = G::Object::pointer<Atk::Hyperlink>(link);
	if (tmp_link)
		result = tmp_link->do_link_state();
	else
	{
		AtkHyperlinkClass *g_class = G::TypeInstance::class_peek_parent<AtkHyperlinkClass>(ATK_HYPERLINK_GET_CLASS(link));
		if (g_class->link_state)
			result = g_class->link_state(link);
	}
	return result;
}

/*  Overridable methods
 */

char*
Atk::Hyperlink::do_get_uri(int i)
{
	char *result = 0;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->get_uri)
		result = g_class->get_uri(atk_hyperlink(), i);
	return result;
}

AtkObject*
Atk::Hyperlink::do_get_object(int i)
{
	AtkObject *result = 0;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->get_object)
		result = g_class->get_object(atk_hyperlink(), i);
	return result;
}

int
Atk::Hyperlink::do_get_end_index()
{
	int result = 0;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->get_end_index)
		result = g_class->get_end_index(atk_hyperlink());
	return result;
}

int
Atk::Hyperlink::do_get_start_index()
{
	int result = 0;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->get_start_index)
		result = g_class->get_start_index(atk_hyperlink());
	return result;
}

bool
Atk::Hyperlink::do_is_valid()
{
	bool result = false;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->is_valid)
		result = g_class->is_valid(atk_hyperlink());
	return result;
}

int
Atk::Hyperlink::do_get_n_anchors()
{
	int result = 0;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->get_n_anchors)
		result = g_class->get_n_anchors(atk_hyperlink());
	return result;
}

unsigned int
Atk::Hyperlink::do_link_state()
{
	unsigned int result = 0;
	AtkHyperlinkClass *g_class = class_peek_parent<AtkHyperlinkClass>(atk_hyperlink_class());
	if (g_class->link_state)
		result = g_class->link_state(atk_hyperlink());
	return result;
}

