/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  liststore.cc - GtkListStore C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "liststore.h"
#include "private/liststore_p.h"
#include "private/treemodel_p.h"
#include "private/treesortable_p.h"
#include "../glib/value.h"

using namespace Inti;

/*  Gtk::ListStore
 */

Gtk::ListStore::ListStore(GtkListStore *list_store, bool reference)
: G::Object((GObject*)list_store, reference)
{
}

Gtk::ListStore::ListStore(int n_columns, ...)
: G::Object((GObject*)ListStoreClass::create())
{
	g_return_if_fail(n_columns > 0);
	va_list args;
	va_start(args, n_columns);
	GType *types = new GType[n_columns];

	int i = 0;
	while (i < n_columns)
	{
		types[i] = va_arg(args, GType);
		++i;
	}

	gtk_list_store_set_column_types(gtk_list_store(), n_columns, types);
	delete [] types;
	va_end(args);
}

Gtk::ListStore::ListStore(const std::vector<GType>& types)
: G::Object((GObject*)ListStoreClass::create())
{
	gtk_list_store_set_column_types(gtk_list_store(), types.size(), const_cast<GType*>(&types[0]));
}

Gtk::ListStore::~ListStore()
{
}

GtkListStoreClass* 
Gtk::ListStore::gtk_list_store_class() const 
{ 
	return get_class<GtkListStoreClass>(); 
}

Gtk::ListStore::operator GtkListStore* () const 
{ 
	return this ? gtk_list_store() : 0; 
}
	
bool
Gtk::ListStore::iter_is_valid(const TreeIter& iter) const
{
	return gtk_list_store_iter_is_valid(gtk_list_store(), iter.gtk_tree_iter());
}

Gtk::TreeIter
Gtk::ListStore::append()
{
	GtkTreeIter iter;
	gtk_list_store_append(gtk_list_store(), &iter);
	return TreeIter(&iter, true);
}

Gtk::TreeIter
Gtk::ListStore::prepend()
{
	GtkTreeIter iter;
	gtk_list_store_prepend(gtk_list_store(), &iter);
	return TreeIter(&iter, true);
}

Gtk::TreeIter
Gtk::ListStore::insert(int position)
{
	GtkTreeIter iter;
	gtk_list_store_insert(gtk_list_store(), &iter, position);
	return TreeIter(&iter, true);
}

Gtk::TreeIter
Gtk::ListStore::insert_before(TreeIter& sibling)
{
	GtkTreeIter iter;
	gtk_list_store_insert_before(gtk_list_store(), &iter, sibling.gtk_tree_iter());
	return TreeIter(&iter, true);
}

Gtk::TreeIter
Gtk::ListStore::insert_after(TreeIter& sibling)
{
	GtkTreeIter iter;
	gtk_list_store_insert_after(gtk_list_store(), &iter, sibling.gtk_tree_iter());
	return TreeIter(&iter, true);
}

bool
Gtk::ListStore::remove(TreeIter& iter)
{
	return gtk_list_store_remove(gtk_list_store(), iter.gtk_tree_iter());
}

void
Gtk::ListStore::clear()
{
	gtk_list_store_clear(gtk_list_store());
}

void 
Gtk::ListStore::reorder(int *new_order)
{
	gtk_list_store_reorder(gtk_list_store(), new_order);
}

void 
Gtk::ListStore::swap(const TreeIter& a, const TreeIter& b)
{
	gtk_list_store_swap(gtk_list_store(), a.gtk_tree_iter(), b.gtk_tree_iter());
}

void 
Gtk::ListStore::move_after(const TreeIter& iter, const TreeIter *position)
{
	gtk_list_store_move_after(gtk_list_store(), iter.gtk_tree_iter(), *position);
}

void 
Gtk::ListStore::move_before(const TreeIter& iter, const TreeIter *position)
{
	gtk_list_store_move_before(gtk_list_store(), iter.gtk_tree_iter(), *position);
}

void
Gtk::ListStore::set_value(const TreeIter& iter, int column, const G::Value& value)
{
	gtk_list_store_set_value(gtk_list_store(), iter.gtk_tree_iter(), column, value.g_value());
}

void
Gtk::ListStore::set_value(const TreeIter& iter, int column, const char *str)
{
	G::Value value(gtk_list_store()->column_headers[column]);
	value.set(String(str));
	gtk_list_store_set_value(gtk_list_store(), iter, column, value.g_value());
}

/*  Gtk::ListStoreClass
 */

void
Gtk::ListStoreClass::init(GtkListStoreClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Gtk::ListStoreClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_LIST_STORE, (GClassInitFunc)init);
		G::TypeInstance::add_interface(type, GTK_TYPE_TREE_MODEL, (GInterfaceInitFunc)TreeModelIface::init);
		G::TypeInstance::add_interface(type, GTK_TYPE_TREE_SORTABLE, (GInterfaceInitFunc)TreeSortableIface::init);
	}
	return type;
}

void*
Gtk::ListStoreClass::create()
{
	return g_object_new(get_type(), 0);
}

