/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  socket.cc - GtkSocket C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "socket.h"
#include "private/socket_p.h"
#include "../gdk/window.h"

using namespace Inti;

/*  Gtk::Socket
 */

Gtk::Socket::Socket(GtkSocket *socket, bool reference) 
: Container((GtkContainer*)socket, reference)
{
}

Gtk::Socket::Socket()
: Container((GtkContainer*)SocketClass::create())
{
}

Gtk::Socket::~Socket()
{
}

GtkSocketClass*
Gtk::Socket::gtk_socket_class() const 
{
	return get_class<GtkSocketClass>(); 
}

Gtk::Socket::operator GtkSocket* () const 
{ 
	return this ? gtk_socket() : 0; 
}	

bool
Gtk::Socket::has_plug() const
{
	return GDK_IS_WINDOW(gtk_socket()->plug_window);
}


Gdk::Window* 
Gtk::Socket::plug_window() const
{
	return G::Object::wrap<Gdk::Window>(gtk_socket()->plug_window);
}

Gtk::Widget* 
Gtk::Socket::plug_widget() const
{
	return G::Object::wrap<Widget>(gtk_socket()->plug_widget);
}

bool 
Gtk::Socket::same_app() const
{
	return gtk_socket()->same_app;
}

GdkNativeWindow 
Gtk::Socket::get_id() const
{
	return gtk_socket_get_id(gtk_socket());
}
	
void 
Gtk::Socket::add_id(GdkNativeWindow window_id)
{
	gtk_socket_add_id(gtk_socket(), window_id);
}

/*  Gtk::SocketClass
 */

void
Gtk::SocketClass::init(GtkSocketClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
	g_class->plug_added = &plug_added_proxy;
	g_class->plug_removed = &plug_removed_proxy;
}

GType
Gtk::SocketClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SOCKET, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::SocketClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::SocketClass::plug_added_proxy(GtkSocket *socket)
{
	Socket *tmp_socket = G::Object::pointer<Socket>(socket);
	if (tmp_socket)
		tmp_socket->on_plug_added();
	else
	{
		GtkSocketClass *g_class = G::TypeInstance::class_peek_parent<GtkSocketClass>(GTK_SOCKET_GET_CLASS(socket));
		if (g_class->plug_added)
			g_class->plug_added(socket);
	}
}

gboolean
Gtk::SocketClass::plug_removed_proxy(GtkSocket *socket)
{
	Socket *tmp_socket = G::Object::pointer<Socket>(socket);
	gboolean result = FALSE;
	if (tmp_socket)
		result = tmp_socket->on_plug_removed();
	else
	{
		GtkSocketClass *g_class = G::TypeInstance::class_peek_parent<GtkSocketClass>(GTK_SOCKET_GET_CLASS(socket));
		if (g_class->plug_removed)
			result = g_class->plug_removed(socket);
	}
	return result;
}

/*  Signal handlers
 */

void
Gtk::Socket::on_plug_added()
{
	GtkSocketClass *g_class = class_peek_parent<GtkSocketClass>(gtk_socket_class());
	if (g_class->plug_added)
		g_class->plug_added(gtk_socket());
}

bool
Gtk::Socket::on_plug_removed()
{
	GtkSocketClass *g_class = class_peek_parent<GtkSocketClass>(gtk_socket_class());
	bool result = false;
	if (g_class->plug_removed)
		result = g_class->plug_removed(gtk_socket());
	return result;
}

/*  Signals
 */

const Gtk::Socket::PlugAddedSignalType Gtk::Socket::plug_added_signal("plug_added");

const Gtk::Socket::PlugRemovedSignalType Gtk::Socket::plug_removed_signal("plug_removed");

