/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/gtk/tearoffmenuitem.h
//! @brief A GtkTable C++ wrapper interface.
//!
//! Provides TearoffMenuItem, a special MenuItem which is used to tear off and reattach its menu.

#ifndef INTI_GTK_MENU_TEAROFF_ITEM_H
#define INTI_GTK_MENU_TEAROFF_ITEM_H

#ifndef INTI_GTK_MENU_ITEM_H
#include <inti/gtk/menuitem.h>
#endif

#ifndef __GTK_MENU_TEAROFF_ITEM_H__
#include <gtk/gtktearoffmenuitem.h>
#endif

namespace Inti {

namespace Gtk {

class TearoffMenuItemClass;

//! @class TearoffMenuItem tearoffmenuitem.h inti/gtk/tearoffmenuitem.h
//! @brief A GtkTearoffMenuItem C++ wrapper class.
//!
//! TearoffMenuItem is a special MenuItem which is used to tear off and reattach its menu.
//! When its menu is shown normally, the TearoffMenuItem is drawn as a dotted line indicating
//! that the menu can be torn off. Activating it causes its menu to be torn off and displayed
//! in its own window as a tearoff menu. When its menu is shown as a tearoff menu, the 
//! TearoffMenuItem is drawn as a dotted line which has a left pointing arrow graphic 
//! indicating that the tearoff menu can be reattached. Activating it will erase the tearoff
//! menu window.

class TearoffMenuItem : public MenuItem
{
	friend class G::Object;
	friend class TearoffMenuItemClass;

	TearoffMenuItem(const TearoffMenuItem&);
	TearoffMenuItem& operator=(const TearoffMenuItem&);
	
protected:
//! @name Constructors
//! @{

	explicit TearoffMenuItem(GtkTearoffMenuItem *tearoff_menu_item, bool reference = false);
	//!< Construct a new TearoffMenuItem from an existing GtkTearoffMenuItem.
	//!< @param tearoff_menu_item A pointer to a GtkTearoffMenuItem.
	//!< @param reference Set false if the initial reference count is floating, set true if it's not.
	//!<
	//!< <BR>The <EM>tearoff_menu_item</EM> can be a newly created GtkTearoffMenuItem or an existing
	//!< GtkTearoffMenuItem (see G::Object::Object).

//! @}

public:
//! @name Constructors
//! @{

	TearoffMenuItem();
	//!< Construct a new tearoff menu item.

	virtual ~TearoffMenuItem();
	//!< Destructor.
	
//! @}
//! @name Accessors
//! @{

	GtkTearoffMenuItem* gtk_tearoff_menu_item() const { return (GtkTearoffMenuItem*)instance; }
	//!< Get a pointer to the GtkTearoffMenuItem structure.

	GtkTearoffMenuItemClass* gtk_tearoff_menu_item_class() const;
	//!< Get a pointer to the GtkTearoffMenuItemClass structure.

	operator GtkTearoffMenuItem* () const;
	//!< Conversion operator; safely converts a TearoffMenuItem to a GtkTearoffMenuItem pointer.

	bool is_torn_off() const;
	//!< Returns true if the tearoff menu item is torn off.
	
//! @}
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_MENU_TEAROFF_ITEM_H

