#ifndef __LIBJACKOSS_H__
#define __LIBJACKOSS_H__
#include <sys/types.h>
#include <sys/poll.h>

#ifdef __cplusplus
extern "C" {
#endif

  int jackoss_open(const char* name,int flags, ...);
  int jackoss_ioctl(int handle, unsigned long int flag, ... );
  ssize_t jackoss_write(int handle, const void* buf, size_t len);
  ssize_t jackoss_read(int handle, void* buf, size_t len);
  int jackoss_close(int handle);
  int jackoss_select(int  n,  fd_set  *readfds,  
		       fd_set *writefds, 
		     fd_set *exceptfds, struct timeval *timeout);
  int jackoss_poll (struct pollfd *__fds, nfds_t __nfds, int __timeout);
  /* these are mainly need for sox */

  FILE * jackoss_fopen (const char *pathname, const char *mode);
  size_t  jackoss_fread(void *ptr, size_t size, size_t nmemb, FILE*stream);
  size_t jackoss_fwrite( const void *ptr, size_t size, size_t nmemb,FILE *stream);


#ifdef LD_PRELOAD
#define jackoss_open   open
#define jackoss_ioctl  ioctl
#define jackoss_write  write
#define jackoss_close  close
#define jackoss_read   read
#define jackoss_select select
#define jackoss_poll   poll
#if 0
#define jackoss_exit   _exit
#endif
#define jackoss_fread  fread
#define jackoss_fwrite fwrite
#define jackoss_fopen  fopen

#else

#ifndef NOMAP // some C++ programs dont allow for this trick
  #define open(a,b...) jackoss_open(a, ## b)
  #define ioctl(a,b,c) jackoss_ioctl(a,b,c)
  #define write(a,b,c) jackoss_write(a,b,c)
  #define close(a) jackoss_close(a)
  #define read(a,b,c) jackoss_read(a,b,c)
  #define select(a,b,c,d,e) jackoss_select(a,b,c,d,e)
  #define poll(a,b,c) jackoss_poll(a,b,c)
#endif // NOMAP
#endif // LD_PRELOAD

#endif


#ifdef __cplusplus
}
#endif
