/***************************************************************************
 $RCSfile: accountimpl.cpp,v $
 -------------------
 cvs         : $Id: accountimpl.cpp,v 1.13 2003/07/02 23:07:05 aquamaniac Exp $
 begin       : Thu Nov 29 2001
 copyright   : (C) 2001 by Martin Preuss
 email       : openhbci@aquamaniac.de


 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include "accountimpl.h"
#include "standingorder.h"
#include <algorithm>
#include <cctype>

namespace HBCI {

/*AccountImpl::AccountImpl(Pointer<Bank> b)
    :Account()
    ,accountParams()
    ,_bankImpl(b.cast<BankImpl>())
    ,_managed(false)
{
    _bankImpl.setDescription("AccountImpl::_bankImpl");
    }*/

AccountImpl::AccountImpl(Pointer<BankImpl> b)
    :Account()
    ,accountParams()
    ,_bankImpl(b)
    ,_managed(false)
{
    _bankImpl.setDescription("AccountImpl::_bankImpl");
}


AccountImpl::AccountImpl(Pointer<Bank> b, 
				 const accountParams &p)
:Account()
,accountParams(p)
,_bankImpl(b.cast<BankImpl>())
,_managed(false)
{
    _bankImpl.setDescription("AccountImpl::_bankImpl");
}

AccountImpl::AccountImpl(Pointer<BankImpl> b, 
				 const accountParams &p)
    :Account()
     ,accountParams(p)
     ,_bankImpl(b)
     ,_managed(false)
{
    _bankImpl.setDescription("AccountImpl::_bankImpl");
}


AccountImpl::AccountImpl(Pointer<Bank> b,
                         const string &nr,
                         const string &subid)
    :Account()
    ,accountParams(b.ref().countryCode(),
       	           b.ref().bankCode(),
		   nr,subid)
    ,_bankImpl(b.cast<BankImpl>())
{
    _bankImpl.setDescription("AccountImpl::_bankImpl");
}

AccountImpl::AccountImpl(Pointer<BankImpl> b,
                         const string &nr,
                         const string &subid)
    :Account()
     ,accountParams(b.ref().countryCode(),
		    b.ref().bankCode(),
		    nr,subid)
     ,_bankImpl(b)
{
    _bankImpl.setDescription("AccountImpl::_bankImpl");
}



AccountImpl::~AccountImpl(){
    //fprintf(stderr,"AccountImpl::~AccountImpl\n");
}


/*void AccountImpl::clear(){
  _bankImpl=0;
  //_transactions.clear(); -- really not necessary due to by-value allocation here
  //_standingOrders.clear();
  _auth.clear();
  }*/



Pointer<Bank> AccountImpl::bank() const
{
    return _bankImpl.cast<Bank>();
}


Account &AccountImpl::operator=(const accountParams &p){
    static_cast<accountParams&>(*this)=p;
    return *this;
}



const list<Pointer<Customer> > &
AccountImpl::authorizedCustomers() const 
{
    return _auth;
}


void AccountImpl::addAuthorizedCustomer(Pointer<Customer> c){
    list<Pointer<Customer> >::const_iterator it;

    for (it=_auth.begin(); it!=_auth.end(); it++) {
        // first check if this Pointer already is listed
        if ((*it)==c)
            /* it is, since this is exactly the same pointer there
             * is no problem */
            return;
        if ((*it).ref().custId()==c.ref().custId())
            throw Error("AccountImpl::addAccount()",
                            ERROR_LEVEL_INTERNAL,
                            0,
                            ERROR_ADVISE_DONTKNOW,
                            "signer already exists, "
                            "please check your program");
    } // for
    _auth.push_back(c);
}


bool AccountImpl::isAuthorized(const Pointer<Customer> c) 
    const 
{
    list<Pointer<Customer> >::const_iterator it;

    for (it=_auth.begin(); it!=_auth.end(); it++) {
        if ((*it)==c)
            return true;
    } // for
    return false;
}


void AccountImpl::removeAuthorizedCustomer(Pointer<Customer> c){
    list<Pointer<Customer> >::iterator it;

    for (it=_auth.begin(); it!=_auth.end(); it++) {
        if ((*it)==c) {
            _auth.erase(it);
            break;
        }
    } // for
}


const list<Transaction> &AccountImpl::transactions() const{
  return _transactions;
}


void AccountImpl::clearTransactions(){
  _transactions.clear();
}


void AccountImpl::addTransaction(const Transaction &t) {
    list<Transaction>::reverse_iterator it3;
    list<Transaction>::iterator it2;
    int i;

    Date d1, d2;
    bool inserted;

    // otherwise insert transaction
    inserted=false;
    i=0;
    for (it2=_transactions.begin();
         it2!=_transactions.end();
         it2++) {
        d1=(*it2).valutaDate();
        if (!d1.isValid())
            d1=(*it2).date();

        d2=t.valutaDate();
        if (!d2.isValid())
            d2=t.date();

        if (d1>d2) {
            // insert before the current
            if (!i)
                // if current is the first then push_front
                _transactions.push_front(t);
            else {
                // otherwise insert before current
                it2--;
                _transactions.insert(it2,t);
            }
            inserted=true;
            break;
        }
        i++;
    } // for it3

    if (!inserted)
        _transactions.push_back(t);
}


const list<StandingOrder> &AccountImpl::standingOrders() const{
  return _standingOrders;
}


void AccountImpl::clearStandingOrders(){
  _standingOrders.clear();
}


void AccountImpl::addStandingOrder(const StandingOrder &o){
    list<StandingOrder>::iterator it;

    // first check, if the STO already exists
    for (it=_standingOrders.begin();
         it!=_standingOrders.end();
         it++) {
        if ((*it).jobIdentification()==o.jobIdentification()) {
            // overwrite existin STO
            *it=o;
            return;
        } // if same STO
    } // for

    // otherwise append new STO
    _standingOrders.push_back(o);
}

const updJob *AccountImpl::updForJob(const string jobId) const {
    list<updJob> allAllowedJobs = allowedJobs();
	list<updJob>::iterator jobIt;

	// if the job can't be found, we return a NULL-pointer
	updJob *result = NULL;
	string ucaseJobId = "";
	for (unsigned i=0; i<jobId.length(); i++)
	  ucaseJobId += toupper(jobId.at(i));

	for (jobIt = allAllowedJobs.begin(); jobIt != allAllowedJobs.end(); 
		 jobIt++) {

	  if ((*jobIt).segmentCode() == ucaseJobId) {
		result = &(*jobIt);
		break;
	  }
	}

	return result;
}

const Limit &AccountImpl::limit() {
  LimitType type = Limit::typeFromChar(limitType());

  _limit = Limit(limitValue(),
		 type,
		 limitDays());

  return _limit;
}


const Transaction *AccountImpl::findTransaction (const Transaction &t) const {
  list<Transaction>::const_iterator it;

  for (it=_transactions.begin();
       it!=_transactions.end();
       it++) {
    if ((*it)==t)
      return &(*it);
  } // for

  return 0;
}


void AccountImpl::removeTransaction(const Transaction &t){
  list<Transaction>::iterator it;
  bool goon;

  goon=true;
  while(goon) {
    goon=false;
    for (it=_transactions.begin();
	 it!=_transactions.end();
	 it++) {
      if ((*it)==t) {
	_transactions.erase(it);
	goon=true;
	break;
      }
    } // for
  } // while
}



} // namespace HBCI
