/***************************************************************************
 $RCSfile: accountparams.cpp,v $
                             -------------------
    cvs         : $Id: accountparams.cpp,v 1.10 2002/08/02 09:29:29 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include <string>
#include <list>
#include "error.h"
#include "pointer.h"
#include "date.h"
#include "value.h"
#include "balance.h"
#include "auth.h"
#include "interactor.h"
#include "hbci.h"
#include "hbcistring.h"
#include "bpdjob.h"
#include "bankparams.h"
#include "accountparams.h"
#include "userparams.h"
#include "user.h"
#include "accountparams.h"
#include "updjob.h"
#include "bank.h"


namespace HBCI {

accountParams::accountParams()
:_countryCode(280)
,_limitType(0)
,_limitDays(0){
}


accountParams::accountParams(int c, const string &inst,
                             const string &nr,
                             const string &subid)
:_accountNumber(nr)
    ,_accountSuffix(subid)
,_countryCode(c)
,_instituteCode(inst)
,_limitType(0)
,_limitDays(0)
{
}


accountParams::accountParams(const accountParams &p)
{
    *this=p;
}


accountParams::~accountParams(){
}


const list<updJob> &accountParams::allowedJobs() const {
    return _allowedJobs;
}


void accountParams::addJob(const updJob &u){
    _allowedJobs.push_back(u);
}


string accountParams::dump() const {
    string result;

    result+="Account Number : ";
    result+=_accountNumber+"\n";
    result+="Account Suffix : ";
    result+=_accountSuffix+"\n";
    result+="Country Code   : ";
    result+=String::num2string(_countryCode)+"\n";
    result+="Institute Code : ";
    result+=_instituteCode+"\n";
    result+="User Id        : ";
    result+=_userId+"\n";
    result+="Name 1         : ";
    result+=_name1+"\n";
    result+="Name 2         : ";
    result+=_name2+"\n";
    result+="Account Name   : ";
    result+=_accountName+"\n";
    result+="Currency       : ";
    result+=_currency+"\n";
    result+="Limit Type     : ";
    result+=_limitType;
    result+="\n";
    result+="Limit Days     : ";
    result+=String::num2string(_limitDays)+"\n";
    result+="Number Of Allowed Jobs: ";
    result+=String::num2string(_allowedJobs.size())+"\n";
    return result;
}

} // namespace HBCI


