/***************************************************************************
 $RCSfile: adminsegs.h,v $
                             -------------------
    cvs         : $Id: adminsegs.h,v 1.19 2003/05/20 14:44:00 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */

#ifndef ADMINSEGS_H
#define ADMINSEGS_H


#include <string>

#include <openhbci/pointer.h>
#include <openhbci/seg.h>
#include <openhbci/user.h>
#include <openhbci/rsakey.h>
#include <openhbci/bpdjob.h>
#include <openhbci/bankparams.h>
#include <openhbci/accountparams.h>
#include <openhbci/messagequeue.h>
#include <openhbci/statusreport.h>

namespace HBCI {

/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGMessageHead: public Seg {
private:
    int _msgnumber;
    string _dialogid;
    int _referenceid;

public:
    SEGMessageHead(Pointer<Customer> cust);
    ~SEGMessageHead();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);
    void setData(int msgnumber, string dialogid);
    void setSize(string &message);
    string dialogId() { return _dialogid;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGMessageTail: public Seg {
private:
    int _msgnumber;

public:
    SEGMessageTail(Pointer<Customer> cust);
    ~SEGMessageTail();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);
    void setData(int msgnumber);
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGSignatureHead: public Seg {
private:
  string _controlref;
  int _signkeynumber;
  int _signkeyversion;
  bool _sync;

public:
  SEGSignatureHead(Pointer<Customer> cust, bool sync=false);
  ~SEGSignatureHead();

  string toString(int segnr);
  bool parse(const string& segment, unsigned int pos);
  void setData(string &ctrlref);
  int signKeyNumber();
  int signKeyVersion();
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGSignatureTail: public Seg {
private:
    string _controlref;
    string _signature;

public:
    SEGSignatureTail(Pointer<Customer> cust);
    ~SEGSignatureTail();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);
    void setData(string &ctrlref, string &signature);
    string signature();
    string controlReference();

};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGIdentification: public Seg {
private:
  string _instcode;
  string _userid;
  string _systemid;
  bool _anonymous;
  bool _sync;
  string _specialid;

public:
  SEGIdentification(Pointer<Customer> cust, bool sync=false);
  ~SEGIdentification();

  string toString(int segnr);
  bool parse(const string& segment, unsigned int pos);

  void setData(bool anon, string specialid);
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGPreProcessing: public Seg {
private:

public:
    SEGPreProcessing(Pointer<Customer> cust);
    ~SEGPreProcessing();

    string toString(int segnr);
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGGetInstKey: public Seg {
private:
    int _oldkn;
    int _oldkv;
    bool _signkey;
    string _specialuserid;

public:
    SEGGetInstKey(Pointer<Customer> cust);
    ~SEGGetInstKey();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);

    void setData(bool signkey,
                 int oldkeynumber,
                 int oldkeyversion,
                 string specialuserid="");
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGCryptedHead: public Seg {
private:
  string _cryptedkey;
  bool _sync;
public:
  SEGCryptedHead(Pointer<Customer> cust, bool sync=false);
  ~SEGCryptedHead();

  string toString(int segnr);
  bool parse(const string& segment, unsigned int pos);

  void setData(string cryptedkey);
  string cryptedKey() { return _cryptedkey;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGCryptedData: public Seg {
private:
    string _data;

public:
    SEGCryptedData(Pointer<Customer> cust);
    ~SEGCryptedData();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);

    void setData(string data);
    string data() { return _data;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGSynchronize: public Seg {
private:
    int _mode;

public:
    SEGSynchronize(Pointer<Customer> cust);
    ~SEGSynchronize();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);

    void setData(int mode);
    int mode() { return _mode;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGPublicKeyChange: public Seg {
private:
    Pointer<RSAKey> _key;
    Pointer<RSAKey> _parsedkey;

public:
    SEGPublicKeyChange(Pointer<Customer> cust);
    ~SEGPublicKeyChange();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);

    void setKey(Pointer<RSAKey> key) { _key=key;};
    Pointer<RSAKey> key() { return _parsedkey;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGDialogEnd: public Seg {
private:
    string _dialogid;

public:
    SEGDialogEnd(Pointer<Customer> cust);
    ~SEGDialogEnd();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);

    void setData(string dialogid);
    string dialogId() { return _dialogid;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGInstituteParameter: public Seg {
private:
    bpd _bpd;

public:
    SEGInstituteParameter(Pointer<Customer> cust);
    ~SEGInstituteParameter();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos);

    bpd getData() { return _bpd;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGComParameter: public Seg {
private:
    bpdCom _bpdcom;

public:
    SEGComParameter(Pointer<Customer> cust);
    ~SEGComParameter();

    string toString(int segnr) { return ""; };
    bool parse(const string& segment, unsigned int pos);

    bpdCom getData() { return _bpdcom;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGSupportedJob: public Seg {
private:
    bpdJob _bpdjob;

public:
    SEGSupportedJob(Pointer<Customer> cust);
    ~SEGSupportedJob();

    string toString(int segnr) { return ""; };
    bool parse(const string& segment, unsigned int pos);
    bpdJob getData() { return _bpdjob;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGUserParameter: public Seg {
private:
    accountParams _acc;

public:
    SEGUserParameter(Pointer<Customer> cust);
    ~SEGUserParameter();

    string toString(int segnr) { return ""; };
    bool parse(const string& segment, unsigned int pos);

    accountParams getData() { return _acc;};
};



/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGPublicKeyDisable: public Seg {
private:
	int _keyNumber;
	int _keyVersion;

public:
    SEGPublicKeyDisable(Pointer<Customer> cust);
    ~SEGPublicKeyDisable();

    string toString(int segnr);
    bool parse(const string& segment, unsigned int pos) { return false;};

    void setData(Pointer<RSAKey> key);
	void setData(int keyNumber=999, int keyVersion=999) {
	  _keyNumber = keyNumber; 
	  _keyVersion = keyVersion;};
};


/**
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT SEGPublicKeyReturn: public Seg {
private:
    Pointer<RSAKey> _key;

public:
    SEGPublicKeyReturn(Pointer<Customer> cust);
    ~SEGPublicKeyReturn();

    string toString(int segnr) { return "";};
    bool parse(const string& segment, unsigned int pos);

    Pointer<RSAKey> getKey() { return _key;};
};


/**
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT SEGGetStatusReport: public Seg {
private:
  Date _fromdate;
  Date _todate;
  int _maxEntries;
  string _attachPoint;

public:
  SEGGetStatusReport(Pointer<Customer> cust);
  ~SEGGetStatusReport();

  string toString(int segnr);

  void setData(Date fromDate,
	       Date toDate,
	       int maxEntries=-1,
	       string attachPoint = "");

};


/**
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DLLIMPORT SEGStatusReport: public Seg {
private:
  StatusReport _rep;

public:
  SEGStatusReport(Pointer<Customer> cust);
  ~SEGStatusReport();

  bool parse(const string& segment, unsigned int pos);

  const StatusReport &statusReport() const { return _rep;};
};



} /* namespace HBCI */

#endif




