/***************************************************************************
                          hbciconnection.h  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */


#ifndef HBCICONNECTION_H
#define HBCICONNECTION_H

#include <string>
#include <time.h>

#include <openhbci/dllimport.h>
#include <openhbci/inetaddress.h>
#include <openhbci/socket.h>
#include <openhbci/messagequeue.h>


/**
 * Timeout in seconds
 */
#define CONNECTION_DEFAULT_TIMEOUT 30

using namespace std;
/* forward declarations */
namespace HBCI {
  class MessageQueue;
}

namespace HBCI {

/**
 * @short This class represents the connection to the bank server.
 *
 * Get an instance of this class by directly creating an object via
 * new, or by calling Institute->getConnection().
 * @author fabian kaiser */
class DLLIMPORT Connection {
private:
    bool sendData(string data);
    bool recieveData();
    int _next_message_number;

    Pointer<MessageQueue> mBox;
    int tcpPort;
    string response;
    Hbci *_hbci;

    Socket _sock;
    InetAddress _addr;
    static time_t _timeout;

public:
    /**
     * Create a connection to specified remote server
     * @author Fabian Kaiser <fabian.kaiser@gmx.de>
     * @param hbci pointer to the hbci object of your application. This is
     * needed to make keepAlive-calls that give the user the opportunity to
     * abort long term jobs.
     * @param internetHost ip address of the institute's server
     * @param tcpIpPort port that the server is listening on (defaults to
     * the standard HBCI port, which is 3000).
     */
    Connection(Hbci *hbci, string internetHost, int tcpIpPort=3000);

    ~Connection();

    /** opens the connection <br> <b>false</b> is returned if opening fails<br><b>true</b> else */
    Error open();
    /** close the connection */
    bool close();
    /** determine whether the connection is still open or if it was closed */
    //bool stillOpen();
    /** send the jobs queued in specified messagebox  <br> <b>false</b> is returned if an error occured during transmission<br><b>true</b> else */
    bool sendMessage(Pointer<MessageQueue> jobs);
    /** */
    bool getResponse();

    /**
     * Return the current timeout for socket operations in seconds
     */
    static time_t timeout() { return _timeout;};

    /** set max timeout value for socket operations (defaults to 30 secs) */
    static void setTimeOut(time_t t);
};

} /* namespace HBCI */
#endif
